package com.digiwin.mobile.mobileuibot.core.component.button;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceAccessRecord;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmDataReport;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotActionExtendParas;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import lombok.Data;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.StringUtils;

import java.net.URLEncoder;
import java.util.*;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BottomButton
 * @Author: Zaregoto
 * @Date: 2021/5/20 14:54
 */
@Data
public class BottomButtonDigiwinAthena extends Button<ButtonRawData> {
    private static final long serialVersionUID = 4422888883303364718L;
    public static final String COMPONENT_TYPE = "BOTTOM_BUTTON";

    // TODO 是否应该挪到父类中
    protected Integer iconData;
    protected List<BottomButtonDigiwinAthena> children = new ArrayList<>();
    /**
     * icon前景色.格式支持RGB或ARGB的HEX值，前端会判断若没有A则在前面补上FF。如
     * 1. 后端给#C6C6C6，前端使用时则会变成#FFC6C6C6
     * 2. 后端给#0089A0CA
     */
    protected String iconColor;

    /**
     * 背景颜色
     */
    protected String bgColor;

    /**
     * 图片代号
     */
    protected String image;

    /**
     * 图片地址，用于入口组件
     */
    protected String imageUrl;
    /**
     * 图片地址,用于绿色智机项目
     */
    protected String iconUrl;
    /**
     * 是否置灰
     */
    protected Boolean enable = true;

    public BottomButtonDigiwinAthena() {
    }

    public static BottomButtonDigiwinAthena create(Integer styleType, String name) {
        BottomButtonDigiwinAthena bottomButton = new BottomButtonDigiwinAthena();
        bottomButton.setType(styleType);
        bottomButton.setName(name);

        return bottomButton;
    }

    /**
     * 返回一个有icon的按钮
     *
     * @param uiBotAction
     * @param rawDataSchema
     * @param rawData
     * @param extendedFields
     * @param buttonAction
     * @param buttonIconData
     * @param appCode        应用参数appCode
     * @return
     */
    public static BottomButtonDigiwinAthena create(UiBotAction uiBotAction, String rawDataSchema,
                                                   Object rawData, Map<String, Object> extendedFields, Action buttonAction,
                                                   Integer buttonIconData, String id, String appCode) {
        BottomButtonDigiwinAthena bottomButton = new BottomButtonDigiwinAthena();
        if (!uiBotAction.getDefaultAction()) {
            if (null != buttonIconData && !buttonIconData.equals(ButtonIconDataEnum.NONE.getValue())) {
                bottomButton.setIconData(buttonIconData);
            }
            bottomButton.setType(BottomButtonStyleEnum.NORMAL.getValue());
        } else {
            bottomButton.setType(BottomButtonStyleEnum.STRESS.getValue());
        }
        bottomButton.setName(uiBotAction.getTitle());

        String confirmPopContent = MapUtils.getString(uiBotAction, "confirmPop_content");
        if (StringUtils.hasLength(confirmPopContent)) {
            ConfirmPop confirmPop = new ConfirmPop();
            confirmPop.setContent(confirmPopContent);
            confirmPop.setNeedConfirm(true);
            buttonAction.setConfirmPop(confirmPop);
        }

        bottomButton.setAction(buttonAction);
        ButtonRawData buttonRawData = new ButtonRawData().setId(id);
        buttonAction.setRawData(buttonRawData);
        if (null != uiBotAction && null != rawData) {
            Map<String, Object> rawDataMap = new HashMap<>(1);
            rawDataMap.put(rawDataSchema, rawData);
            rawDataMap.put("appCode", appCode);
            if (extendedFields != null) {
                rawDataMap.put("extendedFields", extendedFields);
            }
            buttonRawData.setAction(uiBotAction).setData(rawDataMap);
        }
        setIsCheckButtonMethod(uiBotAction, bottomButton);
        return bottomButton;
    }

    public static Map<String, Object> assembleRawData(UiBotAction uiBotAction, String rawDataSchema, Object rawData,
                                                      Map<String, Object> extendedFields, String id, String appCode) {
        Map<String, Object> metadataMap = null;
        if (rawData != null) {
            metadataMap = new HashMap<>(1);
            metadataMap.put(rawDataSchema, rawData);
        }
        return assembleRawData(uiBotAction, metadataMap, extendedFields, id, appCode);
    }

    public static Map<String, Object> assembleRawData(UiBotAction uiBotAction, Map<String, Object> metadataMap,
                                                      Map<String, Object> extendedFields, String id, String appCode) {
        ButtonRawData buttonRawData = new ButtonRawData().setId(id);
        if (null != uiBotAction && null != metadataMap) {
            Map<String, Object> rawDataMap = new HashMap<>(3);
            rawDataMap.putAll(metadataMap);
            rawDataMap.put("appCode", appCode);
            if (extendedFields != null) {
                rawDataMap.put("extendedFields", extendedFields);
            }
            buttonRawData.setAction(uiBotAction).setData(rawDataMap);
        }
        return JsonUtil.objectToJavaObject(buttonRawData, Map.class);
    }

    /**
     * 返回一个无icon的按钮
     *
     * @param uiBotAction
     * @param rawDataSchema
     * @param rawData
     * @param extendedFields
     * @param buttonAction
     * @return
     */
    public static BottomButtonDigiwinAthena create(UiBotAction uiBotAction, String rawDataSchema,
                                                   Object rawData, Map<String, Object> extendedFields, Action buttonAction) {
        return BottomButtonDigiwinAthena.create(uiBotAction, rawDataSchema, rawData,
                extendedFields, buttonAction, ButtonIconDataEnum.NONE.getValue(), null, null);
    }


    /**
     * 创建点击后返回上一页并自定义名称的按钮
     *
     * @param locale
     * @return
     */
    public static BottomButtonDigiwinAthena createNormalCancelButton(String locale, String name) {
        BottomButtonDigiwinAthena normalCancelButton = new BottomButtonDigiwinAthena();
        LocaleService localeService = SpringContextHolder.getBean(LocaleService.class);
        normalCancelButton.setName(localeService.getLanguageValue(locale, name));
        normalCancelButton.setIsCheckButton(false);
        Action buttonAction = new Action();
        buttonAction.setType(ActionTypeEnum.BACK.getValue());
        normalCancelButton.setAction(buttonAction);
        normalCancelButton.setType(BottomButtonStyleEnum.NORMAL.getValue());
        return normalCancelButton;
    }

    /**
     * 创建一个一般样式的取消按钮，点击后返回上一页
     *
     * @param locale
     * @return
     */
    public static BottomButtonDigiwinAthena createNormalCancelButton(String locale) {
        BottomButtonDigiwinAthena normalCancelButton = new BottomButtonDigiwinAthena();
        normalCancelButton.setName(LocaleUtil.getMobileTextByKey(locale, "取消"));
        normalCancelButton.setIsCheckButton(false);
        Action buttonAction = new Action();
        buttonAction.setType(ActionTypeEnum.BACK.getValue());
        normalCancelButton.setAction(buttonAction);

        normalCancelButton.setType(BottomButtonStyleEnum.NORMAL.getValue());

        return normalCancelButton;
    }

    /**
     * 创建一个强调样式的完成按钮，点击后返回上一页
     *
     * @param locale
     * @return
     */
    public static BottomButtonDigiwinAthena createStressDoneButton(String locale) {
        BottomButtonDigiwinAthena normalCancelButton = new BottomButtonDigiwinAthena();
        normalCancelButton.setName(LocaleUtil.getMobileTextByKey(locale, "完成"));

        Action buttonAction = new Action();
        buttonAction.setType(ActionTypeEnum.BACK.getValue());
        normalCancelButton.setAction(buttonAction);

        normalCancelButton.setType(BottomButtonStyleEnum.STRESS.getValue());

        return normalCancelButton;
    }

    /**
     * 创建一个编辑的按钮
     *
     * @param name
     * @param action
     * @return
     */
    public static BottomButtonDigiwinAthena createEditButton(String name, Action action) {
        BottomButtonDigiwinAthena editButton = new BottomButtonDigiwinAthena();
        editButton.setName(name);
        editButton.setIsCheckButton(false);
        editButton.setEnable(true);
        editButton.setAction(action);
        editButton.setType(BottomButtonStyleEnum.DETAIL_NORMAL.getValue());
        return editButton;
    }

    /**
     * 给apc装配进度控制应用定制按钮
     */
    public static BottomButtonDigiwinAthena createOnlineButton(String pageId, String locale, Map<String, Object> rawData, Integer type) {
        BottomButtonDigiwinAthena onlineButton = new BottomButtonDigiwinAthena();
        onlineButton.setName(LocaleUtil.getMobileTextByKey(locale, "人员上线"));
        rawData.put("actionId", "wo.op.report.check.in.info.process");
        rawData.put("pageId", pageId);

        Action buttonAction = new Action();
        buttonAction.setType(type);
        buttonAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/workingHourReport/peopleOnline");
        buttonAction.setRawData(rawData);
        onlineButton.setAction(buttonAction);
        onlineButton.setShowDot(true);
        onlineButton.setDotIconData(0);
        onlineButton.setType(BottomButtonStyleEnum.DETAIL_NORMAL_BULE_STROKE.getValue());

        return onlineButton;
    }

    public static BottomButtonDigiwinAthena createButton(String name, Integer type, Action action) {
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setName(name);
        button.setType(type);
        button.setAction(action);
        return button;
    }

    public static BottomButtonDigiwinAthena createCancelOnlineButton(String locale, Map<String, Object> rawData) {
        BottomButtonDigiwinAthena cancelOnlineButton = new BottomButtonDigiwinAthena();
        cancelOnlineButton.setName(LocaleUtil.getMobileTextByKey(locale, "取消上线"));
//        rawData.put("actionId", "bm.wrsc.wo.op.report.work.hours.delete");
        rawData.put("actionId", "wo.op.report.cancel.check.in.info.process");

        Action buttonAction = new Action();
        buttonAction.setType(ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue());
        buttonAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/workingHourReport/cancelOnline");
        buttonAction.setRawData(rawData);
        cancelOnlineButton.setAction(buttonAction);
        cancelOnlineButton.setShowDot(true);
        cancelOnlineButton.setDotIconData(0);
        cancelOnlineButton.setType(BottomButtonStyleEnum.DETAIL_NORMAL_RED_STROKE.getValue());

        return cancelOnlineButton;
    }

    public static BottomButtonDigiwinAthena createOfflineButton(String pageId, String locale, Map<String, Object> rawData) {
        BottomButtonDigiwinAthena offlineButton = new BottomButtonDigiwinAthena();
        offlineButton.setName(LocaleUtil.getMobileTextByKey(locale, "人员下线"));
        rawData.put("actionId", "wo.op.report.info.process");
        rawData.put("pageId", pageId);
        Action buttonAction = new Action();
        buttonAction.setType(ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue());
        buttonAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/workingHourReport/peopleOffline");
        buttonAction.setRawData(rawData);
        offlineButton.setAction(buttonAction);

        offlineButton.setType(BottomButtonStyleEnum.DETAIL_NORMAL_GREEN_STROKE.getValue());
        offlineButton.setShowDot(true);
        offlineButton.setDotIconData(0);

        return offlineButton;
    }

    public static BottomButtonDigiwinAthena createAbnormalReportButton(String locale, Action action) {
        BottomButtonDigiwinAthena abnormalReportButton = new BottomButtonDigiwinAthena();
        abnormalReportButton.setName(LocaleUtil.getMobileTextByKey(locale, "异常回报"));

        abnormalReportButton.setAction(action);

        abnormalReportButton.setType(BottomButtonStyleEnum.DETAIL_NORMAL.getValue());

        return abnormalReportButton;
    }

    public static BottomButtonDigiwinAthena createAbnormalReportSubmitButton(String locale, Map<String, Object> rawData) {
        BottomButtonDigiwinAthena abnormalReportButton = new BottomButtonDigiwinAthena();
        abnormalReportButton.setName(LocaleUtil.getMobileTextByKey(locale, "异常提交"));

        Action buttonAction = new Action();
        buttonAction.setType(ActionTypeEnum.CALL_API.getValue());
        buttonAction.setRawData(rawData);
        abnormalReportButton.setAction(buttonAction);
        return abnormalReportButton;
    }

    /**
     * 创建一个下一步的标签
     *
     * @param locale
     * @param rawData
     * @return
     */
    public static BottomButtonDigiwinAthena createNextStepButton(String locale, Map<String, Object> rawData) {
        BottomButtonDigiwinAthena nextStepButton = new BottomButtonDigiwinAthena();
        nextStepButton.setName(LocaleUtil.getMobileTextByKey(locale, "下一步"));
        nextStepButton.setType(BottomButtonStyleEnum.STRESS.getValue());
        Action buttonAction = new Action();
        buttonAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_AND_SUBMIT.getValue());
        buttonAction.setRawData(rawData);
        buttonAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_UIBOT_UNIVERSAL_PARSE.toString());
        nextStepButton.setAction(buttonAction);
        return nextStepButton;
    }

    public static BottomButtonDigiwinAthena createProcessReportButton(String locale, Action action) {
        BottomButtonDigiwinAthena processReportButton = new BottomButtonDigiwinAthena();
        processReportButton.setName(LocaleUtil.getMobileTextByKey(locale, "进度回报"));

        processReportButton.setAction(action);
        processReportButton.setType(BottomButtonStyleEnum.DETAIL_NORMAL.getValue());

        return processReportButton;
    }

    public static BottomButtonDigiwinAthena createOffLineButton(String locale, Action action, Integer type) {
        BottomButtonDigiwinAthena processReportButton = new BottomButtonDigiwinAthena();
        processReportButton.setName(LocaleUtil.getMobileTextByKey(locale, "人员下线"));

        processReportButton.setAction(action);

        processReportButton.setType(type);

        return processReportButton;
    }

    public static BottomButtonDigiwinAthena createButton(String locale, Action action, String name, Integer type, String bgColor, boolean isShowNum) {
        BottomButtonDigiwinAthena processReportButton = new BottomButtonDigiwinAthena();
        processReportButton.setName(LocaleUtil.getMobileTextByKey(locale, name));
        processReportButton.setAction(action);
        processReportButton.setType(type);
        processReportButton.setShowNum(isShowNum);
        if (StringUtils.hasLength(bgColor)) {
            processReportButton.setBgColor(bgColor);
        }
        return processReportButton;
    }

    public static BottomButtonDigiwinAthena createProcessReportSubmitButton(String locale, Map<String, Object> rawData) {
        BottomButtonDigiwinAthena processReportButton = new BottomButtonDigiwinAthena();
        processReportButton.setName(LocaleUtil.getMobileTextByKey(locale, "提交"));

        Action buttonAction = new Action();
        buttonAction.setType(ActionTypeEnum.CALL_API.getValue());
        buttonAction.setRawData(rawData);
        processReportButton.setAction(buttonAction);
        return processReportButton;
    }

    public static BottomButtonDigiwinAthena createSubmitButton(String locale, Map<String, Object> rawData, String key) {
        BottomButtonDigiwinAthena processReportButton = new BottomButtonDigiwinAthena();
        processReportButton.setName(LocaleUtil.getMobileTextByKey(locale, key));

        Action buttonAction = new Action();
        buttonAction.setType(ActionTypeEnum.CALL_API.getValue());
        buttonAction.setRawData(rawData);
        processReportButton.setAction(buttonAction);
        return processReportButton;
    }

    /**
     * 进度回报：数量转移 确定按钮
     *
     * @param locale
     * @param rawData
     * @return
     */
    public static BottomButtonDigiwinAthena createTransferQuantitySubmitButton(String locale, Map<String, Object> rawData) {
        BottomButtonDigiwinAthena processReportButton = new BottomButtonDigiwinAthena();
        processReportButton.setName(LocaleUtil.getMobileTextByKey(locale, "提交"));

        Action buttonAction = new Action();
        buttonAction.setType(ActionTypeEnum.CALL_API.getValue());
        buttonAction.setRawData(rawData);
        processReportButton.setAction(buttonAction);
        return processReportButton;
    }

    public static BottomButtonDigiwinAthena create(UiBotAction uiBotAction, Map<String, Object> rawData, Boolean pageSubmit, int actionType) {
        BottomButtonDigiwinAthena buttonDigiwinAthena = new BottomButtonDigiwinAthena();
        buttonDigiwinAthena.setName(uiBotAction.getTitle());
        Action action = new Action();
        action.setType(actionType);
        action.setRawData(rawData);
        buttonDigiwinAthena.setAction(action);
        if (uiBotAction.getDefaultAction()) {
            buttonDigiwinAthena.setType(BottomButtonStyleEnum.STRESS.getValue());
        } else {
            buttonDigiwinAthena.setType(BottomButtonStyleEnum.DETAIL_NORMAL.getValue());
        }
        buttonDigiwinAthena.setPageSubmit(pageSubmit);

        setIsCheckButtonMethod(uiBotAction, buttonDigiwinAthena);
        return buttonDigiwinAthena;
    }

    /**
     * 设置IsCheckButton属性值
     * 读取pc端按钮数据uibotAction.extendParas.ignoreRule属性的值：
     * 若存在extendParas，存在ignoreRule且ignoreRule是true时，则将isCheckButton设置为false。
     * 反之则为设置为true
     *
     * @param uiBotAction
     * @param buttonDigiwinAthena
     */
    public static void setIsCheckButtonMethod(UiBotAction uiBotAction, BottomButtonDigiwinAthena buttonDigiwinAthena) {
        UiBotActionExtendParas extendParas = uiBotAction.getExtendParas();
        buttonDigiwinAthena.setIsCheckButton(!ObjectUtil.isNotEmpty(extendParas) ||
                (!ObjectUtil.isNotEmpty(extendParas.getIgnoreRule()) || !extendParas.getIgnoreRule()));
    }

    /**
     * 创建ABI报表跳转页面
     *
     * @param name
     * @param dataReport
     * @param dataId
     * @return
     */
    public static BottomButtonDigiwinAthena createABIReportButton(String name,
                                                                  DigiwinAtmcTmDataReport dataReport, String dataId) {
        BottomButtonDigiwinAthena buttonDigiwinAthena = new BottomButtonDigiwinAthena();
        buttonDigiwinAthena.setName(name);
        Action action = new Action();
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_ABI_REPORT_DETAIL.toString());
        action.setJumpPageTitle(name);
        action.setDataId(dataId);
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        Map<String, Object> rawData = new HashMap<>(1);
        rawData.put("data", dataReport);
        action.setRawData(rawData);
        AppEntranceAccessRecord accessRecord = new AppEntranceAccessRecord();
        accessRecord.setRecordUrl("/mobile/v1/appEntranceRecord/add");
        accessRecord.setSendRecord(true);
        buttonDigiwinAthena.setAppId("REPORT_ABI_" + dataId);
        buttonDigiwinAthena.setAccessRecord(accessRecord);
        buttonDigiwinAthena.setAction(action);
        buttonDigiwinAthena.setId(dataId);
        return buttonDigiwinAthena;
    }

    //TODO Tbb报表url从哪里来
    public static BottomButtonDigiwinAthena createTBBReportButton(String locale, String iamUserToken, String tenantId, String resCode, String name) {
        BottomButtonDigiwinAthena buttonDigiwinAthena = new BottomButtonDigiwinAthena();
        buttonDigiwinAthena.setId(resCode == null ? UUIDUtil.getUuid() : resCode);
        buttonDigiwinAthena.setName(name);
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());

        action.setRequestUrl(buildTbbH5Url(locale, iamUserToken, tenantId, resCode, name));
        buttonDigiwinAthena.setAction(action);
        return buttonDigiwinAthena;
    }

    public static String buildTbbH5Url(String locale, String iamUserToken, String tenantId, String resCode, String name) {
        String encode = name;
        String hostUrl = AppContext.getApiUrlSetting().getTbbUrl();
        try {
            encode = URLEncoder.encode(name, "utf-8");
            hostUrl = URLEncoder.encode(hostUrl, "utf-8");
        } catch (Exception ignored) {

        }
        return AppContext.getApiUrlSetting().getTbbH5Url() + "?tenantId=" + tenantId
                + "&dashboardId=" + resCode
                + "#/pages/board?"
                + "locale=" + locale
                + "&mobile_user_token=" + iamUserToken
                + "&systemtype=athena"
                + "&dashboardtype=template"
                + "&name=" + encode;
    }


    /**
     * 创建附件历程的按钮
     *
     * @param mainDataInfo
     * @param locale
     * @param localeService
     * @return
     */
    public static BottomButtonDigiwinAthena createApcAttachmentDetailButton(Map<String, Object> mainDataInfo, String locale, LocaleService localeService) {
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setName(localeService.getLanguageValue(locale, "附件历程"));
        button.setType(BottomButtonStyleEnum.NORMAL.getValue());
        Action action = new Action();
        Map<String, Object> rawData = new HashMap<>(2);
        rawData.put("data", mainDataInfo);
        action.setJumpPageTitle(LocaleUtil.getMobileTextByKey(locale, "附件历程"));
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_COMMON_ATTACHMENT_DETAIL_PAGE.toString());
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setRawData(rawData);
        button.setAction(action);
        return button;
    }

    /**
     * 创建上传附件的按钮
     *
     * @param mainDataInfo
     * @param sourceType
     * @param locale
     * @param localeService
     * @return
     */
    public static BottomButtonDigiwinAthena createApcAttachmentUploadButton(Map<String, Object> mainDataInfo, String sourceType,
                                                                            String locale, LocaleService localeService) {
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setName(localeService.getLanguageValue(locale, "上传附件"));
        button.setType(BottomButtonStyleEnum.NORMAL.getValue());
        Action action = new Action();
        Map<String, Object> rawData = new HashMap<>(2);
        rawData.put("data", mainDataInfo);
        rawData.put("source_type", sourceType);
        action.setJumpPageTitle(LocaleUtil.getMobileTextByKey(locale, "上传附件"));
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_COMMON_ATTACHMENT_UPLOAD_PAGE.toString());
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setRawData(rawData);
        button.setAction(action);
        return button;
    }


    /**
     * 异常回报允许上传附件开关打开，才展示附件历程和上传附件两个按钮
     *
     * @param woOpReportData
     * @param variableListSimpleMap
     * @param locale
     * @return
     */
    public static BottomButtonDigiwinAthena buildAttachmentButtons(Map<String, Object> woOpReportData, Map<String, Object> variableListSimpleMap, String locale) {
        // 异常回报允许上传附件开关打开，才展示附件历程和上传附件两个按钮
        Boolean abnormalAllowsUploadingAttachments = Optional.ofNullable(variableListSimpleMap).map(map -> MapUtils.getBoolean(map, "abnormalAllowsUploadingAttachments")).orElse(false);
        if (BooleanUtils.isTrue(abnormalAllowsUploadingAttachments)) {
            BottomButtonDigiwinAthena attachmentButton = new BottomButtonDigiwinAthena();
            attachmentButton.setName("...");
            List<BottomButtonDigiwinAthena> childrenAttachmentButton = new ArrayList<>(2);

            LocaleService localeService = SpringContextHolder.getBean(LocaleService.class);
            childrenAttachmentButton.add(createApcAttachmentDetailButton(woOpReportData, locale, localeService));
            childrenAttachmentButton.add(createApcAttachmentUploadButton(woOpReportData, "2", locale, localeService));
            attachmentButton.setChildren(childrenAttachmentButton);
            return attachmentButton;
        }
        return null;
    }

    /**
     * 创建请求支援的按钮
     *
     * @param pcUiBotModel
     * @param locale
     * @param localeService
     * @param mainDataInfo
     * @return
     */
    public static BottomButtonDigiwinAthena createSupportAction(UiBotModel pcUiBotModel, String locale, LocaleService localeService, Map<String, Object> mainDataInfo) {
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setName(localeService.getLanguageValue(locale, "请求支援"));
        button.setType(BottomButtonStyleEnum.NORMAL.getValue());
        Action action = new Action();
        Map<String, Object> rawData = new HashMap<>(2);

        List<UiBotAction> uiBotActionList = pcUiBotModel.getLayout().stream().filter(layout -> "apc_project_schedule-task-detail-waitting".equals(layout.getType()))
                .findFirst()
                .map(UiBotLayout::getActions)
                .orElse(Collections.emptyList());
        Optional<UiBotAction> uiBotActionOptional = uiBotActionList.stream().filter(layout -> "apc_RequestSupport".equals(layout.getType()))
                .findFirst();
        if (uiBotActionOptional.isPresent()) {
            UiBotAction uiBotAction = JsonUtil.objectToJavaObject(uiBotActionOptional.get(), UiBotAction.class);
            if (!"ESP".equals(uiBotAction.getCategory())) {
                uiBotAction.setCategory("ESP");
                uiBotAction.setType("");
            }
            rawData.put("action", uiBotAction);
        }
        Map<String, Object> reportDataMap = new HashMap<>(1);
        List<Map<String, Object>> reportData = new ArrayList<>(1);
        reportData.add(mainDataInfo);
        reportDataMap.put("wo_op_report_data", reportData);
        rawData.put("datas", reportDataMap);
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_SUPPORT_BOTTOM.toString());
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setRawData(rawData);
        button.setAction(action);
        return button;
    }

    /**
     * 新增数量转移按钮
     *
     * @param pcUiBotModel
     * @param locale
     * @param localeService
     * @param mainDataInfo
     * @param total
     * @return
     */
    public static BottomButtonDigiwinAthena createTransferQuantityAction(UiBotModel pcUiBotModel, String locale,
                                                                         LocaleService localeService, Map<String, Object> mainDataInfo, int total) {
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setName(localeService.getLanguageValue(locale, "数量转移"));
        button.setType(BottomButtonStyleEnum.NORMAL.getValue());
        Action action = new Action();
        Map<String, Object> rawData = new HashMap<>(2);
        List<UiBotAction> uiBotActionList = pcUiBotModel.getLayout().stream().filter(layout -> "apc_project_schedule-task-detail-waitting".equals(layout.getType()))
                .findFirst()
                .map(UiBotLayout::getActions)
                .orElse(Collections.emptyList());
        Optional<UiBotAction> uiBotActionOptional = uiBotActionList.stream().filter(layout -> "esp_wo.op.report.transfer.info.process".equals(layout.getActionId()))
                .findFirst();
        if (uiBotActionOptional.isPresent()) {
            UiBotAction uiBotAction = JsonUtil.objectToJavaObject(uiBotActionOptional.get(), UiBotAction.class);
            if (!"ESP".equals(uiBotAction.getCategory())) {
                uiBotAction.setCategory("ESP");
                uiBotAction.setType("");
            }
            rawData.put("action", uiBotAction);
        }
        rawData.put("datas", mainDataInfo);
        List<Map<String, Object>> woOpReportDataList = new ArrayList<>();
        woOpReportDataList.add(mainDataInfo);
        rawData.put("wo_op_report_data", woOpReportDataList);
        // 存储进度回报列表总数
        rawData.put("total", total);
        action.setJumpPageTitle(LocaleUtil.getMobileTextByKey(locale, "转移数量"));
        //s11 页面和提交不区别类型，sft和mkp都一样
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_TRANSFER_QUANTITY_SFT_DETAILS.toString());
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setRawData(rawData);
        button.setAction(action);
        return button;
    }

    @Override
    public Integer getIconData() {
        return iconData;
    }

    @Override
    public void setIconData(Integer iconData) {
        this.iconData = iconData;
    }

    public List<BottomButtonDigiwinAthena> getChildren() {
        return children;
    }

    public void setChildren(List<BottomButtonDigiwinAthena> children) {
        this.children = children;
    }

    public void addChildBottomButton(BottomButtonDigiwinAthena child) {
        this.children.add(child);
    }

    @Override
    public String getIconColor() {
        return iconColor;
    }

    @Override
    public void setIconColor(String iconColor) {
        this.iconColor = iconColor;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @Override
    public String returnComponentType() {
        return BottomButtonDigiwinAthena.COMPONENT_TYPE;
    }
}
