package com.digiwin.mobile.mobileuibot.core.component.button;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BottomButtonParamAnalyzer
 * @Author: Zaregoto
 * @Date: 2021/5/25 20:25
 */
@Component("bottomButtonParamAnalyzer")
public class BottomButtonParamAnalyzer implements ComponentParamAnalyzer<BottomButtonDigiwinAthena, Object> {

    private static final Logger logger = LoggerFactory.getLogger(BottomButtonParamAnalyzer.class);

    @Override
    public String getComponentType() {
        return BottomButtonDigiwinAthena.COMPONENT_TYPE;
    }

    @Override
    public Class<BottomButtonDigiwinAthena> getSubmitParamType() {
        return BottomButtonDigiwinAthena.class;
    }

    @Override
    public Object analyzeSubmitParam(Object submitParam) {
        return null;
    }

    @Override
    public void handleDisplayParam(ApiRequest apiRequest, String pageDataKey,
                                   UiBotPageData pageData, Object... args) {
        Object displayParam = pageData.get(pageDataKey);
        if (displayParam instanceof List) {
            // FIXME 按钮处理没统一位置，容易遗漏
            List<Map<String, Object>> buttonList = ((ArrayList) displayParam);
            for (Map<String, Object> button : buttonList) {
                Map<String, Object> actionMap = (Map<String, Object>) button.get("action");
                if (actionMap != null) {
                    actionMap.put("rawData", apiRequest.getRawData());
                    if (actionMap.get("popPromptMsg") != null) {
                        Map<String, Object> popPromptMsg = (Map<String, Object>) actionMap.get("popPromptMsg");
                        if ("TASK".equals(((ApiRawData) args[0]).get("category"))) {
                            popPromptMsg.put("content",
                                    LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(),
                                            (String) popPromptMsg.get("content")) + LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "reassignContentTask"));
                        } else {
                            popPromptMsg.put("content",
                                    LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(),
                                            (String) popPromptMsg.get("content")) + LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "reassignContentProject"));
                        }
                        if (popPromptMsg.get("buttonList") != null) {
                            List<Map<String, Object>> buttons = (List<Map<String, Object>>) popPromptMsg.get("buttonList");
                            if (buttons != null && buttons.size() > 0) {
                                for (Map<String, Object> buttonMap : buttons) {
                                    buttonMap.put("name", LocaleUtil.getMobileTextByDatabaseKey(
                                            apiRequest.getLocale(), (String) buttonMap.get("name")));
                                }
                            }
                        }
                    }
                    if (actionMap.get("confirmPop") != null) {
                        Map<String, Object> confirmPopMsg = (Map<String, Object>) actionMap.get("confirmPop");
                        if (confirmPopMsg.get("content") != null) {
                            confirmPopMsg.put("content", LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), (String) confirmPopMsg.get("content")));
                        }
                        if (confirmPopMsg.get("title") != null) {
                            confirmPopMsg.put("title", LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), (String) confirmPopMsg.get("title")));
                        }
                    }
                } else {
                    actionMap = new HashMap<>();
                    actionMap.put("rawData", apiRequest.getRawData());
                    actionMap.put("type", ActionTypeEnum.CALL_API.getValue());
                    button.put("action", actionMap);
                }
                button.put("name", LocaleUtil.getMobileTextByDatabaseKey(
                        apiRequest.getLocale(), (String) button.get("name")));
            }
        }
    }
}
