package com.digiwin.mobile.mobileuibot.core.component.button;

import lombok.Getter;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 * @see BottomButtonStyleTypeEnum
 * @see CardButtonStyleTypeEnum
 *
 * @FileName: BottomButtonStyleEnum
 * @Author: Zaregoto
 * @Date: 2021/5/20 14:56
 */
@Getter
public enum BottomButtonStyleEnum {
    /**
     * 主要按钮，强调样式：蓝底白字
     */
    STRESS(1),

    /**
     * 普通按钮，普通样式：灰底黑字，无描边
     */
    NORMAL(2),

    /**
     * 明细主要按钮，强调样式：白底蓝字，蓝色描边
     */
    DETAIL_STRESS(3),

    /**
     * 明细次要按钮，次要样式：白底黑字，灰色描边
     */
    DETAIL_NORMAL(4),
    /**
     * 明细次要按钮，次要样式：白底黑字，蓝色描边
     */
    DETAIL_NORMAL_BULE_STROKE(41),
    /**
     * 明细次要按钮，次要样式：白底蓝字，蓝色描边
     */
    DETAIL_NORMAL_BULE_STROKE_BULE_FONT(44),
    /**
     * 明细次要按钮，次要样式：白底黑字，红色描边
     */
    DETAIL_NORMAL_RED_STROKE(42),
    /**
     * 明细次要按钮，次要样式：白底黑字，绿色描边
     */
    DETAIL_NORMAL_GREEN_STROKE(43),

    /**
     * 全选按钮，目前必须与MULTI_FUNCTION_LIST组件配合使用
     */
    SELECT_ALL(5);

    private final Integer value;

    BottomButtonStyleEnum(Integer value) {
        this.value = value;
    }

}
