package com.digiwin.mobile.mobileuibot.core.component.button;

import cn.hutool.core.util.ObjectUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.CommonRawDataParentType;
import com.digiwin.mobile.mobileuibot.core.CustomCodeEnum;
import com.digiwin.mobile.mobileuibot.core.CustomConfig;
import com.digiwin.mobile.mobileuibot.core.CustomIdEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.*;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.entrance.AppEntranceAccessRecord;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListChoiceEnum;
import com.digiwin.mobile.mobileuibot.core.component.navbar.index.IndexNavBar;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.PrintActionCreateService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPatternUtil;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZhilinkService;
import com.digiwin.mobile.mobileuibot.task.common.TaskDataExtractUtil;
import com.digiwin.mobile.mobileuibot.task.model.MobileInspectionStatusEnum;
import com.google.common.collect.Lists;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * <p>功能描述：所有按钮组件基类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: Button
 * @Author: Zaregoto
 * @Date: 2021/5/20 11:50
 */
@Data
public class Button<T> extends BaseMobileComponent {
    public static final String COMPONENT_TYPE = "BUTTON";
    private static final long serialVersionUID = 8459808721466680224L;

    protected String id;
    /**
     * 在卡片内部的按钮样式枚举类UibotCardBtnStyleTypeEnum
     * 在页面底部或者弹框底部的按钮样式枚举类UibotPageBtnStyleTypeEnum
     */
    protected Integer type;
    protected String name;
    protected String stateName;
    protected String subName;
    protected String picUrl;
    protected String actionDoneName;
    protected Action<T> action;
    protected CustomConfig customConfig;

    /**
     * 按钮会展示的icon编号。icon来自iconfont中的项目。
     * 编号可使用十进制或十六进制
     */
    protected Integer iconData;
    protected String iconColor;
    protected Boolean pageSubmit = false;

    /**
     * 当前按钮是否会经过界面上动态业务规则的校验。
     * 如果true，会经过校验，校验为通过则按钮会高亮且可点击；反之则不高亮且不可点击
     * 如果false，界面不会校验当前按钮，按钮初始为会是高亮可点击
     */
    protected Boolean isCheckButton = true;

    /**
     * 是否展示按钮名称后面数字，目前仅与MULTI_FUNCTION_LIST组件联动
     */
    protected Boolean showNum;
    /**
     * 是否显示小圆点
     */
    protected Boolean showDot;
    /**
     * 小圆点的iconData
     */
    protected Integer dotIconData;
    /**
     * 判断当前按钮是否被选中
     */
    protected Boolean selected;
    /**
     * 按钮宽度
     */
    protected Integer buttonWidth;
    /**
     * 按钮高度
     */
    protected Integer buttonHeight;
    /**
     * 访问记录的ID
     */
    private String appId;
    /**
     * 访问记录
     */
    private AppEntranceAccessRecord accessRecord;

    /**
     * 是多条目时候前端根据parentSchema删除指定条目
     */
    private String parentSchema;

    /**
     * 提交ACTION -- 设计态
     */
    private UiBotAction submitAction;
    /**
     * 是否可滑动查看其他页面详情 -- 设计态
     */
    private Boolean detailPageSwiper = false;

    /**
     * 跳转类按钮中rawData是否需要拼接组件树中commonChildRawData
     */
    private Boolean needParentRawData;

    /**
     * 按钮图标--卡片按钮和独立按钮
     * 枚举类UibotIconNameEnum
     */
    private String iconName = UibotIconNameEnum.SJQ_EMPTY.getValue();

    @Data
    @Accessors(chain = true)
    public static class AllSelectButtonParam {
        private String cmptUuid;
        private String componentType;
    }

    public Button() {
    }

    public Button(String id, String name, Action<T> action) {
        this.id = id;
        this.name = name;
        this.action = action;
    }

    public Button(String id, String name, String subName, String picUrl, Action<T> action) {
        this.id = id;
        this.name = name;
        this.subName = subName;
        this.picUrl = picUrl;
        this.action = action;
    }

    public static Button<Map<String, Object>> createApprovalProgressCheckButton(String locale,
                                                                                Map<String, Object> data) {
        Button<Map<String, Object>> button = new Button<>();
        String buttonName = "";
        String jumpPageTitle = "";
        buttonName = jumpPageTitle = LocaleUtil.getMobileTextByKey(locale,
                PageSettingIdPresetEnum.MOBILE_APPROVAL_TASK_PROGRESS.toString());
        button.setName(buttonName);
        Action buttonAction = new Action();
        buttonAction.setJumpPageId(
                PageSettingIdPresetEnum.MOBILE_APPROVAL_TASK_PROGRESS.toString());
        buttonAction.setJumpPageTitle(jumpPageTitle);
        buttonAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        buttonAction.setRawData(data);
        button.setAction(buttonAction);

        return button;
    }

    /**
     * 转派按钮
     *
     * @param id
     * @param rawData
     * @param locale
     * @param type     转派按钮适用的场景。PROJECT表示项目，TASK表示任务
     * @param iconData
     * @return
     */
    public static Button createApprovalReassign(String id, Map<String, Object> rawData, String locale,
                                                String type, Integer iconData) {
        Button button = new Button();
        button.setId(id);
        button.setName(LocaleUtil.getMobileTextByKey(locale, "转派"));
        button.setIconData(iconData);

        button.setIconColor("0xFF333333");
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_REASSIGN.toString());
        if ("PROJECT".equalsIgnoreCase(type)) {
            action.setRefreshPageId(PageSettingIdPresetEnum.FLASH_MY_PROJECT.toString());
        }
        if ("TASK".equalsIgnoreCase(type)) {
            action.setRefreshPageId(PageSettingIdPresetEnum.FLASH_MY_TODO.toString());
        }
        rawData.put("id", id);
        rawData.put("category", type);
        rawData.put("isReassign", true);
        action.setRawData(rawData);
        action.setJumpPageTitle(LocaleUtil.getMobileTextByKey(locale, "转派"));
        button.setAction(action);
        return button;
    }

    /**
     * 转派记录按钮
     *
     * @param dataId
     * @param locale
     * @param type     转派记录按钮适用的场景。PROJECT表示项目，TASK表示任务
     * @param iconData
     * @return
     */
    public static Button createReassignReport(String dataId, String locale, String type, Integer iconData) {
        Button button = new Button();
        button.setId(dataId);
        button.setName(LocaleUtil.getMobileTextByKey(locale, "转派记录"));
        button.setIconData(iconData);
        button.setIconColor("0xFF333333");
        Map<String, Object> rawData = new HashMap<>();
        if ("PROJECT".equalsIgnoreCase(type)) {
            rawData.put("reassignReportType", type);
        }
        if ("TASK".equalsIgnoreCase(type)) {
            rawData.put("reassignReportType", type);
        }
        button.setAction(Action.createReassignReportAction(locale, rawData));
        // 设置dataId，用于转派记录页面查询接口
        button.getAction().setDataId(dataId);
        return button;
    }

    /**
     * 转派按钮
     *
     * @param id
     * @param rawData
     * @param locale
     * @param type    APC支援任务卡转派按钮适用的场景。
     * @return
     */
    public static Button createApcApprovalReassign(String id, Map<String, Object> rawData, String locale,
                                                   Integer type) {
        Map<String, Object> newRawData = new HashMap<>(5);
        newRawData.putAll(rawData);
        Button button = new Button();
        button.setId(id);
        button.setName(LocaleUtil.getMobileTextByKey(locale, "转派"));
        button.setType(type);
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_APPROVAL_REASSIGN_BOTTOM.toString());
        action.setRefreshPageId(PageSettingIdPresetEnum.FLASH_MY_TODO.toString());
        newRawData.put("isAPC", true);
        newRawData.put("pageId", PageSettingIdPresetEnum.MOBILE_ATHENA_APC_APPROVAL_REASSIGN_BOTTOM.toString());
        action.setRawData(newRawData);
        button.setAction(action);
        return button;
    }

    /**
     * 处理按钮
     *
     * @param id
     * @param rawData
     * @param locale
     * @param type    APC支援任务卡处理按钮适用的场景。
     * @return
     */
    public static Button createApcHandel(String id, Map<String, Object> rawData, String locale,
                                         Integer type, LocaleService localeService) {
        Button button = new Button();
        button.setId(id);
        button.setName(localeService.getLanguageValue(locale, "处理"));
        button.setType(type);
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_HANDEL_BOTTOM.toString());
        action.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_ABNORMAL_REPORT_LIST.toString());
        rawData.put("isAPC", true);
        rawData.put("pageId", PageSettingIdPresetEnum.MOBILE_ATHENA_APC_HANDEL_BOTTOM.toString());
        action.setRawData(rawData);
        button.setAction(action);
        return button;
    }

    /**
     * 任务卡：分享至他人按钮
     *
     * @param id
     * @param rawData
     * @param locale
     * @return
     */
    public static Button createShareWithOthers(String id, Map<String, Object> rawData,
                                               String locale, LocaleService localeService) {
        Button button = new Button();
        button.setName(localeService.getLanguageValue(locale, "添加至他人Athena"));
        button.setId(id);
        button.setIconData(58927);
        button.setIconColor("0xFF333333");
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_SHARE_OTHERS.toString());
        rawData.put("id", id);
        rawData.put("isSharing", true);
        action.setRawData(rawData);
        action.setJumpPageTitle(localeService.getLanguageValue(locale, "添加至他人Athena"));
        button.setAction(action);
        return button;
    }

    /**
     * 项目卡：分享至他人按钮
     *
     * @param id
     * @param rawData
     * @param locale
     * @return
     */
    public static Button createProjectShareWithOthers(String id, Map<String, Object> rawData,
                                                      String locale, LocaleService localeService) {
        Button button = new Button();
        button.setName(localeService.getLanguageValue(locale, "添加至他人Athena"));
        button.setId(id);
        button.setIconData(58927);
        button.setIconColor("0xFF333333");
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_SHARE_OTHERS.toString());
        action.setRefreshPageId(PageSettingIdPresetEnum.FLASH_MY_PROJECT.toString());
        rawData.put("id", id);
        rawData.put("isSharing", true);
        action.setRawData(rawData);
        action.setJumpPageTitle(localeService.getLanguageValue(locale, "添加至他人Athena"));
        button.setAction(action);
        return button;
    }

    /**
     * 在途宝--跳转到地址簿按钮
     *
     * @param id
     * @param rawData
     * @param locale
     * @return
     */
    public static Button createAddressBook(String id, Map<String, Object> rawData, String locale) {
        Button addressBook = new Button();
        addressBook.setName(LocaleUtil.getMobileTextByKey(locale, "地址簿"));
        addressBook.setId(id);
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_ADDRESS_BOOK.toString());
        action.setRawData(rawData);
        action.setJumpPageTitle(LocaleUtil.getMobileTextByKey(locale, "地址簿"));
        addressBook.setAction(action);
        return addressBook;
    }

    /**
     * 在途宝--新增/更新地址
     *
     * @param id
     * @param rawData
     * @param locale
     * @return
     */
    public static Button createModifiyAddress(String id, Map<String, Object> rawData, String locale, String name) {
        Button modifiyAddress = new Button();
        modifiyAddress.setName(name);
        modifiyAddress.setId(id);
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        if (CollectionUtils.isEmpty(rawData)) {
            action.setJumpPageTitle(LocaleUtil.getMobileTextByKey(locale, "新增地址"));
        } else {
            action.setJumpPageTitle(LocaleUtil.getMobileTextByKey(locale, "更新地址"));
        }
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_MODIFIY_ADDRESS.toString());
        action.setRawData(rawData);

        modifiyAddress.setAction(action);
        return modifiyAddress;
    }

    /**
     * 删除按钮
     *
     * @param id
     * @param rawData
     * @param name
     * @param pageId
     * @return
     */
    public static Button createDeleteAddress(String id, Map rawData, String name, String pageId) {
        Button deleteAddress = new Button();
        deleteAddress.setName(name);
        deleteAddress.setId(id);
        Action action = new Action();
        action.setType(ActionTypeEnum.CALL_API_REFRESH_CURRENT_PAGE.getValue());
        rawData.put("page_id", pageId);
        rawData.put("isDeleted", true);
        rawData.put("biz_id", "ZTB");
        action.setRawData(rawData);
        deleteAddress.setAction(action);
        return deleteAddress;
    }

    /**
     * 创建搜索按钮
     *
     * @param locale
     * @param localeService
     * @return
     */
    public static Button createSearchReportName(String locale, LocaleService localeService) {
        Button button = new Button();
        button.setName(localeService.getLanguageValue(locale, "搜索"));
        button.setId(UUIDUtil.getUuid());
        button.setIconData(59124);
        button.setIconColor("0xFF333333");
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_BASE_NEW_PAGE.getValue());
        action.setJumpPageId(AppBasePageNameEnum.APP_SEARCH.getValue());
        Map<String, Object> rawData = new HashMap<>(1);
        rawData.put("searchCategoryId", "report_name");
        action.setRawData(rawData);
        button.setAction(action);
        return button;
    }

    /**
     * 创建报表查询按钮
     *
     * @param name
     * @param dataId
     * @param conditionId
     * @param conditionData
     * @param useCommon
     * @param isFirst
     * @return
     */
    public static Button createAbiReport(String name, String dataId, UiBotAction uiBotAction,
                                         String conditionId, String conditionName,
                                         Map<String, Object> conditionData, Boolean useCommon,
                                         Boolean isFirst) {
        Button button = new Button();
        button.setName(name);
        button.setId(UUIDUtil.getUuid());
        button.setIconData(58909);
        button.setIconColor("0xFF333333");
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setDataId(dataId);
        if (uiBotAction != null) {
            Map<String, Object> rawData = new HashMap<>(1);
            rawData.put("action", uiBotAction);
            rawData.put("conditionId", conditionId);
            rawData.put("conditionName", conditionName);
            rawData.put("data", conditionData);
            rawData.put("useCommon", useCommon);
            action.setRawData(rawData);
        } else {
            button.setType(BottomButtonStyleEnum.DETAIL_NORMAL_BULE_STROKE_BULE_FONT.getValue());
            button.setButtonWidth(326);
            button.setButtonHeight(80);
        }
        button.setSelected(!isFirst);
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_ABI_REPORT_INFO.toString());
        action.setJumpPageTitle(name);
        action.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/get/abi/commonCondition");
        action.setOnlyRequest(true);
        button.setAction(action);
        return button;
    }

    public static Button buildCancelButton(LocaleService localeService, String locale) {
        Button cancelButton = new Button();
        cancelButton.setName(localeService.getLanguageValue(locale, "取消"));
        cancelButton.setId(UUIDUtil.getUuid());
        cancelButton.setType(BottomButtonStyleEnum.NORMAL.getValue());
        Action cancelAction = new Action();
        cancelAction.setType(ActionTypeEnum.BACK.getValue());
        cancelButton.setAction(cancelAction);
        cancelButton.setIsCheckButton(false);
        return cancelButton;
    }

    /**
     * APC制令上线的去处理按钮
     *
     * @param locale
     * @param localeService
     * @param data
     * @param actions
     * @return
     */
    public static Button createApcWorkShopOnlineDeal(String locale, LocaleService localeService,
                                                     Map<String, Object> data, List<UiBotAction> actions,
                                                     String id, Boolean isTeamTask) {
        Button button = new Button();
        button.setId(id);
        button.setName(localeService.getLanguageValue(locale, BooleanUtils.isTrue(isTeamTask) ? "查看" : "处理"));
        button.setType(BottomButtonStyleEnum.NORMAL.getValue());
        button.setIsCheckButton(false);
        Action action = new Action();
        action.setUseParentAction(true);
        action.setParentComponent(CustomTabs.COMPONENT_TYPE);
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_WORK_SHOP_ONLINE_DEAL_DETAIL.toString());
        action.setJumpPageTitle("");
        action.setType(ActionTypeEnum.OPEN_TABS.getValue());
        Map<String, Object> rawData = new HashMap<>(1);
        rawData.put("data", data);
        rawData.put("actions", actions);
        rawData.put("isTeamTask", isTeamTask);
        action.setRawData(rawData);
        button.setAction(action);
        return button;
    }

    /**
     * APC班组派工的去处理按钮
     *
     * @param locale
     * @param localeService
     * @return
     */
    public static Button createApcTeamDispatch(String locale, LocaleService localeService, String id) {
        Button button = new Button();
        button.setId(id);
        button.setName(localeService.getLanguageValue(locale, "去处理"));
        button.setStateName(localeService.getLanguageValue(locale, "已处理"));
        button.setType(BottomButtonStyleEnum.NORMAL.getValue());
        button.setIsCheckButton(false);
        return button;
    }

    /**
     * APC制令上线的撤回按钮
     *
     * @param locale
     * @param localeService
     * @param data
     * @param actions
     * @return
     */
    public static Button createApcWorkShopOnlineCancel(String locale, LocaleService localeService,
                                                       Map<String, Object> data, List<UiBotAction> actions) {
        Button button = new Button();
        button.setId(UUIDUtil.getUuid());
        button.setName(localeService.getLanguageValue(locale, "撤回"));
        button.setType(BottomButtonStyleEnum.NORMAL.getValue());
        button.setIsCheckButton(false);
        Action action = new Action();
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_WORK_SHOP_ONLINE_CANCEL_DETAIL.toString());
        action.setJumpPageTitle("");
        action.setConfirmPop(ConfirmPop.create(localeService.getLanguageValue(locale, "是否确定撤回?"), true));
        action.setType(ActionTypeEnum.OPEN_TABS.getValue());
        Map<String, Object> rawData = new HashMap<>(3);
        rawData.put("data", data);
        rawData.put("actions", actions);
        rawData.put("pageId", PageSettingIdPresetEnum.MOBILE_ATHENA_APC_WORK_SHOP_ONLINE_CANCEL_DETAIL.toString());
        action.setRawData(rawData);
        button.setAction(action);
        return button;
    }

    public static Button createApcWorkShopOnlineSeeMore(String locale, LocaleService localeService,
                                                        Map<String, Object> data, Object onSiteResourcePlanningMechanism) {
        Button button = new Button();
        button.setId(UUIDUtil.getUuid());
        button.setName(localeService.getLanguageValue(locale, "查看"));
        button.setType(BottomButtonStyleEnum.NORMAL.getValue());
        button.setIsCheckButton(false);
        Action action = new Action();

        //現場資源規劃機制 是否生效呈现不同资料 不为空就是生效
        if (ObjectUtil.isNotEmpty(onSiteResourcePlanningMechanism)) {
            //生效
            action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_WORK_SHOP_ONLINE_AREA_DETAIL_TAKE_EFFECT.toString());
        } else {
            //未生效
            action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_WORK_SHOP_ONLINE_AREA_DETAIL.toString());
        }
        action.setJumpPageTitle(localeService.getLanguageValue(locale, "区域实际占用情况"));
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setRawData(data);
        button.setAction(action);
        return button;
    }

    /**
     * 人员状况已上线按钮
     *
     * @param woOpReportInfoList
     * @param locale
     * @param localeService
     * @param isMerge
     * @return
     */
    public static List<Button> buildButtonList(List<WoOpReportInfo> woOpReportInfoList, String locale, LocaleService localeService, boolean isMerge) {
        List<Button> buttonList = new ArrayList<>();
        // 合并工单名称由查看工单改为详细信息
        if (isMerge) {
            Action queryAction = new Action();
            queryAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_PERSONEL_STATE_MERGE_DETAIL.toString());
            queryAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
            queryAction.setDataId(UUIDUtil.getUuid());
            Map<String, Object> rawData = new HashMap<>();
            rawData.put("mergeWoOpReportInfoList", woOpReportInfoList);
            queryAction.setRawData(rawData);
            buttonList.add(Button.createButton(localeService.getLanguageValue(locale,
                    "详细信息(" + woOpReportInfoList.size() + ")"), UUIDUtil.getUuid(), BottomButtonStyleEnum.NORMAL.getValue(), queryAction));
        } else {
            Action queryAction = new Action();
            queryAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_PERSONEL_STATE_ONLINE_DETAIL.toString());
            queryAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
            queryAction.setDataId(UUIDUtil.getUuid());
            Map<String, Object> rawData = new HashMap<>();
            rawData.put("woOpReportInfo", woOpReportInfoList.get(0));
            queryAction.setRawData(rawData);
            buttonList.add(Button.createButton(localeService.getLanguageValue(locale,
                    "详细信息"), UUIDUtil.getUuid(), BottomButtonStyleEnum.NORMAL.getValue(), queryAction));
        }

        // 主管才展示下线按钮
        if (BooleanUtils.isTrue(woOpReportInfoList.get(0).isSupervisor())) {
            Map<String, Object> businessUnitMap = new HashMap<>(1);
            businessUnitMap.put("eoc_company_id", woOpReportInfoList.get(0).getEocCompanyId());
            businessUnitMap.put("eoc_site_id", woOpReportInfoList.get(0).getEocSiteId());

            Action cancelOnlineAction = new Action();
            cancelOnlineAction.setType(ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue());
            cancelOnlineAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/personelState/cancelOnline");
            Map<String, Object> cancelOnlineRawData = new HashMap<>();
            cancelOnlineRawData.put("woOpReportInfoList", woOpReportInfoList);
            cancelOnlineRawData.put("isMerge", isMerge);
            cancelOnlineRawData.put("businessUnit", businessUnitMap);
            cancelOnlineRawData.put("actionId", isMerge ? "wo.merge.op.report.cancel.check.in.info.process"
                    : "wo.op.report.cancel.check.in.info.process");
            cancelOnlineAction.setRawData(cancelOnlineRawData);
            buttonList.add(Button.createButton(localeService.getLanguageValue(locale, "取消上线"), UUIDUtil.getUuid(), BottomButtonStyleEnum.NORMAL.getValue(), cancelOnlineAction));

            Action offLineAction = new Action();
            offLineAction.setType(ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue());
            offLineAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/personelState/peopleOffline");
            Map<String, Object> offLineRawData = new HashMap<>();
            offLineRawData.put("woOpReportInfoList", woOpReportInfoList);
            offLineRawData.put("isMerge", isMerge);
            offLineRawData.put("businessUnit", businessUnitMap);
            offLineRawData.put("actionId", "wo.op.report.info.process");
            offLineAction.setRawData(offLineRawData);
            buttonList.add(Button.createButton(localeService.getLanguageValue(locale, "人员下线"), UUIDUtil.getUuid(), BottomButtonStyleEnum.NORMAL.getValue(), offLineAction));
        }
        return buttonList;
    }

    public static Button createButton(String name, Integer type, Action action) {
        Button button = new Button();
        button.setName(name);
        button.setType(type);
        button.setAction(action);
        return button;
    }

    public static Button createButton(String name, String id, Integer type, Action action) {
        Button button = new Button();
        button.setName(name);
        button.setId(id);
        button.setType(type);
        button.setAction(action);
        return button;
    }

    public static Button createButton(String name, String stateName, String id, Integer type, Action action) {
        Button button = new Button();
        button.setName(name);
        button.setStateName(stateName);
        button.setId(id);
        button.setType(type);
        button.setAction(action);
        return button;
    }

    public boolean isEmpty() {
        if (StringUtils.hasLength(this.getId())) {
            return false;
        }
        return true;
    }

    public void handleButtonCustomConfig(ApiRequest apiRequest, UiBotModel pcUiBotModel,
                                         Map<String, Object> groupedBizData) {
        if (null == this.getCustomConfig()) {
            return;
        }
        if (CustomIdEnum.ZHILINK.getValue().equals(this.getCustomConfig().getCustomId())
                && CustomCodeEnum.PRINT.getValue().equalsIgnoreCase(this.getCustomConfig().getCustomCode())) {
            // 打印按钮会根据返回的数据设置按钮展示名称和样式
            if (groupedBizData.containsKey("button_type") && groupedBizData.containsKey("button_name")) {
                String buttonType = String.valueOf(groupedBizData.get("button_type"));
                String buttonName = String.valueOf(groupedBizData.get("button_name"));
                if ("1".equalsIgnoreCase(buttonType)) {
                    // 打印
                    this.setType(BottomButtonStyleEnum.DETAIL_STRESS.getValue());
                    this.getAction().setActionDone(false);
                } else {
                    // 可补打时，不需要校验
                    this.setType(BottomButtonStyleEnum.DETAIL_NORMAL.getValue());
                    this.getAction().setActionDone(true);
                    // 防止配置数据中没有config会NPE，故创建新对象覆盖
                    ActionValidationConfig config = new ActionValidationConfig();
                    config.setEnable(false);

                    this.getAction().setValidationConfig(config);
                }
                this.setName(buttonName);
            }
            String schema = "wo_data";
            Map<String, Object> rawData = new HashMap<>(3);
            Map<String, Object> rawDataData = new HashMap<>(1);
            rawDataData.put(schema, groupedBizData.get(schema));

            rawData.put("data", rawDataData);
            rawData.put("executeContext", pcUiBotModel.getExecuteContext());
            this.getAction().setRawData(rawData);
            this.getAction()
                    .setRequestUrl(AppContext.getBaseUrl() + this.getAction().getRequestUrl());
        } else if (CustomIdEnum.ZHILINK.getValue().equals(this.getCustomConfig().getCustomId())
                && CustomCodeEnum.PASTE.getValue().equalsIgnoreCase(this.getCustomConfig().getCustomCode())) {
            this.getAction().setDataId(apiRequest.getDataId());
            String schema = "wo_data";
            Map<String, Object> rawData = new HashMap<>(3);
            Map<String, Object> rawDataData = new HashMap<>(1);
            rawDataData.put(schema, groupedBizData.get(schema));

            rawData.put("data", rawDataData);
            rawData.put("executeContext", pcUiBotModel.getExecuteContext());
            this.getAction().setRawData(rawData);
        } else if (CustomIdEnum.ZHILINK.getValue().equals(this.getCustomConfig().getCustomId())
                && CustomCodeEnum.CHECKOUT.getValue().equalsIgnoreCase(this.getCustomConfig().getCustomCode())) {
            ZhilinkService zhilinkService = SpringContextHolder.getBean("zhilinkService");
            this.getAction().setRawData(zhilinkService.getScanRawDataInCheckoutDetail(pcUiBotModel, groupedBizData));
            this.getAction()
                    .setRequestUrl(AppContext.getBaseUrl() + this.getAction().getRequestUrl());
        } else {

        }
    }

    @Override
    public String returnComponentType() {
        return Button.COMPONENT_TYPE;
    }

    public Action getAction() {
        return action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                                     PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        boolean notExist = cmptContext.getCommonRawDataParentType() == null;
        if (notExist) {
            cmptContext.setCommonRawDataParentType(CommonRawDataParentType.ALONE_BUTTON.getValue());
        }
        this.componentId = this.handleButtonComponentId(this.componentId, this.submitAction);
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.handleButton(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        if (notExist) {
            cmptContext.setCommonRawDataParentType(null);
        }
    }

    private void handleButton(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                              PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        this.submitTransformJumpV1Button(this, cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.name = Optional.ofNullable(this.submitAction).map(UiBotAction::getTitle).orElse("");
        this.showNum = Optional.ofNullable(this.submitAction)
                .map(UiBotAction::getJumpAction)
                .map(UiBotJumpAction::getShowNum)
                .orElse(false);
        this.isCheckButton = Optional.ofNullable(this.submitAction)
                .map(UiBotAction::getJumpAction)
                .map(UiBotJumpAction::getIsCheckButton)
                .orElse(true);
        this.type = Optional.ofNullable(this.submitAction)
                .map(UiBotAction::getJumpAction)
                .map(UiBotJumpAction::getBtnStyleType)
                .orElse(this.type == null ? BottomButtonStyleEnum.STRESS.getValue() : this.type);
        this.iconName = Optional.ofNullable(this.submitAction)
                .map(UiBotAction::getJumpAction)
                .map(UiBotJumpAction::getIconName)
                .orElse(UibotIconNameEnum.SJQ_EMPTY.getValue());
        if (this.submitAction != null && ButtonTypeEnum.JUMP.getValue().equals(this.submitAction.getBtnType())) {
            // wjw TODO: 2023/10/20 前端保存情况下需要给此值，先写死
            this.stateName = LocaleUtil.getMobileTextByKey(executeContext.getLocale(), "已处理");

            // 跳转类型才会存在滑动特效配置，提交类型不存在滑动特效配置
            this.detailPageSwiper = Optional.ofNullable(this.submitAction.getJumpAction()).map(UiBotJumpAction::getDetailPageSwiper).orElse(false);
            // 跳转
            // wjw TODO: 2023/8/22 跳转
            UiBotJumpAction jumpAction = this.submitAction.getJumpAction();
            if (jumpAction != null) {
                boolean isUtInspectionResultsRegistration = false;
                if ("UT_InspectionResultsRegistration_customize_card_button_name".equals(this.name)) {
                    // 试验优测定制 - 条目详情页card按钮名称处理
                    String value = StringUtil.valueOf(data.get("inspection_status"));
                    LocaleService localeService = SpringContextHolder.getBean(LocaleServiceImpl.class);
                    this.name = localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), MobileInspectionStatusEnum.getNameByStatus(value));
                    // 待检测 type=3; 已检测 type=4
                    this.type = BottomButtonStyleEnum.DETAIL_STRESS.getValue();
                    if (MobileInspectionStatusEnum.HAS_CHECKED.getStatus().equals(value)) {
                        this.type = BottomButtonStyleEnum.DETAIL_NORMAL.getValue();
                    }
                    isUtInspectionResultsRegistration = true;
                }
                Action<Map<String, Object>> action = new Action<>();
                action.setType(jumpAction.getType());
                // 批量提交、本地保存的情况下，需要dataid，使前端能找到对应的条目，修改元数据
                action.setDataId(mobilePageRawData.getDataId());
                action.setDesignParameter(jumpAction.getDesignParameter());
                action.setActionJsEvent(jumpAction.getActionJsEvent());
                action.setBusinessType(jumpAction.getBusinessType());
                action.setSaveType(jumpAction.getSaveType());

                action.setBusinessRawData(BusinessRawData.builder()
                        .componentId(mobilePageRawData.getComponentId())
                        .currentPageId(cmptContext.getPageId())
                        .tmActivityId(executeContext.getTmActivityId())
                        .mobileDataId(executeContext.getMobileDataId())
                        .refreshPageId(jumpAction.getJumpPageId(executeContext))
                        .build());

                // 前端保存加上toastMsg提示
                if (ActionTypeEnum.BACK_ONE_WITH_NO_REFRESH.getValue().equals(action.getType())) {
                    action.setToastMsg(this.name + LocaleUtil.getMobileTextByKey(AppRequestContext.getContextEntity().getLocale(), "成功"));
                }
                Map<String, Object> rawData = new HashMap<>();

                //滑动特效弹窗处理，type=20或者2222或者2且开了滑动特效
                if ((Objects.equals(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue(), jumpAction.getType()) && this.detailPageSwiper) ||
                        Objects.equals(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM_SWIPER.getValue(), jumpAction.getType()) ||
                        Objects.equals(ActionTypeEnum.CUSTOMIZE_POPUP_DISPLAYS_PAGE.getValue(), jumpAction.getType())) {
                    Map<String, Map<String, Object>> pageLayoutInfo = cmptContext.getPageLayoutInfo();
                    this.detailPageSwiper = true;
                    //获取页面的数据源，判断开新的兄弟详情type=20，不然走原本type=2222的逻辑
                    if (ObjectUtils.isNotEmpty(pageLayoutInfo)) {
                        Map<String, Object> map = pageLayoutInfo.get(jumpAction.getJumpPageId(executeContext));
                        if (isOpenNewDetailPage(map, executeContext)) {
                            action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM_SWIPER.getValue());
                            rawData.put("pageLayoutInfo", pageLayoutInfo);
                            rawData.put("jumpPageId", jumpAction.getJumpPageId(executeContext));
                            action.setRawData(rawData);
                        }else{
                            action.setType(ActionTypeEnum.CUSTOMIZE_POPUP_DISPLAYS_PAGE.getValue());
                        }
                    }else{
                        action.setType(ActionTypeEnum.CUSTOMIZE_POPUP_DISPLAYS_PAGE.getValue());
                    }
                }
                if (Objects.equals(ActionTypeEnum.OPEN_NEW_PAGE_FROM_EXPORT_ALL.getValue(), jumpAction.getType()) ||
                        Objects.equals(ActionTypeEnum.OPEN_NEW_PAGE_FROM_EXPORT.getValue(), jumpAction.getType()) ||
                        Objects.equals(ActionTypeEnum.OPEN_NEW_PAGE_FROM_IMPORT.getValue(), jumpAction.getType()) ||
                        Objects.equals(ActionTypeEnum.OPEN_NEW_PAGE_FROM_DOWNLOAD.getValue(), jumpAction.getType())) {
                    rawData.put("data", data);
                    rawData.put("executeContext", executeContext);
                    Map<String, Object> operationRawData = jumpAction.getRawData();
                    rawData.putAll(operationRawData);
                    action.setRawData(rawData);
                } else if (Objects.equals(ActionTypeEnum.BLOOTH_PRINT.getValue(), jumpAction.getType())) {
                    // 打印
                    this.buildPrintRawData(this.submitAction, executeContext, action, data);
                } else if (StringUtils.hasLength(jumpAction.getJumpPageId(executeContext))) {
                    // pageTitle 通过pageid走render后返回的名称为准
                    action.setJumpPageTitle("");
                    action.setJumpPageId(jumpAction.getJumpPageId(executeContext));
                    action.setRefreshPageId(jumpAction.getJumpPageId(executeContext));
                    if (CommonRawDataParentType.ALONE_LIST.getValue().equals(cmptContext.getCommonRawDataParentType())) {
                        // 独立cardList下，移除RawData中提取cardList、card中的commonChildRawData部分
                        this.needParentRawData = true;
                    }/* else if (CommonRawDataParentType.ALONE_CARD.getValue().equals(cmptContext.getCommonRawDataParentType())) {
                        // wjw TODO: 2024/7/19 独立card下，移除card中的commonChildRawData部分 ---- 后期优化
                    }*/ else {
                        rawData.put("allRawMap", mobilePageRawData.getAllRawMap());
                        rawData.put("rawMap", mobilePageRawData.getRawMap());
                        rawData.put("rawDataType", mobilePageRawData.getRawDataType());
                        rawData.put("baseEntryExtendedFields", mobilePageRawData.getExtendedFields());
                        rawData.put("sourceCategory", mobilePageRawData.getSourceCategory());
                        rawData.put("dataKeys", mobilePageRawData.getDataKeys());
                        rawData.put("componentId", mobilePageRawData.getComponentId());
                        // rawdata中存入代理token，此值在拦截器中处理
                        rawData.put("digi-proxy-token", AppRequestContext.getContextEntity().getProxyToken());
                        rawData.put("data", data);
                        rawData.put("executeContext", executeContext);
                    }
                    if (IndexNavBar.notOptimizedRawData(cmptContext.getAppInfo())) {
                        // wjw TODO: 2024/7/23 如果版本号小于1.50.0，走未优化rawData逻辑。几个迭代后移除此if逻辑
                        rawData.put("allRawMap", mobilePageRawData.getAllRawMap());
                        rawData.put("rawMap", mobilePageRawData.getRawMap());
                        rawData.put("rawDataType", mobilePageRawData.getRawDataType());
                        rawData.put("baseEntryExtendedFields", mobilePageRawData.getExtendedFields());
                        rawData.put("sourceCategory", mobilePageRawData.getSourceCategory());
                        rawData.put("dataKeys", mobilePageRawData.getDataKeys());
                        rawData.put("componentId", mobilePageRawData.getComponentId());
                        // rawdata中存入代理token，此值在拦截器中处理
                        rawData.put("digi-proxy-token", AppRequestContext.getContextEntity().getProxyToken());
                        rawData.put("data", data);
                        rawData.put("executeContext", executeContext);
                    }
                    if (!CollectionUtils.isEmpty(jumpAction.getRawData())) {
                        rawData.put("rawData", jumpAction.getRawData());
                    }
                    if (isUtInspectionResultsRegistration) {
                        rawData.put("prePageId", AppRequestContext.getContextEntity().getPageId());
                    }
                    // wjw FIXME: 2023/12/14 返回页面类型下，不设置rawdata，因会覆盖掉原页面的rawdata内容（前端会把此rawdata putAll 到原页面rawdata中）
                    if (!Arrays.asList(401, 411, 44).contains(action.getType())) {
                        action.setRawData(rawData);
                    }
                }
                this.setAction(action);
            }
        } else if (this.submitAction != null && ButtonTypeEnum.JUMP_V1.getValue().equals(this.submitAction.getBtnType())) {
            // v1版跳转页面
            UiBotJumpAction jumpAction = this.submitAction.getJumpAction();
            if (jumpAction != null) {
                Action<Map<String, Object>> action = new Action<>();
                action.setType(jumpAction.getType());
                if (StringUtils.hasLength(jumpAction.getJumpPageId(executeContext))) {
                    action.setJumpPageTitle(this.name);
                    action.setJumpPageId(jumpAction.getJumpPageId(executeContext));
                    if (!CollectionUtils.isEmpty(jumpAction.getRawData())) {
                        action.setRawData(jumpAction.getRawData());
                    }
                }
                this.setAction(action);
            }
        } else {
            // 提交
            Action<ButtonRawData> action = new Action<>();
            action.setType(ActionTypeEnum.CALL_API.getValue());
            // 批量提交的情况下，需要dataid，使前端能找到对应的条目，变更为第二次编辑的参数
            action.setDataId(mobilePageRawData.getDataId());
            action.setSaveType(Optional.ofNullable(this.submitAction).map(UiBotAction::getJumpAction).map(UiBotJumpAction::getSaveType).orElse(null));

            ButtonRawData buttonRawData = new ButtonRawData();
            action.setRawData(buttonRawData);

            buttonRawData.setData(this.buildRawDataData(this.submitAction, data, mobilePageRawData))
                    .setAction(this.submitAction)
                    .setSubmitStrategyEnum(SubmitStrategyEnum.DSL)
                    .setActionAfterSubmit(this.buildActionAfterSubmit(this.submitAction, executeContext, mobilePageRawData))
                    .setDigiProxyToken(AppRequestContext.getContextEntity().getProxyToken())
                    .setDataId(mobilePageRawData.getDataId())
                    .setRawData(Optional.ofNullable(this.submitAction).map(UiBotAction::getJumpAction).map(UiBotJumpAction::getRawData).orElse(null))
                    .setSubmitSelectCardData(!MultiFunctionListChoiceEnum.NO_CHOICE.name().equals(cmptContext.getChoice()));
            // 二次弹窗
            action.setConfirmPop(this.buildConfirmPop(this.submitAction));
            this.setAction(action);
        }
        // clear
        this.submitAction = null;
    }

    private void buildPrintRawData(UiBotAction submitAction, PcUiBotExecuteContext executeContext, Action<Map<String, Object>> action, Map<String, Object> data) {
        Map<String, Object> rawData = new HashMap<>();
        if (CollectionUtils.isEmpty(submitAction.getTemplates())) {
            // 兼容历史
            // rawdata中存入代理token，此值在拦截器中处理
            rawData.put("digi-proxy-token", AppRequestContext.getContextEntity().getProxyToken());
            rawData.put("data", data);
            rawData.put("executeContext", executeContext);
            rawData.put("printTemplateCode", submitAction.getPrintTemplateCode());
            rawData.put("actionParams", submitAction.getActionParams());
            // wjw TODO: 2024/12/18 前端使用了此字段,选择条目时修改RawData中data数据，故保留，后面后端处理data时再去除
            rawData.put("mainDataSourceName", executeContext.getMainDataSourceName());
            rawData.put("isNewVersion", false);
        } else {
            // rawdata中存入代理token，此值在拦截器中处理
            rawData.put("digi-proxy-token", AppRequestContext.getContextEntity().getProxyToken());
            rawData.put("data", data);
            rawData.put("action", SpringContextHolder.getBean(PrintActionCreateService.class).createAction(JsonUtil.objectToJavaObject(submitAction, PcUiBotSubmitAction.class), executeContext));
            rawData.put("targetId", this.getComponentId());
            // wjw TODO: 2024/12/18 前端使用了此字段,选择条目时修改RawData中data数据，故保留，后面后端处理data时再去除
            rawData.put("mainDataSourceName", executeContext.getMainDataSourceName());
            rawData.put("isNewVersion", true);
        }
        action.setRawData(rawData);
    }

    public static Boolean isOpenNewDetailPage(Map<String, Object> data, PcUiBotExecuteContext executeContext) {
        //兄弟详情数据源和节点不为空，且与主数据源不一致的情况下开新的兄弟详情
        return (ObjectUtils.isNotEmpty(data) &&
                ObjectUtils.isNotEmpty(data.get("dataSource")) &&
                ObjectUtils.isNotEmpty(data.get("node"))) &&
                !Objects.equals(executeContext.getMainDataSourceName(), data.get("dataSource")) &&
                !Objects.equals(executeContext.getMainDataSourceName(), data.get("node"));
    }

    private String handleButtonComponentId(String componentId, UiBotAction submitAction) {
        // 按钮组件存在componentId,直接返回
        if (StringUtils.hasLength(componentId)) {
            return componentId;
        }
        // 按钮组件不存在componentId,获取jumpAction中的componentId，赋值给外层
        return Optional.ofNullable(submitAction).map(UiBotAction::getJumpAction).map(UiBotJumpAction::getComponentId).orElse(componentId);
    }


    /**
     * 提交类型按钮转换成跳转V1类型按钮
     */
    private void submitTransformJumpV1Button(Button<T> button, ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                                             PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        UiBotAction submitAction = button.getSubmitAction();
        if (submitAction == null) {
            return;
        }
        if (ButtonTypeEnum.isNotSubmit(submitAction.getBtnType())) {
            return;
        }

        if (submitAction.getJumpAction() != null) {
            if (Boolean.TRUE.equals(submitAction.getJumpAction().getIsCustomizedApprovalButton())) {
                //非主页面的签核按钮 说明是设计器配置的签核按钮界面,不走V1的默认界面 ,直接returen
                return;
            }
        }

        //V2签核卡底部按钮actionId有的会在AttachActions里，先取submitAction的actionId，没有或者不匹配再取AttachActions里面的actionId
        ApprovalButtonTypeEnum approvalButtonTypeEnum = ApprovalButtonTypeEnum.getEnumByType(submitAction.getActionId());
        if (approvalButtonTypeEnum == null && !CollectionUtils.isEmpty(submitAction.getAttachActions())) {
            approvalButtonTypeEnum = submitAction.getAttachActions().stream()
                    .map(item -> ApprovalButtonTypeEnum.getEnumByType(item.getActionId()))
                    .filter(Objects::nonNull)
                    .findFirst()
                    .orElse(null);
        }

        if (Objects.isNull(approvalButtonTypeEnum)) {
            return;
        }

        switch (approvalButtonTypeEnum) {
            // 数据转派
            case DATA_REASSIGNMENT_ACTION:
                this.handleDataReassignmentActionButton(cmptContext, submitAction, data, mobilePageRawData);
                break;
            //签核：退回重办
            case REEXECUTE:
            case ATHENA_BPM_REEXECUTE:
                this.handleApprovalReexecuteActionButton(cmptContext, submitAction, data, mobilePageRawData);
                break;
            //签核：同意
            case AGREE:
                this.handleApprovalAgreeActionButton(cmptContext, submitAction, data, mobilePageRawData);
                break;
            //签核：不同意/终止
            case DISAGREE:
            case ATHENA_BPM_DISAGREE:
                this.handleApprovalDisagreeActionButton(cmptContext, submitAction, data, mobilePageRawData);
                break;
            //签核：加签
            case ADD_TASK:
            case ATHENA_BPM_ADD_TASK:
                this.handleApprovalAddActionButton(cmptContext, submitAction, data, mobilePageRawData);
                break;
            //签核：退回重签
            case REAPPROVE:
            case ATHENA_BPM_REAPPROVE:
                this.handleApprovalReapproveActionButton(cmptContext, submitAction, data, mobilePageRawData);
                break;
            default:
        }
    }

    private void handleApprovalReapproveActionButton(ComponentContext cmptContext, UiBotAction submitAction, Map<String, Object> data, MobilePageRawData mobilePageRawData) {
        submitAction.setBtnType(ButtonTypeEnum.JUMP_V1.getValue());
        UiBotJumpAction jumpAction = submitAction.getJumpAction();
        if (jumpAction == null) {
            jumpAction = new UiBotJumpAction();
        }
        submitAction.setJumpAction(jumpAction);

        jumpAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        jumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_REAPPROVE.name());
        Map<String, Object> extendedFields = TaskDataExtractUtil.getSignoffProgressData(cmptContext.getRawUiBotPageData());
        jumpAction.setRawData(this.buildRawData(cmptContext, submitAction, data, mobilePageRawData, extendedFields, false));
    }

    private void handleApprovalAddActionButton(ComponentContext cmptContext, UiBotAction submitAction, Map<String, Object> data, MobilePageRawData mobilePageRawData) {
        submitAction.setBtnType(ButtonTypeEnum.JUMP_V1.getValue());
        UiBotJumpAction jumpAction = submitAction.getJumpAction();
        if (jumpAction == null) {
            jumpAction = new UiBotJumpAction();
        }
        submitAction.setJumpAction(jumpAction);

        jumpAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        jumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_ADDTASK.name());
        jumpAction.setRawData(this.buildRawData(cmptContext, submitAction, data, mobilePageRawData, true));
    }

    private void handleApprovalDisagreeActionButton(ComponentContext cmptContext, UiBotAction submitAction, Map<String, Object> data, MobilePageRawData mobilePageRawData) {
        submitAction.setBtnType(ButtonTypeEnum.JUMP_V1.getValue());
        UiBotJumpAction jumpAction = submitAction.getJumpAction();
        if (jumpAction == null) {
            jumpAction = new UiBotJumpAction();
        }
        submitAction.setJumpAction(jumpAction);

        jumpAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        jumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_DISAGREE.name());
        jumpAction.setRawData(this.buildRawData(cmptContext, submitAction, data, mobilePageRawData, false));
    }

    private void handleApprovalAgreeActionButton(ComponentContext cmptContext, UiBotAction submitAction, Map<String, Object> data, MobilePageRawData mobilePageRawData) {
        submitAction.setBtnType(ButtonTypeEnum.JUMP_V1.getValue());
        UiBotJumpAction jumpAction = submitAction.getJumpAction();
        if (jumpAction == null) {
            jumpAction = new UiBotJumpAction();
        }
        submitAction.setJumpAction(jumpAction);

        jumpAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        jumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_AGREE.name());
        jumpAction.setRawData(this.buildRawData(cmptContext, submitAction, data, mobilePageRawData, false));
    }

    private void handleApprovalReexecuteActionButton(ComponentContext cmptContext, UiBotAction submitAction, Map<String, Object> data, MobilePageRawData mobilePageRawData) {
        submitAction.setBtnType(ButtonTypeEnum.JUMP_V1.getValue());
        UiBotJumpAction jumpAction = submitAction.getJumpAction();
        if (jumpAction == null) {
            jumpAction = new UiBotJumpAction();
        }
        submitAction.setJumpAction(jumpAction);
        jumpAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        jumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_REEXECUTE.name());
        jumpAction.setBtnStyleType(BottomButtonStyleEnum.NORMAL.getValue());
        jumpAction.setRawData(this.buildRawData(cmptContext, submitAction, data, mobilePageRawData, false));
    }

    private void handleDataReassignmentActionButton(ComponentContext cmptContext, UiBotAction submitAction, Map<String, Object> data, MobilePageRawData mobilePageRawData) {
        submitAction.setBtnType(ButtonTypeEnum.JUMP_V1.getValue());
        UiBotJumpAction jumpAction = submitAction.getJumpAction();
        if (jumpAction == null) {
            jumpAction = new UiBotJumpAction();
        }
        submitAction.setJumpAction(jumpAction);

        jumpAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        jumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_BIZ_APPROVAL_REASSIGN.name());
        jumpAction.setRawData(this.buildRawData(cmptContext, submitAction, data, mobilePageRawData, true));
    }

    private Map<String, Object> buildRawData(ComponentContext cmptContext, UiBotAction submitAction, Map<String, Object> data, MobilePageRawData mobilePageRawData, boolean containAppCode) {
        return this.buildRawData(cmptContext, submitAction, data, mobilePageRawData, null, containAppCode);
    }

    private Map<String, Object> buildRawData(ComponentContext cmptContext, UiBotAction submitAction, Map<String, Object> data, MobilePageRawData mobilePageRawData, Map<String, Object> extendedFields, boolean containAppCode) {
        String appCode = "";
        if (containAppCode) {
            // rootDataId:子页面入参传递值是任务详情页入参dataId值
            String dataId = cmptContext.getRawData().getString("rootDataId");
            if (!StringUtils.hasLength(dataId)) {
                // 为空：说明可能是任务详情页，直接取入参的dataId即可
                dataId = AppRequestContext.getContextEntity().getDataId();
            }
            if (StringUtils.hasLength(dataId) && dataId.contains("-")) {
                // 说明此dataId是随机生成的UUID，过滤掉
                dataId = null;
            }
            if (StringUtils.hasLength(dataId)) {
                DigiwinAtmcProxyService digiwinAtmcProxyService = SpringContextHolder.getBean(DigiwinAtmcProxyService.class);
                DigiwinAtmcBacklogDetail backlogDetail = digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(AppRequestContext.getContextEntity().getLocale(),
                        AppRequestContext.getContextEntity().getIamUserToken(), dataId);
                appCode = Optional.ofNullable(backlogDetail).map(DigiwinAtmcBacklogDetail::getAppCode).orElse("");
            }
        }
        return buildRawData(submitAction, data, mobilePageRawData, extendedFields, appCode);
    }

    private Map<String, Object> buildRawData(UiBotAction submitAction, Map<String, Object> data, MobilePageRawData mobilePageRawData, Map<String, Object> extendedFields, String appCode) {
        return BottomButtonDigiwinAthena.assembleRawData(submitAction,
                this.buildRawDataData(submitAction, data, mobilePageRawData),
                extendedFields, Optional.ofNullable(submitAction).map(UiBotAction::getId).orElse(""),
                appCode);
    }

    private ConfirmPop buildConfirmPop(UiBotAction submitAction) {
        if (submitAction == null) {
            return null;
        }
        UiBotJumpAction jumpAction = submitAction.getJumpAction();
        if (jumpAction == null) {
            return null;
        }
        return jumpAction.getConfirmPop();
    }

    private Map<String, Object> buildRawDataData(UiBotAction submitAction, Map<String, Object> data, MobilePageRawData mobilePageRawData) {
        String dataSourceName = Optional.ofNullable(submitAction)
                .map(UiBotAction::getSubmitType)
                .map(UiBotActionSubmitType::getSchema)
                .orElse("");
        if (!StringUtils.hasLength(dataSourceName)) {
            return data;
        }
        boolean submitAllData = true;
        if (submitAction != null && submitAction.getJumpAction() != null) {
            //处理详情提交数据:只提交当前页面修改的数据
            submitAllData = submitAction.getJumpAction().getSubmitAllData();
        }
        Map<String, Object> rawDataData = data;
        if (!submitAllData) {
            //处理详情提交数据:只提交当前页面修改的数据
            Object o = UiBotDesignerRenderService.getDataBySchema(rawDataData, dataSourceName);
            if (o instanceof Map) {
                rawDataData = (Map<String, Object>) o;
            }
            if (o instanceof List) {
                List<Map<String, Object>> list = (List<Map<String, Object>>) o;
                if (!CollectionUtils.isEmpty(list)) {
                    rawDataData = list.get(0);
                }
            }
        }
        if (submitAllData && !CollectionUtils.isEmpty(mobilePageRawData.getRawMap())) {
            rawDataData = mobilePageRawData.getRawMap();
        }
        if (rawDataData.containsKey(dataSourceName)) {
            return rawDataData;
        } else {
            Map<String, Object> map = new HashMap<>();
            if (StringUtils.hasLength(dataSourceName)) {
                if ("object".equals(mobilePageRawData.getRawDataType())) {
                    map.put(dataSourceName, rawDataData);
                } else {
                    map.put(dataSourceName, Lists.newArrayList(rawDataData));
                }
            } else {
                map = rawDataData;
            }
            return map;
        }
    }

    /**
     * 构建提交操作后，action行为动作
     *
     * @param submitAction
     * @param executeContext
     * @param mobilePageRawData
     * @return
     */
    private Action<Map<String, Object>> buildActionAfterSubmit(UiBotAction submitAction, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        if (submitAction == null) {
            return null;
        }
        UiBotJumpAction jumpAction = submitAction.getJumpAction();
        if (jumpAction == null) {
            return null;
        }
        Action<Map<String, Object>> action = new Action<>();
        action.setNanaMessageId(jumpAction.getNanaMessageId());
        action.setType(jumpAction.getType());
        if (StringUtils.hasLength(jumpAction.getJumpPageId(executeContext))) {
            action.setDataId(null);
            // pageTitle 通过pageid走render后返回的名称为准
            action.setJumpPageTitle("");
            action.setJumpPageId(jumpAction.getJumpPageId(executeContext));
            Map<String, Object> rawData = new HashMap<>();
            action.setRawData(rawData);
        }
        // 试验优测定制 - 1241、12411、12001，关闭当前页签，跳到下一个页签，并刷新主页面
        if (Arrays.asList(1241, 12411, 12001).contains(action.getType())) {
            action.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name());
        } else {
            if (StringUtils.hasLength(jumpAction.getJumpPageId(executeContext))) {
                action.setRefreshPageId(jumpAction.getJumpPageId(executeContext));
            } else {
                if (PcUiBotPatternUtil.isBaseData(executeContext.getPattern())) {
                    // 数据录入，刷新主页面
                    action.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_BASIC_DATA_ENTRY_BROWSE_PAGE.name());
                } else {
                    // 刷新首页
                    action.setRefreshPageId(PageSettingIdPresetEnum.FLASH_MY_TODO.name());
                }
            }
        }
        // wjw TODO: 2023/11/1 注意：refreshDataId,先不赋值，因为一些页面如果给了refreshDataId，会导致页面不刷新，
        // refreshDataId刷新效果只作用于card组件有兄弟时，刷新当前页面不刷新兄弟页面。
        // 其它页面如果给了refreshDataId，导致页面不刷新
//        if (StringUtils.hasLength(mobilePageRawData.getDataId())) {
//            action.setRefreshDataId(mobilePageRawData.getDataId());
//        }
        // 提交按钮增加提交后的提示，成功提示语与按钮名称对应
        action.setSuccessMsg(this.name + LocaleUtil.getMobileTextByKey(AppRequestContext.getContextEntity().getLocale(), "成功"));
        return action;
    }
}