package com.digiwin.mobile.mobileuibot.core.component.button;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.core.component.MobileLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Map;

/**
 * <p>功能描述：按钮组件和鼎捷Athena集成时需要的原始数据对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ButtonRawData
 * @Author: Zaregoto
 * @Date: 2021/5/25 10:59
 */
@Data
@Accessors(chain = true)
public class ButtonRawData implements Serializable {
    private static final long serialVersionUID = 1792839297830925675L;

    private String id;
    private UiBotAction action;
    private Map<String, Object> data;

    /**
     * 移动端布局类型枚举
     * 在与开发平台设计器集成后引入该字段，用于判断提交时的参数的解析该走哪个逻辑
     */
    private MobileLayoutTypeEnum mobileLayoutType;

    /**
     * 与开发平台设计器集成后走V2策略渲染页面时，引入该字段，用于判断提交时的参数的解析该走哪个逻辑
     */
    private SubmitStrategyEnum submitStrategyEnum;
    /**
     * 与开发平台设计器集成后走V2策略渲染页面时，引入该字段，用于提交后触发的action操作
     */
    private Action<Map<String, Object>> actionAfterSubmit;

    /**
     * 代理token
     */
    @JsonProperty("digi-proxy-token")
    @JSONField(name = "digi-proxy-token")
    private String digiProxyToken;

    /**
     * 作用于提交场景，定位列表中具体的条目数据 -- V2版新增
     * card卡片的dataid设置一个唯一值，作用于详情页保存后更新原始数据查找的标志，与card的按钮、detailPage的dataid相同
     */
    private String dataId;

    /**
     * 提交接口传递 额外数据，可能存储一些用于判断走不同逻辑的 key
     */
    private Map<String, Object> rawData;

    /**
     * 是否只提交选择的卡片数据
     * true：表示只提交选择的卡片数据；false：data中数据整体提交
     */
    private Boolean submitSelectCardData;

    public ButtonRawData() {
    }

    public ButtonRawData(UiBotAction action, Map<String, Object> data) {
        this.action = action;
        this.data = data;
    }
}
