package com.digiwin.mobile.mobileuibot.core.component.button;

import lombok.Getter;

/**
 * <p>功能描述：设计态设计的按钮类型枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ButtonTypeEnum.java
 * @Author: wangjwc
 * @Date: created at 2023/8/22 11:40
 */
@Getter
public enum ButtonTypeEnum {
    /**
     * 跳转方式
     */
    JUMP("jump"),
    /**
     * 跳转方式--跳转到V1界面--非设计器配置
     */
    JUMP_V1("jump_v1"),
    /**
     * 提交方式
     */
    SUBMIT("submit"),

    ;

    private final String value;

    ButtonTypeEnum(String value) {
        this.value = value;
    }

    public static boolean isJump(String value) {
        return JUMP.getValue().equals(value) || JUMP_V1.getValue().equals(value);
    }

    public static boolean isNotJump(String value) {
        return !isJump(value);
    }

    public static boolean isSubmit(String value) {
        return SUBMIT.getValue().equals(value);
    }

    public static boolean isNotSubmit(String value) {
        return !isSubmit(value);
    }

}
