package com.digiwin.mobile.mobileuibot.core.component.button;

import lombok.Getter;

/**
 * 在卡片内部的按钮样式枚举类
 */
@Getter
public enum CardButtonStyleTypeEnum {

    WHITE_BLUE(3, "白底蓝字，蓝色描边"),
    WHITE_RED(31, "白底红字，红色描边"),
    WHITE_ORANGE(32, "白底橙字，橙色描边"),
    WHITE_GREEN(33, "白底绿字，绿色描边"),
    WHITE_BLACK_GRAY(4, "白底黑字，灰色描边");

    private final Integer code;
    private final String description;

    // 构造函数，用于初始化枚举实例的code和description
    CardButtonStyleTypeEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }
}
