package com.digiwin.mobile.mobileuibot.core.component.button;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParamJsonDeserializer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;
import org.apache.commons.lang3.BooleanUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 页面按钮组件（一般用于跳转明细信息页面）
 *
 * @author zhangjj
 * @date 2022/12/9 14:44
 */
@Data
public class PageButton extends BaseMobileComponent {
    public static final String COMPONENT_TYPE = "PAGE_BUTTON";
    private static final long serialVersionUID = 8770589377662918357L;

    /**
     * 按钮名称
     */
    private String name;

    /**
     * 按钮点击动作
     */
    private Action action;

    /**
     * 显示内容
     */
    private String text;

    /**
     * 样式：1 是原样式，有边距 2：新的样式（参考班组派工的人员在线清单）3：表单里展示的样式（录入组件样式）
     */
    private Integer style = 1;

    /**
     * 1 可录入标准黑色   2只读弱化灰色
     */
    private Integer labelStyle = 1;

    @JsonDeserialize(contentUsing = ActionSubmitParamJsonDeserializer.class)
    private List<ActionSubmitParam> submitParam;

    @Override
    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    @Override
    public void applyEditable(Boolean enable) {
        if (BooleanUtils.isFalse(enable)) {
            this.labelStyle = 2;
        }
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        // 因设计器原有默认给的是2，24I09迭代时，前端才使用此属性，故导致历史组件配置的样式不对，所以需强制设置成1
        this.style = Integer.valueOf(2).equals(this.style) ? 1 : this.style;
        Map<String, Object> rawData = new HashMap<>();
        rawData.put("allRawMap", mobilePageRawData.getAllRawMap());
        rawData.put("rawMap", mobilePageRawData.getRawMap());
        rawData.put("rawDataType", mobilePageRawData.getRawDataType());
        rawData.put("baseEntryExtendedFields", mobilePageRawData.getExtendedFields());
        rawData.put("sourceCategory", mobilePageRawData.getSourceCategory());
        rawData.put("dataKeys", mobilePageRawData.getDataKeys());
        rawData.put("componentId", mobilePageRawData.getComponentId());
        // rawdata中存入代理token，此值在拦截器中处理
        rawData.put("digi-proxy-token", AppRequestContext.getContextEntity().getProxyToken());
        rawData.put("data", data);
        rawData.put("executeContext", executeContext);
        this.action.setRawData(rawData);
        this.action.setDataId(mobilePath);
    }
}