package com.digiwin.mobile.mobileuibot.core.component.button;

import lombok.Data;

/**
 * <p>功能描述：单个底部按钮组件</p>
 * <p>因历史原因 BOTTOM_BUTTON 组件后端表示单个底部按钮，但是返回给前端响应是一个数组，故不能作为单个按钮组件使用；</p>
 * <p>在V1版本DSL转V2版本DSL时，BUTTON_GROUP 按钮组下 contentGroup 数组中，每个对象的 componentType 不能使用原有的 BOTTOM_BUTTON 组件类型；</p>
 * <p>因为前端会把 BOTTOM_BUTTON 类型当成数组处理，但是与V2版本DSL格式冲突；</p>
 * <p>故新建个单个底部按钮组件 SINGLE_BOTTOM_BUTTON，属性与 BOTTOM_BUTTON 完全一致</p>
 *
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: SingleBottomButton
 * @Author: wangjwc
 * @Date: 2023/6/01 14:54
 */
@Data
public class SingleBottomButton extends BottomButtonDigiwinAthena {
    private static final long serialVersionUID = -9002347664724361958L;
    public static final String COMPONENT_TYPE = "SINGLE_BOTTOM_BUTTON";

    @Override
    public String returnComponentType() {
        return SingleBottomButton.COMPONENT_TYPE;
    }
}
