package com.digiwin.mobile.mobileuibot.core.component.button;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentListBuilder;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotTargetLayoutSearchResult;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import java.util.*;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: SubmitButtonBuilder
 * @Author: Zaregoto
 * @Date: 2021/8/10 15:40
 */
@Component("submitButtonBuilder")
public class SubmitButtonBuilder implements MobileComponentListBuilder<SubmitButton> {
    private static final Logger logger = LoggerFactory.getLogger(SubmitButtonBuilder.class);

    @Override
    public String getMobileComponentType() {
        return SubmitButton.COMPONENT_TYPE;
    }

    @Override
    public List<SubmitButton> build(ApiRequest apiRequest, PageSetting pageSetting,
                                    UiBotModel pcUiBotModel, Class<SubmitButton> clazz, Object... args) {
        Assert.notNull(args, "args must not null!");
        Assert.notEmpty(args, "args must not empty!");

        String locale = apiRequest.getLocale();

        UiBotTargetLayoutSearchResult searchResult = pcUiBotModel.searchPcTargetLayout();
        if (!searchResult.found()) {
            return Collections.emptyList();
        }

        UiBotLayout targetLayout = searchResult.getTargetUiBotLayout();
        String bizDataSchema = pcUiBotModel.searchBizDataSchema();

        if (bizDataSchema.trim().isEmpty()) {
            return Collections.emptyList();
        }

        List<UiBotAction> uiBotActions;
        if (searchResult.getHasCustomData()) {
            uiBotActions = targetLayout.getActions();
        } else {
            uiBotActions = pcUiBotModel.getActions();
        }

        if (null == uiBotActions || uiBotActions.isEmpty()) {
            return Collections.emptyList();
        }

        Object bizData = pcUiBotModel.getPageData().get(bizDataSchema);
        if (bizData == null) {
            return Collections.emptyList();
        }
        if (bizData instanceof List) {
            if (((List<?>) bizData).isEmpty()) {
                return Collections.emptyList();
            }
        }
        if (bizData instanceof Map) {
            if (((Map) bizData).isEmpty()) {
                return Collections.emptyList();
            }
        }

        UiBotLayout subTabChild = (UiBotLayout) args[0];
        boolean selectable = (boolean) Optional.ofNullable(args[1]).orElse(false);
        List<SubmitButton> result = new ArrayList<>();
        for (UiBotAction uiBotAction : uiBotActions) {
            SubmitButton submitButton = new SubmitButton();
            if (null != subTabChild.getMSubmitType()) {
                submitButton.setSubmitType(subTabChild.getMSubmitType());
            }
            if (null != subTabChild.getMSelectAllText()) {
                submitButton.setSelectAllText(
                        LocaleUtil.getMobileTextByDatabaseKey(locale, subTabChild.getMSelectAllText()));
            }
            submitButton.setName(uiBotAction.getTitle());
            if (uiBotAction.getDefaultAction()) {
                submitButton.setType(BottomButtonStyleEnum.STRESS.getValue());
            } else {
                submitButton.setType(BottomButtonStyleEnum.NORMAL.getValue());
            }


            Action<ButtonRawData> action =
                    new Action(ActionTypeEnum.CALL_API.getValue());
            action.setRawData(
                    new ButtonRawData(uiBotAction, pcUiBotModel.getPageData()));

            submitButton.setAction(action);
            submitButton.setSubmitType(selectable ?
                    SubmitButtonTypeEnum.INCLUDE_SELECT_ALL.getType() :
                    SubmitButtonTypeEnum.SELF_ONLY.getType());

            result.add(submitButton);
        }

        return result;
    }
}
