package com.digiwin.mobile.mobileuibot.core.component.card.card;

import com.digiwin.mobile.mobileuibot.api.ApiExtraParameter;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.CommonRawDataParentType;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.common.PcmFilterUtil;
import com.digiwin.mobile.mobileuibot.core.component.*;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParamJsonDeserializer;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldValueStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.button.*;
import com.digiwin.mobile.mobileuibot.core.component.chart.mobilechart.ChartData;
import com.digiwin.mobile.mobileuibot.core.component.input.addersubstracter.AdderSubstracter;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.*;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePickerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.ButtonSingleSelectShowTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.ButtonSingleSelectStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.InputSingleSelectOption;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitchStateEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleItemLabel;
import com.digiwin.mobile.mobileuibot.core.component.navbar.index.IndexNavBar;
import com.digiwin.mobile.mobileuibot.core.component.progressbar.ProgressBarDecimalsEnum;
import com.digiwin.mobile.mobileuibot.core.component.progressbar.ProgressBarTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabItemCardDetailPage;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinTransportResponse;
import com.digiwin.mobile.mobileuibot.proxy.mdc.service.DigiwinMdcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachment;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachmentData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotBaseDataUtil;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.TimeSlot;
import com.digiwin.mobile.mobileuibot.search.SearchItemDetailFixedNameEnum;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.*;
import java.util.stream.Collectors;

import static com.digiwin.mobile.mobileuibot.core.component.button.Button.isOpenNewDetailPage;
import static com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils.localeService;

/**
 * 标准卡片组件
 *
 * @author zhangjj
 * @date 2022/12/12 15:22
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class Card extends BaseCard {
    private static final long serialVersionUID = -2713127920601409204L;
    public static final String COMPONENT_TYPE = "CARD";

    /**
     * 批量提交时，解析的参数结构
     */
    @JsonDeserialize(contentUsing = ActionSubmitParamJsonDeserializer.class)
    private List<ActionSubmitParam> submitParams;

    /**
     * 标题是否显示，true：显示，false：隐藏
     */
    private Boolean titleVisible = false;
    private String title;
    /**
     * 标题颜色，只在style=3生效(标题和内容区块分层颜色)，前端默认给黑色
     * V1的属性(编辑卡，V2有需求的话,后续再补充)
     */
    private String titleColor;
    private Action titleAction;
    private String subTitle;
    private Action subTitleAction;
    /**
     * 副标题颜色，只在style=3生效（标题和内容区块分层颜色)，前端默认给蓝色
     * V1的属性(编辑卡，V2有需求的话,后续再补充)
     */
    private String subTitleColor;
    // 卡片本身点击事件，不会左右划动
    private Action cardAction;

    private InputWindowSingleItemLabel titleLabel;
    private String dataId;
    private AdderSubstracter adderSubstracter;
    private Map<String, Object> detail;
    private Boolean canEdit;
    private Map<String, Object> rawData;
    private List<CardContent> content = new ArrayList<>();
    private List<Button> buttonList = new ArrayList<>(3);
    private List<Tag> tags;
    private TabItemCardDetailPage detailPage;

    /**
     * 序号
     */
    private String seq;

    /**
     * 1.通用样式；2.全部置灰样式, 3: 标题和内容区块分层颜色(通过titleBgColor来指定颜色)
     */
    private Integer style = 1;

    /**
     * 指定
     */
    private String titleBgColor;

    /**
     * 背景颜色
     */
    private String bgColor;

    // 是否禁止卡片上的任何点击事件
    private Boolean disableClick;

    // 当列表为单选或多选时，该条目是否禁止选择
    private Boolean disableSelect;

    /**
     * 卡片label最长显示字数
     */
    private Integer labelMaxLength = 6;

    /**
     * 空状态组件
     */
    private Empty empty;

    /**
     * 内容布局类型
     *
     * @see CardLayoutTypeEnum
     */
    private Integer layoutType = CardLayoutTypeEnum.DEFAULT.getValue();
    private Picture cardPicture;

    /**
     * 0(默认)点击卡片和按钮都能进详情、
     * 1点击整个卡片(除按钮外)进详情 、
     * 2点击按钮进详情(且当卡片上的某个按钮action==null时点击按钮触发)
     */
    private Integer openDetailType = 0;

    /**
     * 用于是否打开卡片详情页，默认false，
     * 如果卡片上无编辑类型的组件的时候为true
     */

    private Boolean openCardDetailPage = false;

    /**
     * 当前卡片是否已结束，只针对录入场景，只读场景不存在此属性  -- V2设计器新增属性
     * (备注：前端默认是true)
     */
    private Boolean isProcessed;

    /**
     * V2版DSL，card组件，buttonList 改造成 buttonGroup组件，方便前端处理
     */
    @JsonDeserialize(contentUsing = BaseMobileComponentWrapperJsonDeserializer.class)
    private List<BaseMobileComponentWrapper<BaseMobileComponent>> cardButtons;
    /**
     * V2版DSL，card组件，title 改造成 titleObj 对象，方便前端处理
     */
    private Obj titleObj;
    /**
     * V2版DSL，card组件，subTitle 改造成 subTitleObj 对象，方便前端处理
     */
    private Obj subTitleObj;

    /**
     * 卡片折叠或者收起，true 为展开，false 为收起。默认收起
     */
    private Boolean defaultFolded = false;

    /**
     * 折叠类型，0全部折叠，1 部分折叠
     */
    private Integer foldedType;

    /**
     * 最大个数显示,默认展示2个
     */
    private Integer maxContentDisplay = 2;

    @Data
    @Accessors(chain = true)
    static class Obj {
        private String schema;
        private String title;
    }

    public static Card create(Card card, LocaleService localeService, String locale, String transportNo,
                              Map<String, Object> transportMainInfo) {
        List<CardContent> content = card.getContent();
        for (CardContent cardContent : content) {
            cardContent.setLabel(localeService.getLanguageValue(locale, cardContent.getLabel()));
            if ("transport_no".equalsIgnoreCase(cardContent.getSchema())) {
                cardContent.setValue(transportNo);
            } else {
                cardContent.setValue(StringUtils.hasLength((String)
                        transportMainInfo.get(cardContent.getSchema())) ? (String)
                        transportMainInfo.get(cardContent.getSchema()) : "-");
            }

        }
        return card;
    }

    /**
     * APC-异常回报客制card
     *
     * @param titleSchema
     * @param schemas
     * @param data
     * @param localeService
     * @param locale
     * @param actions
     * @param datas
     * @param pcUibotModel
     * @return
     */
    public static Card create(String titleSchema, List<ColumnTag> schemas, Map<String, Object> data,
                              LocaleService localeService, String locale, List<UiBotAction> actions,
                              List<Map<String, Object>> datas, UiBotModel pcUibotModel) {
        Card card = new Card();
        card.setDetail(data);
        card.setTitle((String) data.get(titleSchema));
        List<CardContent> content = card.getContent();
        for (ColumnTag tag : schemas) {
            if (data.get(tag.getSchema()) instanceof Map) {
                Map<String, Object> files = (Map<String, Object>) data.get(tag.getSchema());
                if (files.get("row_data") instanceof Map) {
                    files.put("row_data", JsonUtil.javaObjectToJsonString(files.get("row_data")));
                }
                UiBotAttachment attachment = JsonUtil.objectToJavaObject(files, UiBotAttachment.class);
                if (attachment != null && !CollectionUtils.isEmpty(attachment.getData())) {
                    content.add(new CardContent(localeService.getLanguageValue(locale, tag.getLabel()), Attachment.uibotAttachmentparseAttachment(attachment, locale, localeService.getLanguageValue(locale, tag.getLabel()))));
                } else {
                    content.add(new CardContent(localeService.getLanguageValue(locale, tag.getLabel()), "-"));
                }

            } else {
                String value = (String) data.get(tag.getSchema());
                if (!StringUtils.hasLength(value)) {
                    value = "-";
                }
                content.add(new CardContent(localeService.getLanguageValue(locale, tag.getLabel()), value, 1));
            }
        }
        UiBotLayout layout = UiBotModel.getContentQueryButtonLayout(pcUibotModel.getLayout());
        UiBotExecuteContext executeContext = pcUibotModel.getExecuteContext();
        Map<String, Object> businessUnit = (Map<String, Object>) executeContext.get("businessUnit");
        Map<String, Object> commonRawDataMap = new HashMap<>();
        commonRawDataMap.put("businessUnit", businessUnit);
        commonRawDataMap.put("executeContext", executeContext);

        //这块参数目前和web端前端开发人员确定是写死的，故移动端这边参数也是写死。这是获取异常原因的第一个api需要的参数
        Map<String, Object> queryActionParameter = new HashMap<>();
        Map<String, Object> tmAction = new HashMap<>();
        String serviceName = "bm.opsc.abnormal.reason.info.get";
        tmAction.put("actionId", "esp_" + serviceName);
        tmAction.put("title", LocaleUtil.getMobileTextByKey(locale, "取得异常资讯"));
        tmAction.put("actionParams", new ArrayList<>());
        Map<String, Object> paras = new HashMap<>();
        List<Map<String, Object>> abnormalReasonInfoList = new ArrayList<>();
        abnormalReasonInfoList.add(businessUnit);
        paras.put("abnormal_reason_info", abnormalReasonInfoList);
        tmAction.put("paras", paras);
        Map<String, Object> language = new HashMap<>();
        Map<String, Object> title = new HashMap<>();
        title.put("en_US", "recommend");
        title.put("zh_TW", "推薦");
        language.put("title", title);
        tmAction.put("language", language);
        tmAction.put("type", "ESP");
        tmAction.put("actionResponse", null);
        tmAction.put("serviceName", serviceName);
        tmAction.put("needProxyToken", null);
        tmAction.put("attachActions", null);
        tmAction.put("flatData", null);
        queryActionParameter.put("tmAction", tmAction);
        queryActionParameter.put("useHasNext", true);
        Map<String, Object> pageInfo = new HashMap<>();
        pageInfo.put("hasNext", true);
        pageInfo.put("pageNo", 1);
        pageInfo.put("pageSize", 20);
        queryActionParameter.put("pageInfo", pageInfo);
        queryActionParameter.put("executeContext", executeContext);

        Map<String, Object> rawData = new HashMap<>(2);
        rawData.put("executeContext", pcUibotModel.getExecuteContext());
        rawData.put("dataSourceSet", layout.getQueryButtons().get(0).getDataSourceSet());
        rawData.put("paras", data);
        rawData.put("dataKey", data.get("__DATA_KEY"));
        rawData.put("datas", datas);
        if (ObjectUtils.isNotEmpty(actions)) {
            rawData.put("action", actions.stream().filter(action1 -> action1.getDefaultAction()).findFirst().orElse(null));
            rawData.put("replyAction", actions.stream().filter(action1 -> !action1.getDefaultAction()).findFirst().orElse(null));
        }
        rawData.put("queryActionParameter", queryActionParameter);
        List<Button> buttonList = card.getButtonList();
        buttonList.add(Button.createApcApprovalReassign(UUIDUtil.getUuid(), rawData, locale, BottomButtonStyleEnum.NORMAL.getValue()));
        buttonList.add(Button.createApcHandel(UUIDUtil.getUuid(), rawData, locale, BottomButtonStyleEnum.NORMAL.getValue(), localeService));
        return card;
    }

    public static Card createApcDetail(String titleSchema, List<ColumnTag> completeSchemas, Map<String, Object> completeData, LocaleService localeService, String locale) {

        Card card = new Card();
        card.setDetail(completeData);
        card.setTitle((String) completeData.get(titleSchema));
        List<CardContent> contents = card.getContent();
        for (ColumnTag tag : completeSchemas) {
            String type = tag.getType();
            if (Field.COMPONENT_TYPE.equals(type)) {
                contents.add(new CardContent(localeService.getLanguageValue(locale, tag.getLabel()),
                        ModuleUtils.emptyValueToHyphen(completeData.get(tag.getSchema()))));
            } else if (Attachment.COMPONENT_TYPE.equals(type)) {
                UiBotAttachment attachment = JsonUtil.objectToJavaObject(completeData.get(tag.getSchema()), UiBotAttachment.class);
                if (attachment != null && !CollectionUtils.isEmpty(attachment.getData())) {
                    contents.add(new CardContent(localeService.getLanguageValue(locale, tag.getLabel()),
                            Attachment.uibotAttachmentparseAttachment(attachment, locale, localeService.getLanguageValue(locale, tag.getLabel()))));

                } else {
                    contents.add(new CardContent(localeService.getLanguageValue(locale, tag.getLabel()),
                            "-"));
                }
            }
        }
        return card;

    }


    public static Card createApcWorkShopOnlineCard(List<CustomTabContentContainer> tabContents,
                                                   Map<String, Object> data, String locale,
                                                   LocaleService localeService, Button button,
                                                   String subTitle, Action subTitleAction,
                                                   InputWindowSingleItemLabel label, Integer style) {
        Card card = new Card();
        card.setSubTitle(subTitle);
        card.setSubTitleAction(subTitleAction);
        card.setTitleLabel(label);
        card.setStyle(style);
        List<CardContent> cardContent = card.getContent();
        for (CustomTabContentContainer content : tabContents) {
            CardContent childContent = new CardContent();
            childContent.setValueStyleType(1);
            if (Field.COMPONENT_TYPE.equalsIgnoreCase(content.getContentCmptType())) {
                Field field = JsonUtil.objectToJavaObject(content.getData(), Field.class);
                if (!field.getLabelVisible()) {
                    String title = card.getTitle();
                    if (!StringUtils.hasLength(title)) {
                        title = (String) data.get(field.getSchema());
                    } else {
                        title = title + " " + data.get(field.getSchema());
                    }
                    card.setTitle(title);
                } else {
                    childContent.setLabel(localeService.getLanguageValue(locale, field.getLabel()));
                    if (((String) data.get(field.getSchema())).contains("1900") || ((String) data.get(field.getSchema())).contains("9998")) {
                        childContent.setValue("-");
                    } else {
                        childContent.setValue((String) data.get(field.getSchema()));
                    }
                    childContent.setSchema(field.getSchema());
                    cardContent.add(childContent);
                }
            }
        }
        List<Button> buttonList = card.getButtonList();
        if (!button.isEmpty() && style != 2) {
            buttonList.add(button);
        }
        return card;
    }

    /**
     * 爱德领料通知任务card
     *
     * @param title
     * @param data
     * @return
     */
    public static Card create(String title, Map<String, Object> data) {
        Card card = new Card();
        card.setTitle(title);
        List<CardContent> contentList = new LinkedList<>();
        for (Map.Entry<String, Object> item : data.entrySet()) {
            contentList.add(new CardContent(item.getKey(), String.valueOf(item.getValue())));
        }
        card.setContent(contentList);
        return card;
    }

    /**
     * 爱德委外报工任务card
     *
     * @param title
     * @param data
     * @return
     */
    public static Card create(String title, Map<String, Object> data, List<Button> buttonList, boolean disableClick) {
        Card card = new Card();
        card.setTitle(title);
        List<CardContent> contentList = new LinkedList<>();
        for (Map.Entry<String, Object> item : data.entrySet()) {
            contentList.add(new CardContent(item.getKey(), Objects.isNull(item.getValue()) ? "-" : String.valueOf(item.getValue())));
        }
        card.setContent(contentList);
        card.setDisableClick(disableClick);
        if (!CollectionUtils.isEmpty(buttonList)) {
            card.setButtonList(buttonList);
        }
        return card;
    }

    /**
     * 对账小管家card
     *
     * @param title
     * @param contentList
     * @return
     */
    public static Card create(String title, List<CardContent> contentList, List<Tag> tagList, TabItemCardDetailPage detailPage) {
        Card card = new Card();
        card.setTitle(title);
        card.setContent(contentList);
        card.setDetailPage(detailPage);
        if (!CollectionUtils.isEmpty(tagList)) {
            card.setTags(tagList);
        }
        return card;
    }

    /**
     * 对账小管家详情card
     *
     * @param title
     * @param subTitle
     * @param contentList
     * @param buttonList
     * @return
     */
    public static Card create(String title, String subTitle, List<CardContent> contentList, List<Button> buttonList, String bgColor) {
        Card card = new Card();
        card.setTitle(title);
        card.setSubTitle(subTitle);
        card.setContent(contentList);
        if (!CollectionUtils.isEmpty(buttonList)) {
            card.setButtonList(buttonList);
        }
        if (StringUtils.hasLength(bgColor)) {
            card.setBgColor(bgColor);
        }
        return card;
    }

    /**
     * 班组派工详情card
     *
     * @param title
     * @param subTitle
     * @param contentList
     * @param buttonList
     * @param subTitleAction
     * @param label
     * @param detailPage
     * @param style
     * @return
     */
    public static Card create(String title, String subTitle, List<CardContent> contentList, List<Button> buttonList, Action subTitleAction,
                              InputWindowSingleItemLabel label, TabItemCardDetailPage detailPage, Integer style, Integer openDetailType) {
        Card card = new Card();
        card.setSubTitle(subTitle);
        card.setSubTitleAction(subTitleAction);
        card.setTitleLabel(label);
        card.setStyle(style);
        card.setTitle(title);
        card.setContent(contentList);
        if (!CollectionUtils.isEmpty(buttonList)) {
            card.setButtonList(buttonList);
        }
        card.setDetailPage(detailPage);
        card.setOpenDetailType(openDetailType);
        return card;
    }

    /**
     * 合并工时任务card
     *
     * @param title
     * @param data
     * @return
     */
    public static Card create(String title, Map<String, Object> data, List<Button> buttonList, boolean disableClick, String changeSchemaName) {
        Card card = new Card();
        card.setTitle(title);
        List<CardContent> contentList = new LinkedList<>();
        for (Map.Entry<String, Object> item : data.entrySet()) {
            CardContent cardContent = new CardContent(item.getKey(), Objects.isNull(item.getValue()) ? "-" : String.valueOf(item.getValue()));
            if (StringUtils.hasLength(changeSchemaName) && changeSchemaName.equals(item.getKey())) {
                cardContent.setIsChangeValue(true);
            }
            contentList.add(cardContent);
        }
        card.setContent(contentList);
        card.setDisableClick(disableClick);
        if (!CollectionUtils.isEmpty(buttonList)) {
            card.setButtonList(buttonList);
        }
        return card;
    }

    /**
     * 试研北斗，下钻页面无数据显示使用
     *
     * @param card
     * @param locale
     * @param localeService
     * @return
     */
    public static Card createCardEmpty(Card card, String locale, LocaleService localeService) {
        card.setTitle(localeService.getLanguageValue(locale, card.getTitle()));
        card.setEmpty(Empty.create(localeService.getLanguageValue(locale, "暂无数据")
                , true, null, 150, 80, 74, "#999999", "IMAGE_EMPTY_WIDGET"));
        card.setContent(null);
        return card;
    }

    public static Card create(Card card, Map<String, Object> opData, String locale,
                              LocaleService localeService, Boolean hasBind) {
        card.setTitle(localeService.getLanguageValue(locale, card.getTitle()));
        List<CardContent> cardContents = card.getContent();
        List<CardContent> newCardContents = new ArrayList<>(cardContents.size());
        for (CardContent content : cardContents) {
            if (!hasBind && "is_bind_pre_process".equals(content.getSchema())) {
                continue;
            }
            if ("resource_data".equals(content.getSchema())) {
                // resource_base 0:工艺信息，1：报工信息
                List<Map<String, Object>> files = (List<Map<String, Object>>) opData.get(content.getSchema());
                files = files.stream().filter(e -> "0".equals(e.get("resource_base"))).collect(Collectors.toList());
                content.setLabel(localeService.getLanguageValue(locale, content.getLabel()));
                content.setFile(Attachment.createTbdsFiles(files, LocaleUtil.getMobileTextByKey(locale, SearchItemDetailFixedNameEnum.SEARCH_ITEM_DETAIL_ATTACHMENT.getValue())));
            } else {
                content.setLabel(localeService.getLanguageValue(locale, content.getLabel()));
                content.setValue(ModuleUtils.dealValue(opData.get(content.getSchema()), locale, localeService));
                content.setValueStyleType(FieldValueStyleTypeEnum.VALUE_BLACK.getValue());
            }
            newCardContents.add(content);
        }
        card.setContent(newCardContents);
        return card;
    }

    public static Card create(Card card, List<Map<String, Object>> parameterDatas,
                              String locale, LocaleService localeService, Action action) {
        card.setTitle(localeService.getLanguageValue(locale, card.getTitle()));
        List<CardContent> cardContents = new ArrayList<>();
        if (!CollectionUtils.isEmpty(parameterDatas)) {
            CardContent cardContent = card.getContent().get(0);
            for (Map<String, Object> pData : parameterDatas) {
                CardContent newCardContent = new CardContent();
                newCardContent.setSchema((String) pData.get("parameter_no"));
                newCardContent.setLabel((String) pData.get(cardContent.getLabel()));
                newCardContent.setValue(ModuleUtils.emptyValueToHyphen(pData.get(cardContent.getSchema())));
                cardContents.add(newCardContent);
            }
            if (action != null && action.getJumpPageId() != null) {
                Map<String, Object> rawData = new HashMap<>(1);
                rawData.put("data", parameterDatas);
                card.getButtonList().add(BottomButtonDigiwinAthena.createEditButton(localeService.getLanguageValue(locale, "编辑"), action));
            }
        }
        card.setContent(cardContents);
        return card;
    }


    @Override
    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    /**
     * 处理在途宝的数据
     *
     * @param message
     * @param card
     * @param localeService
     * @param locale
     * @return
     */
    public Card detailMessage(Map<String, Object> message, Card card,
                              LocaleService localeService, String locale) {

        for (CardContent content : card.getContent()) {
            if ("time_slot".equalsIgnoreCase(content.getSchema())) {
                DigiwinTransportResponse digiwinTransportResponse = new DigiwinTransportResponse();
                content.setValue(digiwinTransportResponse.getTimeSlots(ModuleUtils.listMapToListObject((List) message.get(content.getSchema()), TimeSlot.class)));
            } else if ("driver_mobile".equalsIgnoreCase(content.getSchema())) {
                if (!StringUtils.hasLength((String) message.get(content.getSchema()))) {
                    content.setType("");
                }
                content.setValue(getValue((String) message.get(content.getSchema())));
            } else if ("plan_unload_time".equals(content.getSchema())) {
                String value = getValue((String) message.get(content.getSchema()));
                String hours = localeService.getLanguageValue(locale, "小时");
                if (value.contains(hours)) {
                    content.setValue(value);
                } else {
                    content.setValue(value + hours);
                }

            } else {
                content.setValue(getValue((String) message.get(content.getSchema())));
            }

            content.setLabel(localeService.getLanguageValue(locale, content.getLabel()));
        }
        card.setTitle(localeService.getLanguageValue(locale, card.getTitle()));
        return card;
    }

    private String getValue(String value) {
        if (StringUtils.hasLength(value)) {
            return value;
        } else {
            return "-";
        }
    }

    public Card detailPlatformMessage(Map<String, Object> transportMainInfoResponseMap, Card card,
                                      LocaleService localeService, String locale) {
        DigiwinTransportResponse transportMainInfo = JsonUtil.objectToJavaObject(transportMainInfoResponseMap, DigiwinTransportResponse.class);
        for (CardContent content : card.getContent()) {
            String value;
            if ("appoint_time".equalsIgnoreCase(content.getSchema())) {
                String date = StringUtils.hasLength(transportMainInfo.getAppointmentDeliveryDate()) ? transportMainInfo.getAppointmentDeliveryDate() : "-";
                String[] values = date.split(" ");
                if (values.length > 1) {
                    value = values[0];
                } else {
                    value = date;
                }
            } else if ("time_slot".equalsIgnoreCase(content.getSchema())) {
                value = transportMainInfo.getTimeSlots(transportMainInfo.getTimeSlot());
            } else if ("plan_unload_time".equals(content.getSchema())) {
                value = getValue((String) transportMainInfoResponseMap.get(content.getSchema()));
                String hours = localeService.getLanguageValue(locale, "小时");
                if (!value.contains(hours)) {
                    value = value + hours;
                }

            } else {
                value = (String) transportMainInfoResponseMap.get(content.getSchema());
            }
            content.setValue(getValue(value));
            content.setLabel(localeService.getLanguageValue(locale, content.getLabel()));
            content.setValueStyleType(1);
        }
        return card;
    }


    /**
     * 工时回报/工时支援任务-未上线 Tab卡片创建
     *
     * @param apiRequest
     * @param pcUiBotModel
     * @param mainDataInfo
     * @param detailDataList
     * @param hasButton
     * @param leftTitleFields
     * @param rightTitleField
     * @param contentFields
     * @param contentFieldCreateLimit
     * @param valueToTextMap
     * @param isCheckIn
     * @return
     */
    public static Card create(ApiRequest apiRequest, UiBotModel pcUiBotModel, Map<String, Object> mainDataInfo, List<Map<String, Object>> detailDataList,
                              boolean hasButton, String[] leftTitleFields, String rightTitleField, String[] contentFields, int contentFieldCreateLimit,
                              Map<String, String> valueToTextMap, Boolean isCheckIn, CustomTabContentContainer customTabContentContainer,
                              LocaleService localeService, Map<String, Object> variableListSimpleMap) {
        String locale = apiRequest.getLocale();
        String dataId = apiRequest.getDataId();
        boolean isTeamTask = apiRequest.getRawData().getBooleanValue("isTeamTask");

        int contentFieldCreatedCount = 0;
        Card card = new Card();
        ApiExtraParameter newApiExtraParameter = new ApiExtraParameter();
        newApiExtraParameter.setForItemDetail(true);
        ApiRawData newApiRawData = new ApiRawData();
        newApiRawData.put("taskInfo", mainDataInfo);
        // 如果是团队任务，则任务需只读，不能可给用户操作的按钮
        newApiRawData.put("isTeamTask", isTeamTask);
        newApiRawData.put("pcUiBotModel", pcUiBotModel);
        // 原来传递参数的逻辑与界面是否有按钮有关，但在迭代25中的团队任务中，要求所有任务都没有操作按钮，但其他逻辑要和原来一样，
        // 这就会导致原来判断逻辑中会缺少是否有按钮的维度，无法与原来逻辑相同了。
        // 故参考传入hasButton的地方，通过判断是否有子制程来决定
//        if (hasButton && detailDataList.size() == 1) {
        if (detailDataList.size() == 1) {
            Map<String, Object> detailData = detailDataList.get(0);
            // 子制程参数
            String subOpSeq = String.valueOf(detailData.getOrDefault("sub_op_seq", ""));
            String subOpName = String.valueOf(detailData.getOrDefault("sub_op_name", ""));
            if (!StringUtils.hasLength(subOpSeq) && !StringUtils.hasLength(subOpName)) {
                newApiRawData.put("wo_op_report_data", Collections.emptyList());
            } else {
                newApiRawData.put("wo_op_report_data", detailDataList);
            }
        } else {
            newApiRawData.put("wo_op_report_data", detailDataList);
        }
        List<String> leftTitle = new ArrayList<>();
        List<String> rightTitle = new ArrayList<>();
        // 标题字段
        for (String leftTitleField : leftTitleFields) {
            String value = String.valueOf(mainDataInfo.getOrDefault(leftTitleField, ""));
            if (value.trim().isEmpty()) {
                // 只读的话，空值，移动不显示，故不处理
                continue;
            }
            value = valueToTextMap.getOrDefault(leftTitleField + "_" + value, value);
            leftTitle.add(LocaleUtil.getMobileTextByKey(locale, value));
        }
        if (mainDataInfo.containsKey(rightTitleField)) {
            String value = String.valueOf(mainDataInfo.getOrDefault(rightTitleField, ""));
            if (!value.trim().isEmpty()) {
                value = valueToTextMap.getOrDefault(rightTitleField + "_" + value, value);
                rightTitle.add(LocaleUtil.getMobileTextByKey(locale, value));
            }
        }
//        //概要字段
//        for (String contentField : contentFields) {
//            if (!isCheckIn && ("wo_no".equalsIgnoreCase(contentField)
//                    || "item_no".equalsIgnoreCase(contentField) || "item_name".equalsIgnoreCase(contentField))) {
//                String value = String.valueOf(mainDataInfo.getOrDefault(contentField, ""));
//                if (value.trim().isEmpty()) {
//                    // 只读的话，空值，移动不显示，故不处理
//                    continue;
//                }
//                value = valueToTextMap.getOrDefault(contentField + "_" + value, value);
//                String labelStr = valueToTextMap.getOrDefault(contentField, contentField);
//
//                CardContent cardContent = CardContent.create(LocaleUtil.getMobileTextByKey(locale, labelStr), 1, value);
//                card.getContent().add(cardContent);
//                contentFieldCreatedCount++;
//                if (contentFieldCreatedCount == contentFieldCreateLimit) {
//                    break;
//                }
//            }
//        }
        //概要字段-新增报工字段-因为已上线和未上线共用一个常量数组，为避免影响所以直接在这边定制
        String value = "";
        Double reportqty = 0.0;
        if (mainDataInfo.getOrDefault("report_qty", "") != null) {
            if (mainDataInfo.getOrDefault("report_qty", "") instanceof Double) {
                reportqty = (Double) mainDataInfo.getOrDefault("report_qty", "");
            } else {
                reportqty = ((Integer) mainDataInfo.getOrDefault("report_qty", "")).doubleValue();
            }
            DecimalFormat df = new DecimalFormat("0.######");
            value = df.format(reportqty);
        }
        if (value.trim().isEmpty()) {
            value = "-";
        }
        CardContent cardContent = CardContent.create(localeService.getLanguageValue(locale, "报工数量"), 1, value);
        card.getContent().add(cardContent);

        //封装按钮需要的
        UiBotExecuteContext executeContext = pcUiBotModel.getExecuteContext();
        Map<String, Object> businessUnit = (Map<String, Object>) executeContext.get("businessUnit");

        Map<String, Object> commonRawDataMap = new HashMap<>();
        commonRawDataMap.put("businessUnit", businessUnit);
        commonRawDataMap.put("executeContext", executeContext);

        Map<String, Object> woOpReportData = new HashMap<>();
        woOpReportData.putAll(mainDataInfo);
        woOpReportData.putAll(businessUnit);
        if (hasButton) {
            List<Button> buttonList = new ArrayList<>();
            // 附件历程和上传附件按钮,目前工时回报加，工时支援不用加
            if (PageSettingIdPresetEnum.MOBILE_ATHENA_APC_WORKING_HOUR_REPORT_LIST.name().equalsIgnoreCase(apiRequest.getPageId())) {
                // 异常回报允许上传附件开关打开，才展示附件历程和上传附件两个按钮
                BottomButtonDigiwinAthena attachmentButton = BottomButtonDigiwinAthena.buildAttachmentButtons(woOpReportData, variableListSimpleMap, locale);
                if (Objects.nonNull(attachmentButton)) {
                    buttonList.add(attachmentButton);
                }
            }

            //未上线需要显示:人员上线按钮
            Map<String, Object> onlineRawData = new HashMap<>();
            Map<String, Object> onlineParameter = new HashMap<>();
            List<Map<String, Object>> woOpReportDataList = new ArrayList<>();
            woOpReportDataList.add(woOpReportData);
            onlineParameter.put("wo_op_report_data", woOpReportDataList);
            onlineRawData.put("parameter", onlineParameter);
            onlineRawData.putAll(commonRawDataMap);

            // 备注上线按钮
            List<BottomButtonDigiwinAthena> remarkDetailBottomButtonList = new ArrayList<>();
            remarkDetailBottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton(locale));

            BottomButtonDigiwinAthena submitButton = new BottomButtonDigiwinAthena();
            submitButton.setName(LocaleUtil.getMobileTextByKey(locale, "提交"));
            submitButton.setType(BottomButtonStyleEnum.STRESS.getValue());

            Map<String, Object> submitButtonActionrawData = new HashMap<>();
            submitButtonActionrawData.putAll(onlineRawData);
            submitButtonActionrawData.put("actionId", "wo.op.report.check.in.info.process");
            submitButtonActionrawData.put("pageId", PageSettingIdPresetEnum.MOBILE_ATHENA_APC_REMARK_DETAIL_CONFIRM.toString());
            // 保存上一页的pageId,为了备注提交按钮页面知道是工时支援还是工时回报页面
            submitButtonActionrawData.put("previousPageId", apiRequest.getPageId());

            Action submitButtonAction = new Action();
            submitButtonAction.setType(ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue());
            submitButtonAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/workingHourReport/peopleOnline");
            submitButtonAction.setRawData(submitButtonActionrawData);

            submitButton.setAction(submitButtonAction);
            remarkDetailBottomButtonList.add(submitButton);

            Action remarkOnlineAction = new Action();
            remarkOnlineAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_REMARK_DETAIL_CONFIRM.toString());
            remarkOnlineAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());

            Map<String, Object> rawData = new HashMap<>();
            rawData.put("data", mainDataInfo);
            rawData.put("buttonList", remarkDetailBottomButtonList);

            remarkOnlineAction.setRawData(rawData);

            Button remarkOnlineButton = Button.createButton(localeService.getLanguageValue(locale, "备注上线"), BottomButtonStyleEnum.NORMAL.getValue(), remarkOnlineAction);
            buttonList.add(remarkOnlineButton);

            // 人员上线按钮
            BottomButtonDigiwinAthena onlineButton = BottomButtonDigiwinAthena.createOnlineButton(apiRequest.getPageId(), locale, onlineRawData, ActionTypeEnum.CALL_API_SHOW_SUCCESS_MSG_REFRESH_CURRENT_PAGE.getValue());
            ModuleUtils.addRefreshPageId(onlineButton, apiRequest.getRefreshPageId());
            buttonList.add(onlineButton);
            card.setButtonList(buttonList);
        } else {
            customTabContentContainer.setDetailPage(TabItemCardDetailPage.create(locale,
                    dataId,
                    newApiExtraParameter,
                    PageSettingIdPresetEnum.MOBILE_ATHENA_APC_WORKING_HOUR_REPORT_DETAIL.toString(), apiRequest.getPageId(), newApiRawData));

            // 附件历程和上传附件按钮,目前工时回报加，工时支援不用加
            if (PageSettingIdPresetEnum.MOBILE_ATHENA_APC_WORKING_HOUR_REPORT_LIST.name().equalsIgnoreCase(apiRequest.getPageId())) {
                // 异常回报允许上传附件开关打开，才展示附件历程和上传附件两个按钮
                Boolean abnormalAllowsUploadingAttachments = Optional.ofNullable(variableListSimpleMap).map(map -> MapUtils.getBoolean(map, "abnormalAllowsUploadingAttachments")).orElse(false);
                if (BooleanUtils.isTrue(abnormalAllowsUploadingAttachments)) {
                    List<Button> buttonList = new ArrayList<>();
                    Map<String, Object> woOpReportHasSubData = JsonUtil.objectToJavaObject(woOpReportData, Map.class);
                    woOpReportHasSubData.remove("sub_op_seq");
                    woOpReportHasSubData.remove("sub_op_no");
                    buttonList.add(BottomButtonDigiwinAthena.createApcAttachmentDetailButton(woOpReportHasSubData, locale, localeService));
                    buttonList.add(BottomButtonDigiwinAthena.createApcAttachmentUploadButton(woOpReportHasSubData, "2", locale, localeService));
                    card.setButtonList(buttonList);
                }
            }
        }
        if (!CollectionUtils.isEmpty(leftTitle)) {
            card.setTitle(leftTitle.get(0));
        }

        if (!CollectionUtils.isEmpty(rightTitle)) {
            card.setSubTitle(rightTitle.get(0));
        }
        //当web端attachment参数存在时，则生成图示需要的组件信息。
        if (null != mainDataInfo.get("attachment")) {
            card.setCardPicture(Picture.create((Map<String, Object>) mainDataInfo.get("attachment"), locale, apiRequest));
        }
        return card;
    }


    /**
     * 工时回报/工时支援/进度回报单头
     *
     * @param apiRequest
     * @param pcUiBotModel
     * @param card
     * @return
     */
    public static void handle(ApiRequest apiRequest, UiBotModel pcUiBotModel, Card card) {
        List<CardContent> contents = card.getContent();
        String bizDataSchema = StringUtils.hasLength(pcUiBotModel.searchBizDataSchema()) ? pcUiBotModel.searchBizDataSchema() : "wo_op_report_data";
        List<Map<String, Object>> woOpReportDataList = (List<Map<String, Object>>) MapUtil.getOrDefault(pcUiBotModel.getPageData(), bizDataSchema, Collections.emptyList());
        LocaleService localeService = SpringContextHolder.getBean(LocaleService.class);
        DigiwinMdcProxyService digiwinMdcProxyService = SpringContextHolder.getBean(DigiwinMdcProxyService.class);
        boolean isProductGatewayE10orT100 = digiwinMdcProxyService.isProductGatewayE10orT100(apiRequest.getIamUserToken(), apiRequest.getTenantId());

        Map<String, Object> woOpReportData = CollectionUtils.isEmpty(woOpReportDataList) ? new HashMap<>() : woOpReportDataList.get(0);
        Iterator<CardContent> iterator = contents.iterator();
        while (iterator.hasNext()) {
            CardContent content = iterator.next();
            // 产品线为E10或T100才展示特征码
            if ("item_feature_no".equalsIgnoreCase(content.getSchema()) || "item_feature_spec".equalsIgnoreCase(content.getSchema())) {
                if (!isProductGatewayE10orT100) {
                    iterator.remove();
                    continue;
                }
            }
            content.setLabel(localeService.getLanguageValue(apiRequest.getLocale(), content.getLabel()));
            content.setValue(String.valueOf(MapUtil.getOrDefault(woOpReportData, content.getSchema(), org.apache.commons.lang3.StringUtils.EMPTY)));
        }
    }

    public List<BaseMobileComponentWrapper<BaseMobileComponent>> getCardButtons() {
        if (this.cardButtons == null) {
            this.cardButtons = buildCardButton(this.data);
        }
        return cardButtons;
    }

    /**
     * 公共参数（需要把该参数里面的数据塞到对应的rawData里面） --- 后期优化独立card时会使用此属性
     * ---- 注意：需要考虑独立卡片还是CardList下卡片。因CardList下也有对应的公共参数
     * 1、存储卡片的detailPage中RawData公共部分
     * 2、存储卡片的跳转类按钮中RawData公共部分
     */
    private Map<String, Object> commonChildRawData;

    /**
     * 当前card组件内数据对应的全路径 -- V2版设计器新增属性
     * 提交card组件时使用，用于查询到具体的节点 -- 前端构建card组件提交参数ActionSubmitParam时，mobilePath取得是此值
     */
    protected String mobilePath;
    /**
     * 设计态设计的card 结构
     */
    private DesignerRawCard data;

    @Data
    public static class DesignerRawCard {
        /**
         * 多数据源配置
         */
        private DataSource dataSource;
        // 节点：值为对应的 数据源key
        private String node;
        // 节点路径：如：task_info
        private String nodePath;
        // 值为对应的 数据源key
        private String title;
        // 如：task_info.light_id
        private String titlePath;
        // 标题，多字段拼接
        private List<Content> titles;
        // 值为对应的 数据源key
        private String subTitle;
        // 如：task_info.second_green
        private String subTitlePath;
        // 子标题按钮
        private UiBotAction subTitleButton;
        // 页面点击配置--对接按钮的配置
        private DetailPage detailPage;
        // 页面点击配置--对接页面的配置(临时存储)
        private DetailPage cardAction;
        // 组件内容
        private List<Content> content;
        // 按钮组
        private List<UiBotAction> buttonList;
        // 卡片的主键配置
        private List<Content> cardKey;
        // 标题配置--属性只有type、setting
        private Content titleSetting;
        // 子标题配置--属性只有type、setting
        private Content subTitleSetting;
        // wjw FIXME: 2023/10/30 设计器暂不需要配置此属性
        private Integer openDetailType = 0;
        // 是否自定义标题 true:自定义--title值就是自定义的名称值；false或null：选择字段--title值为对应的数据源key
        private Boolean isCustomTitle = false;
        private Boolean isCustomSubTitle = false;
        //设计器映射字段，为了控制 isProcessed字段值
        private List<CardProcessedCondition> processedConditionList;
        //序号配置
        private SeqConfig seqConfig;
        // 1.通用样式；2.全部置灰样式, 3: 标题和内容区块分层颜色(通过titleBgColor来指定颜色)
        private Integer style = 1;
        private String titleBgColor = "DAE1FF";

        // 卡片布局类型
        private Integer layoutType = CardLayoutTypeEnum.DEFAULT.getValue();

        //卡片折叠或者收起，true 为展开，false 为收起。默认收起
        private Boolean defaultFolded = false;

        //折叠类型 0为全部折叠，1为部分折叠
        private Integer foldedType;

        //最大个数显示,默认展示2个
        private Integer maxContentDisplay = 2;

        @Data
        public static
        class SeqConfig {
            /**
             * true：默认排序; false：获取seqName对应值
             */
            private Boolean isDefaultSeq = true;

            /**
             * 1：显示普通序号 2：前三张卡高亮（排名）
             */
            private Integer seqStyleType = 1;

            /**
             * 序号名称对应schema
             */
            private String seqName;

            /**
             * 序号路径
             */
            private String seqNamePath;
        }

        // 是否显示表格
        private Boolean showTable = false;
        // table配置
        private TableConfig tableConfig;

        @Data
        public static
        class DetailPage {
            private Integer type = ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue();
            // 是否可滑动查看其他页面详情,默认false，由type=20取代
            private Boolean detailPageSwiper = false;
            private String pageId;
            private Map<String, Object> rawData;
            /**
             * 设计器设计的扩展字段 结构
             */
            private List<Map<String, String>> designExtendParameter;
        }

        @Data
        public static
        class TableConfig {
            private String name;
            // 冻结至某列，默认为0，不冻结
            private Integer columnFreeze = 0;
            // 是否固定表头
            private Boolean tableFixed = false;
            // 表头内容
            private List<Content> content;
            // 默认横屏
            private Boolean defaultLandscape;
            // 是否支持横竖屏
            private Boolean isLandscape;
            // 是否显示序号，默认不显示
            private Boolean rowIndex = false;
        }

        @Data
        public static
        class Content {
            private String schema;
            // string：字符串类型；numeric：数值类型
            private String data_type;
            private String label;
            // 多语言
//            private Map<String, String> description;
            // 如：task_info.second_red
            private String fullPath;
            private String is_array;
            private String visible;
            /**
             * { name: '电话号码', type: 'DW_MOBILE_TEL'},
             * {  name: '文本', type: 'LABEL'},
             * { name: '枚举', type: 'ENUM'},
             * { name: '图片拍照', type: 'DW_PICTURE'},
             * { name: '附件上传', type: 'FILE_UPLOAD'},
             * { name: '数值', type: 'NUMERICAL'},
             * { name: '标签', type: 'TAG'},
             * { name: '日期', type: 'DW_INPUT_DATETIME_PICKER'},
             * { name: '文本开窗', type: 'OPENWINDOW'},
             * { name: '文本域', type: 'DW_INPUT_MULTI'},
             * { name: '开关', type: 'DW_INPUT_SWITCH'},
             * { name: '按钮单选', type: 'DW_BUTTON_SINGLE_SELECT'}
             * { name: '缩略图', type: 'DW_SHOW_PICTURE'}
             */
            private String type;
            // 内容唯一标识---作用于配置高级属性
            private String componentId;
            // 不同type下，对应不同结构
            private Object setting;
            // 子内容多字段拼接或转换table是否复合列
            private List<Content> subContent;
            // 是否换行，配合subContent使用
            private Boolean isLineFeed = false;

            // 列是否支持排序 --- 针对表格
            private Boolean canSort = false;
            // 列是否支持筛选 --- 针对表格
            private Boolean canFilter = false;
            // 列栏位宽度
            private Integer width;

            // 是否自定义标题 true:自定义--label值就是自定义的名称值；false或null：选择字段
            private Boolean isCustom = false;

            // 是否可编辑
            private Boolean editable;

            @Data
            public static
            class SingleTextObj {
                private String placeholder;
                // 单位
                private String unit;
            }

            @Data
            public static
            class AdderSubstracterObj {
                //步长
                private Double stepValue = new Double(1);
                private Double maxNumber;
                private String maxHint;
                private Double minNumber;
                private String minHint;
                private Boolean useManualInput = false;
                private Boolean containsZero = false;
            }

            @Data
            public static
            class EnumObj {
                private List<Option> options;

                @Data
                public static
                class Option {
                    private String id;
                    //选项内容
                    private String text;
                    // 处理历程组件使用
                    private String borderColor;
                    private String color;
                }
            }

            @Data
            public static
            class NumericalObj {
                private String placeholder;
                // 保留小数点位数
                private Integer decimalPoint;
                // 单位
                private String unit;
                //是否展示千分位,展示为true，不展示为fasle
                private Boolean thousandthPlace;
                //类型，可参考这个类InputNumericTypeEnum,默认给2，整数类型
                private Integer type = InputNumericTypeEnum.INTEGER.getValue();
            }

            @Data
            public static
            class AttachmentObj {
                // dmc bucket
                private String buckets;
                private String placeholder;
                private Integer limit;
                private FileMaxSize fileMaxSize;
                private List<Integer> uploadTypes;
                private AttachmentRawData rawData;
                private Boolean isFold = false;
                private Integer foldNumber = 3;
                private Boolean defaultExpand = false;

                @Data
                public static
                class AttachmentRawData {
                    private Boolean disableAam;
                    private String buckets;
                    private String uploadCategory;
                }
            }

            @Data
            public static
            class PictureObj {
                // dmc bucket
                private String buckets;
                private String placeholder;
                private Integer limit = 12;
                private FileMaxSize fileMaxSize;
                private List<Integer> uploadTypes;
                private AttachmentRawData rawData;
                private String describe = "点击上传";
                private Boolean showPictureName = false;
                private Boolean commonUpload = true;
                private Integer displayStyle = 1;

                @Data
                public static
                class AttachmentRawData {
                    private Boolean disableAam;
                    private String buckets;
                    private String uploadCategory;
                }
            }

            @Data
            public static
            class CardPictureObj {
                // dmc bucket
                private String buckets;
                private AttachmentRawData rawData;

                @Data
                public static
                class AttachmentRawData {
                    private Boolean disableAam;
                    //                    private String buckets;
                    private String uploadCategory;
                }
            }

            @Data
            public static
            class ButtonSingleSelectObj {
                //1是单选2是多选,默认为单选
                private Integer showType = ButtonSingleSelectShowTypeEnum.SINGLE_SELECT.getValue();
                //1是上下排列 2是左右排列，默认为上下排列
                private Integer styleType = ButtonSingleSelectStyleTypeEnum.UP_AND_DOWN_LAYOUT.getValue();

                private List<InputSingleSelectOption> optionList;

            }

            @Data
            public static
            class ProgressBarObj {
                //进度条最小值
                private BigDecimal minValue;
                //进度条最大值
                private BigDecimal maxValue;
                //1为整数，2为小数(默认为1)
                private Integer type = ProgressBarTypeEnum.INTEGER_TYPE.getValue();
                // 小数位数，默认为2，当type==2时字段生效
                private Integer decimals = ProgressBarDecimalsEnum.DECIMALS_TWO.getValue();
                //单位 默认%
                private String unit = "%";
                /**
                 * 渐变色
                 * 红色：F03C81→F0021D
                 * 橙色：FFC084→FF8160
                 * 蓝色：91BAFF→5465FF
                 */
                private String activeColor1;
                private String activeColor2;

            }

            @Data
            public static
            class IndicatorChartObj {

                private String title;

                private Boolean titleVisible = false;

                Boolean thousandthPlace = true;

                private List<ChartData> chartData;

            }


            @Data
            public static
            class SubProgressChartObj {

                private String title;

                private Boolean titleVisible = false;

                //路径是否展示
                Boolean routeVisible = true;

                //布局,超出一行时，平铺 1,向右滑动 2，前端在超出一行的情况下再读取这个参数
                private Integer layoutStyle = 1;

                private List<ChartData> chartData;

            }


            @Data
            public static
            class InputSignObj {
                private String placeholder;
                private String editPlaceholder;
                private Boolean timestampAppend = true;
                //支持大小图模式 0:大图,1:小图，默认大图
                private Integer displayStyle = 0;
                //点位的schema
                private String pointSchema;
                //点位的schemaPath
                private String pointSchemaPath;
            }

            @Data
            public static
            class DateTimePickerObj {
                private String placeholder = "";
                // 1：年月日时分，3：年月日
                private Integer type = InputDateTimePickerTypeEnum.YEAR_MONTH_DATE_HOUR_MINUTE.getType();
            }

            @Data
            public static
            class OpenWindowSelectObj {
                private String placeholder;
                // 是否支持手动输入,true:支持；false:不支持--默认值
                private Boolean isEdit = false;

                // 是否支持多选,true:支持；false:不支持--默认值
                private Boolean isMulti = false;

                // 组件样式  3：以按钮样式显示
                private Integer style = InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue();
                private List<PcUiBotTmOperation> operations;
            }

            @Data
            public static
            class MultiTextObj {
                private String placeholder;
                // 最多字数
                private Integer maxLength;
            }

            @Data
            public static
            class SwitchObj {
                private String placeholder;
                // 初始状态，0为关闭，1为打开
                private Integer state = InputSwitchStateEnum.SWITCH_STATE_CLOSE.getState();
            }
        }

        @Data
        public static
        class TagSettingModel {
            /**
             * 前缀
             */
            private String prefix;

            /**
             * 精确匹配=1、以开头=2，（下拉），默认精确匹配
             */
            private Integer matchType = 1;

            /**
             * 拼接元数据=1、拼接显示值=2，（下拉）,默认为显示值
             */
            private Integer spliceSource = 2;

            private List<Option> options;

            @Data
            public static
            class Option {
                private String id;
                //选项内容
                private String text;
                /**
                 * @see Tag.TagType
                 */
                private Integer styleType;

                // 以下属性仅在styleType=0(自定义类型)时生效
                // 背景颜色
                private String bgColor = "F0F3FF";
                // 边框颜色
                private String borderColor = "4670F7";
                // 文字颜色
                private String textColor = "4670F7";
            }
        }

    }

    public void beforeHandleAttribute(Integer buttonLayoutType) {
        List<BaseMobileComponentWrapper<BaseMobileComponent>> cardButtons = this.getCardButtons();
        if (CollectionUtils.isEmpty(cardButtons)) {
            return;
        }
        BaseMobileComponentWrapper<BaseMobileComponent> wrapper = cardButtons.get(0);
        if (wrapper.getData() instanceof ButtonGroup) {
            ButtonGroup buttonGroup = (ButtonGroup) wrapper.getData();
            if (buttonGroup != null) {
                buttonGroup.setButtonLayoutType(buttonLayoutType);
            }
        }
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                                     PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        boolean notExist = cmptContext.getCommonRawDataParentType() == null;
        if (notExist) {
            super.resetCmptMultipleDataSourceData(cmptContext, executeContext, Optional.ofNullable(this.data).map(Card.DesignerRawCard::getDataSource).orElse(null), data);
            cmptContext.setCommonRawDataParentType(CommonRawDataParentType.ALONE_CARD.getValue());
        }
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        Map<String, Object> result = data;
        //设计器配置单独card组件走下面这段，如果是cardlist组件不走这判断
        if (StringUtil.isNotEmpty(schema) && StringUtil.isNotEmpty(mobilePath)) {
            Object o = UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
            if (o instanceof Map) {
                result = (Map<String, Object>) o;
            }
            if (o instanceof List) {
                List<Map<String, Object>> list = (List<Map<String, Object>>) o;
                if (!CollectionUtils.isEmpty(list)) {
                    result = list.get(0);
                }
            }
        }
        handleCard(cmptContext, result, executeContext, mobilePageRawData);
        this.commonChildRawData = buildCommonChildRawData(cmptContext, executeContext, mobilePageRawData);
        if (notExist) {
            cmptContext.setCommonRawDataParentType(null);
        }
    }

    private void handleCard(ComponentContext cmptContext, Map<String, Object> data,
                            PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        this.mobilePath = this.data.getNodePath();
        this.schema = StringUtils.hasLength(cmptContext.getModifyCardDataId()) ? cmptContext.getModifyCardDataId() : buildCardSchema(this.data, data);
        if (StringUtils.hasLength(this.componentId)) {
            // 单独的card组件
            this.cmptUuid = this.componentId;
        } else {
            // 说明是cardList组件中的card
            this.cmptUuid = this.componentId = this.schema;
        }
        this.title = handleCardTitle(this.data, data, this.titleVisible, this.title, executeContext).trim();
        this.titleObj = new Obj().setSchema(this.title).setTitle(this.title);
        this.style = this.data.getStyle();
        this.titleBgColor = "3".equals(StringUtil.valueOf(this.data.getStyle())) ? this.data.getTitleBgColor() : null;
        this.subTitle = handleCardSubTitle(this.data, data).trim();
        this.subTitleObj = new Obj().setSchema(this.subTitle).setTitle(this.subTitle);
        this.subTitleAction = buildSubTitleAction(this.data, data, this.getSchema(), executeContext, mobilePageRawData, cmptContext);
        this.detailPage = buildDetailPage(this.data, data, this.getSchema(), executeContext, mobilePageRawData, cmptContext);
        this.openCardDetailPage = buildOpenCardDetailPage(this.data, this.detailPage);
        this.cardAction = buildCardAction(this.data, this.openCardDetailPage, this.data.getOpenDetailType(), this.detailPage, cmptContext);
        this.content = this.buildContent(this.data, data, executeContext, mobilePageRawData);
        // 处理卡片内容的高级属性
        this.content.forEach(r -> r.handleComponentParam(cmptContext, r.getMobilePath(), r.getSchema(), data, executeContext, mobilePageRawData));
        this.tags = buildTags(this.data.getContent(), data, executeContext.getTmActivityId());
        this.layoutType = this.data.getLayoutType();
        this.openDetailType = this.data.getOpenDetailType();
        //处理卡片折叠相关
        this.defaultFolded = this.data.getDefaultFolded();
        this.foldedType = this.data.getFoldedType();
        this.maxContentDisplay = this.data.getMaxContentDisplay();
        this.cardPicture = buildCardPicture(this.data, data);
        // card卡片的dataid设置一个唯一值，作用于详情页保存后更新原始数据查找的标志，与card的按钮、detailPage的dataid相同
        this.dataId = this.getSchema();
        // 用于批量提交参数替换，识别是哪个条目的id
        data.put(PcUiBotConstants.MOBILE_CARD_DATAID_KEY, this.dataId);
        this.openDetailType = this.data.getOpenDetailType();
        this.isProcessed = this.buildProcessed(this.data.processedConditionList, data);
        this.seq = this.buildSeqConfig(this.data, data, executeContext, cmptContext);
        this.cardButtons = this.handleCardButtons(this.cardButtons, this.data, data, executeContext, mobilePageRawData);
        if (!CollectionUtils.isEmpty(this.cardButtons)) {
            // card中的按钮dataid，设置和card中detailPage中dataid相同
            UiBotDesignerRenderService uiBotDesignerRenderService = SpringContextHolder.getBean(UiBotDesignerRenderService.class);
            uiBotDesignerRenderService.buildCmptDsl(cmptContext, executeContext, this.cardButtons, data, mobilePageRawData.deepCopy().setDataId(this.getSchema()));
        }
        // wjw FIXME: 2024/1/30 已通过设计器配置
//        if ("task_info.inspection_parameter_info.parameter_name".equals(this.data.getTitlePath())) {
//            // 试验优测定制 - 条目详情页card组件是否处理完毕
//            if (MobileInspectionStatusEnum.HAS_CHECKED.getStatus().equals(data.get("inspection_status"))) {
//                this.isProcessed = true;
//            }
//        }
        this.rawData = data;
        // clear
        this.data = null;
    }

    public static Map<String, Object> buildCommonChildRawData(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        //if (CommonRawDataParentType.ALONE_LIST.getValue().equals(cmptContext.getCommonRawDataParentType())) {
        //     独立cardList下card的公共参数前端构建
        //    return new HashMap<>();
        //} else if (CommonRawDataParentType.ALONE_CARD.getValue().equals(cmptContext.getCommonRawDataParentType())) {
        //    // wjw TODO: 2024/7/19 独立card下 构建公共参数 ---- 后期优化
        //    Map<String, Object> rawData = new HashMap<>();
        //    rawData.put("allRawMap", mobilePageRawData.getAllRawMap());
        //    rawData.put("rawMap", mobilePageRawData.getRawMap());
        //    rawData.put("rawDataType", mobilePageRawData.getRawDataType());
        //    rawData.put("baseEntryExtendedFields", mobilePageRawData.getExtendedFields());
        //    rawData.put("sourceCategory", mobilePageRawData.getSourceCategory());
        //    rawData.put("dataKeys", mobilePageRawData.getDataKeys());
        //    rawData.put("componentId", mobilePageRawData.getComponentId());
        //    // rawdata中存入代理token，此值在拦截器中处理
        //    rawData.put("digi-proxy-token", AppRequestContext.getContextEntity().getProxyToken());
        //    rawData.put("executeContext", executeContext);
        //    return rawData;
        //} else {
        //    return new HashMap<>();
        //}
        //无论什么情况下都会返回空map，为了解sonarqube问题，直接返回map
        return new HashMap<>();
    }

    public static String handleCardTitle(DesignerRawCard designerRawCard, Map<String, Object> data, Boolean titleVisible, String title, PcUiBotExecuteContext executeContext) {
        String titleValue = "";
        if (CollectionUtils.isEmpty(designerRawCard.getTitles())) {
            title = BooleanUtils.isTrue(titleVisible) ? title : "";
            if (BooleanUtils.isTrue(designerRawCard.getIsCustomTitle())) {
                titleValue = designerRawCard.getTitle();
            } else {
                titleValue = StringUtils.hasLength(designerRawCard.getTitle()) ? StringUtil.valueOf(data.get(designerRawCard.getTitle())) : title;
                titleValue = getDisplayValue(designerRawCard.getTitleSetting(), titleValue);
            }
            return titleValue;
        }
        if (BooleanUtils.isTrue(designerRawCard.getTitles().get(0).getIsCustom())) {
            titleValue = designerRawCard.getTitles().get(0).getLabel();
        } else {
            for (DesignerRawCard.Content item : designerRawCard.getTitles()) {
                titleValue = titleValue + getDisplayValue(item, StringUtil.valueOf(data.get(item.getSchema()))) + " ";
            }
        }
        if (PcmFilterUtil.isPcmCustomized(executeContext.getTmActivityId(), executeContext.getTmProjectId())
                && designerRawCard.getTitles().stream().anyMatch(r -> "task_no".equals(r.getSchema()))) {
            // PCM_项目预算签核定制 --- 拼接任务名称
            String taskNo = StringUtil.valueOf(data.get("task_no"));
            Map<String, Map<String, Object>> taskInfo = (Map<String, Map<String, Object>>) data.get("mobile_task_no");
            if (!CollectionUtils.isEmpty(taskInfo) && !CollectionUtils.isEmpty(taskInfo.get(taskNo))) {
                titleValue = StringUtil.valueOf(taskInfo.get(taskNo).get("task_name")) + "    " + taskNo;
            }
        }
        return titleValue;
    }

    public static String handleCardSubTitle(DesignerRawCard designerRawCard, Map<String, Object> data) {
        String subTitleValue = "";
        if (BooleanUtils.isTrue(designerRawCard.getIsCustomSubTitle())) {
            subTitleValue = designerRawCard.getSubTitle();
        } else {
            subTitleValue = getDisplayValue(designerRawCard.getSubTitleSetting(), StringUtil.valueOf(data.get(designerRawCard.getSubTitle())));
        }
        return subTitleValue;
    }

    private String buildSeqConfig(DesignerRawCard designerRawCard, Map<String, Object> data, PcUiBotExecuteContext executeContext, ComponentContext cmptContext) {
        DesignerRawCard.SeqConfig seqConfig = designerRawCard.getSeqConfig();
        if (seqConfig == null) {
            return null;
        }
        //true：默认排序; false：获取seqName对应值
        if (BooleanUtils.isFalse(seqConfig.getIsDefaultSeq())) {
            if (StringUtil.isNotEmpty(seqConfig.getSeqName()) && StringUtil.isNotEmpty(seqConfig.getSeqNamePath())) {
                String value = StringUtil.valueOf(data.get(seqConfig.getSeqName()));
                String prev = StringUtil.valueOf(Optional.ofNullable((Map<String, Object>) cmptContext.getRawData().get("data")).orElse(new HashMap<>()).get(PcUiBotConstants.MOBILE_CARD_SEQ_KEY));
                if (StringUtils.hasLength(prev)) {
                    value = prev + "." + value;
                }
                data.put(PcUiBotConstants.MOBILE_CARD_SEQ_KEY, value);
                if (PcmFilterUtil.isPcmCustomizedActivityId(executeContext.getTmActivityId())
                        && "project_budget_info.project_expense_budget_detail".equals(designerRawCard.getNodePath())) {
                    // 费用子项
                    data.remove(PcUiBotConstants.MOBILE_CARD_SEQ_KEY);
                }
                return value;
            }
        }
        return null;
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> handleCardButtons(List<BaseMobileComponentWrapper<BaseMobileComponent>> cardButtons, DesignerRawCard designerRawCard, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        if (CollectionUtils.isEmpty(cardButtons)) {
            return cardButtons;
        }
        if (PcmFilterUtil.isPcmCustomized(executeContext.getTmActivityId(), executeContext.getTmProjectId())) {
            // PCM_项目预算签核定制 -- tab中材料、费用下cardList中card上按钮处理
            // 非其它卡片下
            if (!"project_budget_info".equals(designerRawCard.getNodePath())
                    // 非分项汇总下
                    && !"project_budget_info.project_budget_item_detail".equals(designerRawCard.getNodePath())) {
                BaseMobileComponentWrapper<BaseMobileComponent> wrapper = cardButtons.get(0);
                if (wrapper.getData() instanceof ButtonGroup) {
                    ButtonGroup component = (ButtonGroup) wrapper.getData();
                    if (component != null && !CollectionUtils.isEmpty(component.getContentGroup())) {
                        List<Map<String, Object>> projectExpenseTaskDetail = (List<Map<String, Object>>) data.get("project_expense_task_detail");
                        List<Map<String, Object>> projectMaterialBudgetSubitemDetail = (List<Map<String, Object>>) data.get("project_material_budget_subitem_detail");
                        // 因材料子项和费用子项不会同时存在，故直接相加
                        int size = (projectExpenseTaskDetail == null ? 0 : projectExpenseTaskDetail.size())
                                + (projectMaterialBudgetSubitemDetail == null ? 0 : projectMaterialBudgetSubitemDetail.size());
                        // 如果子项中无数据则不显示按钮
                        if (size == 0) {
                            //按钮全部显示出来，前端通过高级属性来控制隐藏
                            //component.getContentGroup().clear();
                        } else {
                            component.getContentGroup().stream()
                                    .skip((long) (component.getContentGroup().size() - 1))
                                    .findFirst()
                                    .ifPresent(item ->
                                            Optional.ofNullable(((Button<?>) item.getData()).getSubmitAction())
                                                    .ifPresent(action -> action.setTitle(action.getTitle() + "(" + size + ")"))
                                    );
                        }
                    }
                }
            }
        }
        return cardButtons;
    }

    private Boolean buildProcessed(List<CardProcessedCondition> processedConditionList, Map<String, Object> data) {
        if (!CollectionUtils.isEmpty(processedConditionList)) {
            for (CardProcessedCondition process : processedConditionList) {
                if (process.getIs_array()) {
                    return false;
                }
                if (PcUiBotConstants.DataType.OBJECT.equals(process.getData_type())) {
                    return false;
                }
                Object o = data.get(process.getSchema());
                if (o instanceof String) {
                    return Objects.equals(process.getValue(), data.get(process.getSchema()));
                }
                if (StringUtil.isEmpty(process.getLogic())) {
                    return false;
                }
                if (o instanceof Number) {
                    int dataValue = 0;
                    if (o instanceof Double) {
                        dataValue = Double.valueOf(String.valueOf(o)).intValue();
                    }
                    if (o instanceof Integer) {
                        dataValue = Integer.parseInt(String.valueOf(o));
                    }
                    int value = Integer.parseInt(process.getValue());
                    switch (process.getLogic()) {
                        case "==":
                            return dataValue == value;
                        case "!=":
                            return dataValue != value;
                        case ">":
                            return dataValue > value;
                        case ">=":
                            return dataValue >= value;
                        case "<":
                            return dataValue < value;
                        case "<=":
                            return dataValue <= value;
                        default:
                            break;
                    }
                }
            }
        }
        return null;
    }

    public static String getDisplayValue(DesignerRawCard.Content attrSetting, String value) {
        if (attrSetting == null) {
            return value;
        }
        String type = attrSetting.getType();
        if ("NUMERICAL".equals(type)) {
            // 数值
            value = getNumericalValue(attrSetting.getSetting(), value);
        } else if ("ENUM".equals(type)) {
            // 枚举
            value = getEnumValue(attrSetting.getSetting(), value);
        }
        return value;
    }

    public static String buildCardSchema(DesignerRawCard designerRawCard, Map<String, Object> data) {
        List<DesignerRawCard.Content> cardKey = designerRawCard.getCardKey();
        if (CollectionUtils.isEmpty(cardKey)) {
            return UUIDUtil.getUuid();
        }

        boolean isNotExistKey = cardKey.stream().noneMatch(key -> StringUtil.isNotEmpty(MapUtils.getString(data, key.getSchema())));
        if (isNotExistKey) {
            return UUIDUtil.getUuid();
        }

        return cardKey.stream()
                .map(key -> StringUtil.valueOf(data.get(key.getSchema())))
                .collect(Collectors.joining("__"));
    }

    public static List<Tag> buildTags(List<DesignerRawCard.Content> rawContentList, Map<String, Object> data, String tmActivityId) {
        List<Tag> tagList = new ArrayList<>();
        if (CollectionUtils.isEmpty(rawContentList)) {
            return tagList;
        }
        List<DesignerRawCard.Content> collect = rawContentList.stream().filter(a -> "TAG".equalsIgnoreCase(a.getType())).collect(Collectors.toList());
        for (DesignerRawCard.Content rawContent : collect) {
            Tag tag = new Tag();
            String type = rawContent.getType();
            if ("TAG".equals(type)) {
                if ("manage_status".equals(rawContent.getSchema())) {
                    PcUiBotBaseDataUtil.putManageStatusIfAbsent(data);
                }
                getTagValue(tag, rawContent.getSetting(), StringUtil.valueOf(data.get(rawContent.getSchema())));
            }
            tagList.add(tag);
        }
        return tagList;
    }

    public static Picture buildCardPicture(DesignerRawCard designerRawCard, Map<String, Object> data) {
        List<DesignerRawCard.Content> rawContentList = designerRawCard.getContent();
        if (CollectionUtils.isEmpty(rawContentList)) {
            return null;
        }
        DesignerRawCard.Content rawShowPicture = rawContentList.stream().filter(a -> "DW_SHOW_PICTURE".equalsIgnoreCase(a.getType())).findFirst().orElse(null);
        if (rawShowPicture == null) {
            return null;
        }

        Picture picture = new Picture();
        picture.setEnable(false);
        picture.setRequired(false);
        picture.setTitle(rawShowPicture.getLabel());
        picture.setType(AttachmentTypeEnum.READ_ONLY.getValue());
        picture.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
        picture.setUsePreviewUrl(true);

        Object value = data.get(rawShowPicture.getSchema());
        if (value == null) {
            return picture;
        }
        DesignerRawCard.Content.CardPictureObj cardPictureObj = JsonUtil.objectToJavaObject(rawShowPicture.getSetting(), new TypeReference<DesignerRawCard.Content.CardPictureObj>() {
        });
        if (cardPictureObj == null) {
            cardPictureObj = new DesignerRawCard.Content.CardPictureObj();
        }
        if (!StringUtils.hasLength(cardPictureObj.getBuckets())) {
            cardPictureObj.setBuckets("Athena");
        }

        AttachmentRawDataDigiwinAthena rawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
        rawDataDigiwinAthena.setBuckets(cardPictureObj.getBuckets());
        if (cardPictureObj.getRawData() != null) {
            rawDataDigiwinAthena.setDisableAam(cardPictureObj.getRawData().getDisableAam());
            rawDataDigiwinAthena.setUploadCategory(cardPictureObj.getRawData().getUploadCategory());
        }
        picture.setRawData(rawDataDigiwinAthena);

        UiBotAttachment uiBotAttachment = new UiBotAttachment();
        if (value instanceof Map) {
            uiBotAttachment = JsonUtil.objectToJavaObject(value, new TypeReference<UiBotAttachment>() {
            });
        } else if (value instanceof List) {
            uiBotAttachment = JsonUtil.objectToJavaObject(value, new TypeReference<List<UiBotAttachment>>() {
            }).get(0);
        }
        for (UiBotAttachmentData uibotAttachData : uiBotAttachment.getData()) {
            AttachmentFile file = AttachmentFile.create(AppRequestContext.getContextEntity().getLocale(), uibotAttachData);
            file.setPreviewUrl(AppContext.getApiUrlSetting().getDmcUrl() + "/api/dmc/v2/file/" + cardPictureObj.getBuckets() + "/preview/" + file.getFileId());
            picture.getFileList().add(file);
        }
        return picture;
    }

    public List<CardContent> buildContent(DesignerRawCard designerRawCard, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        String tmActivityId = executeContext.getTmActivityId();
        String locale = executeContext.getLocale();
        List<CardContent> contentList = new ArrayList<>();
        List<DesignerRawCard.Content> rawContentList = designerRawCard.getContent();
        if (CollectionUtils.isEmpty(rawContentList)) {
            return contentList;
        }
        //过滤 TAG、DW_SHOW_PICTURE类型
        List<DesignerRawCard.Content> collect = rawContentList.stream()
                .filter(a -> !"TAG".equalsIgnoreCase(a.getType())
                        && !"DW_SHOW_PICTURE".equalsIgnoreCase(a.getType()))
                .collect(Collectors.toList());
        if ("PWD_RTP_InquiryReply".equals(tmActivityId) && PcUiBotActivityConstant.TASK_DATA_STATE_CODE_COMPLETED.equals(executeContext.getDataStateCode())) {
            // 带图采购-询价回复-已完成页签-定制:无法供给隐藏回复单价、回复交期
            if ("true".equals(StringUtil.valueOf(data.get("is_unable_supply")))) {
                collect.removeIf(a -> "inquiry_price".equals(a.getSchema()) || "reply_duedate".equals(a.getSchema()));
            }
        }
        for (DesignerRawCard.Content rawContent : collect) {
            CardContent cardContent = new CardContent();
            String label = rawContent.getLabel();//this.getMultilingual(rawContent, rawContent.getLabel());
            cardContent.setLabel(label);
            cardContent.setHiddenLabel(false);
            cardContent.setValueStyleType(1);
            cardContent.setSchema(rawContent.getSchema());
            cardContent.setMobilePath(rawContent.getFullPath());
            cardContent.setComponentId(rawContent.getComponentId());
            String type = rawContent.getType();
            if ("DW_PICTURE".equals(type)) {
                // 图片
                Picture picture = this.getPicture(rawContent.getSetting(), data.get(rawContent.getSchema()), label);
                if (CollectionUtils.isEmpty(picture.getFileList())) {
                    // 普通文本展示 留空，易读
                } else {
                    cardContent.setLabel("");
                    cardContent.setValueStyleType(0);
                    cardContent.setPicture(picture);
                }
            } else if ("FILE_UPLOAD".equals(type)) {
                // 附件
                Attachment<AttachmentRawDataDigiwinAthena> attachment = getAttachment(rawContent.getSetting(), data.get(rawContent.getSchema()), label);
                if (CollectionUtils.isEmpty(attachment.getFileList())) {
                    // 普通文本展示 留空，易读
                } else {
                    cardContent.setLabel("");
                    cardContent.setValueStyleType(0);
                    cardContent.setFile(attachment);
                }
            } else if ("NUMERICAL".equals(type)) {
                // 数值
                cardContent.setValue(getNumericalValue(rawContent.getSetting(), StringUtil.valueOf(data.get(rawContent.getSchema()))));
                // 定制
                this.customizeNumericalValue(data, rawContent, cardContent, designerRawCard, executeContext, mobilePageRawData);
                handleLePuShengOrderQuantity(data, tmActivityId, cardContent, rawContent.getSchema());
                // 处理多字段拼接
                this.handleCardContentMultiValue(data, rawContent, cardContent, executeContext);
                // 处理新原值 --- 必须放在处理多字段拼接后面
                this.handleCardContentNewOldValue(data, rawContent, designerRawCard, cardContent, executeContext);
                //处理千分位，非新原值在当前结构展示，但是配置还是读setting，新原值在子结构展示
                cardContent.setThousandthPlace(handleCardContentThousandthPlace(rawContent.getSetting()));
                // PCM_项目预算签核定制 占比计算
                this.customizePcmBudgetProjectApprovalsRate(data, rawContent, cardContent, designerRawCard, executeContext, mobilePageRawData);
            } else if ("ENUM".equals(type)) {
                // 枚举
                cardContent.setValue(getEnumValue(rawContent.getSetting(), StringUtil.valueOf(data.get(rawContent.getSchema()))));
                handleLePuShengQuotationType(data, tmActivityId, cardContent, locale, rawContent.getSchema());
                // 处理多字段拼接
                this.handleCardContentMultiValue(data, rawContent, cardContent, executeContext);
            } else if ("DW_MOBILE_TEL".equals(type)) {
                // 手机号
                cardContent.setType("PHONE");
                cardContent.setValue(StringUtil.valueOf(data.get(rawContent.getSchema())));
            } else if ("LABEL".equals(type)) {
                // 文本
                this.buildCardContentLabelTypeData(cardContent, contentList, data, rawContent, executeContext);
            } else {
                cardContent.setValue(StringUtil.valueOf(data.get(rawContent.getSchema())));
                // 处理多字段拼接
                this.handleCardContentMultiValue(data, rawContent, cardContent, executeContext);
            }
            // 必须放在最后加入列表，位置不能变，因buildCardContentLabelTypeData方法中，由最后一个数据来更新cardContent
            contentList.add(cardContent);
        }
        return contentList;
    }


    private void customizeNumericalValue(Map<String, Object> data, DesignerRawCard.Content rawContent, CardContent cardContent, DesignerRawCard designerRawCard, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        if (PcmFilterUtil.isPcmCustomized(executeContext.getTmActivityId(), executeContext.getTmProjectId())) {
            // PCM_项目预算签核定制 --- 汇总处理
            if ("project_budget_info".equals(designerRawCard.getNodePath())) {
                String value = StringUtil.valueOf(data.get(rawContent.getSchema()));
                List<Map<String, Object>> projectItemDetail = (List<Map<String, Object>>) data.get("project_budget_item_detail");
                if ("contract_local_curr_not_tax_amount".equals(rawContent.getSchema())) {
                    //合同金額
                    Integer decimalPlaces = Integer.valueOf(String.valueOf(data.get("mobile_cost_decimal_places")));
                    value = new BigDecimal(value).setScale(decimalPlaces, BigDecimal.ROUND_HALF_UP).toPlainString();
                    value = StringUtils.hasLength(value) ? value : "0";
                }
                if ("quotation_gross_margin".equals(rawContent.getSchema())) {
                    //报价毛利率
                    //页签报价预估金额总和除以合同金额
                    String valuationAmount = String.valueOf(projectItemDetail.stream()
                            .map(map -> map.get("quotation_valuation_amount"))
                            .filter(values -> values instanceof Number) // 确保值是数字类型
                            .map(values -> new BigDecimal(values.toString())) // 转换为 BigDecimal
                            .reduce(BigDecimal.ZERO, BigDecimal::add));
                    valuationAmount = StringUtils.hasLength(valuationAmount) ? valuationAmount : "0";
                    String notTaxAmount = StringUtil.valueOf(data.get("contract_local_curr_not_tax_amount"));
                    if (StringUtils.hasLength(notTaxAmount) && new BigDecimal(notTaxAmount).compareTo(BigDecimal.ZERO) != 0) {
                        value = new BigDecimal(100)
                                .subtract(
                                        new BigDecimal(valuationAmount)
                                                .divide(new BigDecimal(notTaxAmount), 10, BigDecimal.ROUND_HALF_UP)
                                                .multiply(new BigDecimal(100))
                                ).toPlainString();
                    } else {
                        value = "0";
                    }

                }
                if ("budget_gross_margin".equals(rawContent.getSchema())) {
                    //预算毛利率，页签预算金额总和除以合同金额
                    String costAmount = String.valueOf(projectItemDetail.stream()
                            .map(map -> map.get("cost_amount"))
                            .filter(values -> values instanceof Number) // 确保值是数字类型
                            .map(values -> new BigDecimal(values.toString())) // 转换为 BigDecimal
                            .reduce(BigDecimal.ZERO, BigDecimal::add));
                    costAmount = StringUtils.hasLength(costAmount) ? costAmount : "0";
                    String notTaxAmount = StringUtil.valueOf(data.get("contract_local_curr_not_tax_amount"));
                    if (StringUtils.hasLength(notTaxAmount) && new BigDecimal(notTaxAmount).compareTo(BigDecimal.ZERO) != 0) {
                        value = new BigDecimal(100)
                                .subtract(
                                        new BigDecimal(costAmount)
                                                .divide(new BigDecimal(notTaxAmount), 10, BigDecimal.ROUND_HALF_UP)
                                                .multiply(new BigDecimal(100))
                                ).toPlainString();
                    } else {
                        value = "0";
                    }
                }
                if ("quotation_valuation_amount".equals(rawContent.getSchema())) {
                    //报价预估金额
                    BigDecimal date = projectItemDetail.stream()
                            .map(map -> map.get("quotation_valuation_amount"))
                            .filter(values -> values instanceof Number) // 确保值是数字类型
                            .map(values -> new BigDecimal(values.toString())) // 转换为 BigDecimal
                            .reduce(BigDecimal.ZERO, BigDecimal::add);

                    Integer decimalPlaces = Integer.valueOf(String.valueOf(data.get("mobile_cost_decimal_places")));
                    value = date.setScale(decimalPlaces, BigDecimal.ROUND_HALF_UP).toPlainString();
                    value = StringUtils.hasLength(value) ? value : "0";
                }
                if ("budget_amount".equals(rawContent.getSchema())) {
                    //预算金额
                    BigDecimal date = projectItemDetail.stream()
                            .map(map -> map.get("cost_amount"))
                            .filter(values -> values instanceof Number) // 确保值是数字类型
                            .map(values -> new BigDecimal(values.toString())) // 转换为 BigDecimal
                            .reduce(BigDecimal.ZERO, BigDecimal::add);
                    Integer decimalPlaces = Integer.valueOf(String.valueOf(data.get("mobile_cost_decimal_places")));
                    value = date.setScale(decimalPlaces, BigDecimal.ROUND_HALF_UP).toPlainString();
                    value = StringUtils.hasLength(value) ? value : "0";
                }
                if ("expense_budget_amount".equals(rawContent.getSchema())) {
                    //差异
                    BigDecimal date = projectItemDetail.stream()
                            .map(map -> map.get("quotation_valuation_amount"))
                            .filter(values -> values instanceof Number) // 确保值是数字类型
                            .map(values -> new BigDecimal(values.toString())) // 转换为 BigDecimal
                            .reduce(BigDecimal.ZERO, BigDecimal::add)
                            .subtract(projectItemDetail.stream()
                                    .map(map -> map.get("cost_amount"))
                                    .filter(values -> values instanceof Number) // 确保值是数字类型
                                    .map(values -> new BigDecimal(values.toString())) // 转换为 BigDecimal
                                    .reduce(BigDecimal.ZERO, BigDecimal::add));
                    Integer decimalPlaces = Integer.valueOf(String.valueOf(data.get("mobile_cost_decimal_places")));
                    value = date.setScale(decimalPlaces, BigDecimal.ROUND_HALF_UP).toPlainString();
                    value = StringUtils.hasLength(value) ? value : "0";
                }
                if ("quotation_valuation_amount".equals(rawContent.getSchema()) ||
                        "budget_amount".equals(rawContent.getSchema()) ||
                        "expense_budget_amount".equals(rawContent.getSchema()) ||
                        "contract_local_curr_not_tax_amount".equals(rawContent.getSchema())) {
                    //报价预估金额，预算金额，差异 走取位接口
                    cardContent.setValue(value);
                } else {
                    cardContent.setValue(getNumericalValue(rawContent.getSetting(), value));
                }

            } else {
                if ("use_qty".equals(rawContent.getSchema()) || "qty".equals(rawContent.getSchema())) {
                    Map<String, Object> setting = (Map<String, Object>) rawContent.getSetting();
                    //setting.put("unit", StringUtil.valueOf(data.get("unit_name")));
                    String value = StringUtil.valueOf(data.get(rawContent.getSchema()));
                    if (NumberUtils.isCreatable(value)) {
                        String plainString = new BigDecimal(value).stripTrailingZeros().toPlainString();
                        setting.put("decimalPoint", plainString.contains(".") ? (plainString.length() - plainString.indexOf(".") - 1) : 0);
                    }
                    cardContent.setValue(getNumericalValue(rawContent.getSetting(), value));
                }
                if ("price".equals(rawContent.getSchema()) && StringUtils.hasLength(StringUtil.valueOf(data.get("mobile_unit_issue_cost_decimal_places")))) {
                    // 单价(price) 小数点保留位数
                    Map<String, Object> setting = (Map<String, Object>) rawContent.getSetting();
                    String value = StringUtil.valueOf(data.get(rawContent.getSchema()));
                    setting.put("decimalPoint", StringUtil.valueOf(data.get("mobile_unit_issue_cost_decimal_places")));
                    cardContent.setValue(getNumericalValue(rawContent.getSetting(), value));
                }
                if (("cost_amount".equals(rawContent.getSchema()) || "quotation_valuation_amount".equals(rawContent.getSchema())
                        || "difference_amount".equals(rawContent.getSchema())) && StringUtils.hasLength(StringUtil.valueOf(data.get("mobile_cost_decimal_places")))) {
                    // 金额(cost_amount) 小数点保留位数
                    Map<String, Object> setting = (Map<String, Object>) rawContent.getSetting();
                    String value = StringUtil.valueOf(data.get(rawContent.getSchema()));
                    setting.put("decimalPoint", StringUtil.valueOf(data.get("mobile_cost_decimal_places")));
                    cardContent.setValue(getNumericalValue(rawContent.getSetting(), value));
                }
            }

        }
    }

    private void customizePcmBudgetProjectApprovalsRate(Map<String, Object> data, DesignerRawCard.Content rawContent, CardContent cardContent, DesignerRawCard designerRawCard, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        if (!PcmFilterUtil.isPcmCustomized(executeContext.getTmActivityId(), executeContext.getTmProjectId())) {
            return;
        }
        // 分项汇总tab下 占比处理
        if (!"project_budget_info.project_budget_item_detail".equals(designerRawCard.getNodePath())) {
            return;
        }
        if (!"rate".equals(rawContent.getSchema())) {
            return;
        }
        // 获取分项汇总下数据
        List<Map<String, Object>> projectBudgetItemDetail = (List<Map<String, Object>>) mobilePageRawData.getRawMap().get("project_budget_item_detail");
        if (CollectionUtils.isEmpty(projectBudgetItemDetail)) {
            return;
        }
        // 占比：预算金额 除以 预算金额合计
        BigDecimal budgetAmountTotal = new BigDecimal(0);
        if (projectBudgetItemDetail != null) {
            budgetAmountTotal = projectBudgetItemDetail.stream()
                    .map(map -> map.get("cost_amount"))
                    .filter(values -> values instanceof Number) // 确保值是数字类型
                    .map(values -> new BigDecimal(values.toString())) // 转换为 BigDecimal
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (BigDecimal.ZERO.compareTo(budgetAmountTotal) == 0) {
            // 预算金额合计=0,则占比都为0
            cardContent.setValue(getDisplayValue(rawContent, "0.00"));
            return;
        }

        //做法：每笔计算按公式计算，有尾差的话，挤到最大的那笔上，如果最大的那笔不止一笔，则放到排序的第一笔上
        List<BigDecimal> costAmountAll = projectBudgetItemDetail.stream().map(map -> new BigDecimal(StringUtil.valueOf(map.getOrDefault("cost_amount", 0)))).collect(Collectors.toList());
        BigDecimal max = Collections.max(costAmountAll);
        // 最大笔个数
        int maxCount = 0;
        for (BigDecimal bigDecimal : costAmountAll) {
            if (bigDecimal.compareTo(max) == 0) {
                maxCount++;
            }
        }
        Map<String, BigDecimal> seqRateMap = new HashMap<>();
        if (maxCount > 1) {
            // 最大的那笔不止一笔，则放到排序的第一笔上
            // 计算其它的占比
            BigDecimal other = BigDecimal.ZERO;
            for (int i = 0; i < projectBudgetItemDetail.size(); i++) {
                if (i == 0) {
                    continue;
                }
                BigDecimal costAmount = new BigDecimal(StringUtil.valueOf(projectBudgetItemDetail.get(i).getOrDefault("cost_amount", 0)));
                BigDecimal divide = costAmount.multiply(new BigDecimal(100)).divide(budgetAmountTotal, 2, RoundingMode.HALF_UP);
                seqRateMap.put(StringUtil.valueOf(projectBudgetItemDetail.get(i).get("seq")), divide);
                other = other.add(divide);
            }
            seqRateMap.put(StringUtil.valueOf(projectBudgetItemDetail.get(0).get("seq")), new BigDecimal(100).subtract(other));
        } else {
            // 有尾差的话，挤到最大的那笔上
            Map<String, Object> maxMap = new HashMap<>();
            // 计算其它的占比
            BigDecimal other = BigDecimal.ZERO;
            for (int i = 0; i < projectBudgetItemDetail.size(); i++) {
                BigDecimal costAmount = new BigDecimal(StringUtil.valueOf(projectBudgetItemDetail.get(i).getOrDefault("cost_amount", 0)));
                if (costAmount.compareTo(max) == 0) {
                    maxMap = projectBudgetItemDetail.get(i);
                    continue;
                }
                BigDecimal divide = costAmount.multiply(new BigDecimal(100)).divide(budgetAmountTotal, 2, RoundingMode.HALF_UP);
                seqRateMap.put(StringUtil.valueOf(projectBudgetItemDetail.get(i).get("seq")), divide);
                other = other.add(divide);
            }
            seqRateMap.put(StringUtil.valueOf(maxMap.get("seq")), new BigDecimal(100).subtract(other));
        }
        // 获取当前数据的占比
        cardContent.setValue(getDisplayValue(rawContent, seqRateMap.get(StringUtil.valueOf(data.get("seq"))).toString()));
    }


    private void handleCardContentMultiValue(Map<String, Object> data, DesignerRawCard.Content rawContent, CardContent cardContent, PcUiBotExecuteContext executeContext) {
        if (CollectionUtils.isEmpty(rawContent.getSubContent())) {
            return;
        }
        // 多内容拼接
        CardContent.MultiValueObj multiValueObj = new CardContent.MultiValueObj();
        cardContent.setMultiValue(multiValueObj);

        //  设置分隔符默认空格
        multiValueObj.setSeparator("  ");
        //  设置是否换行
        // wjw FIXME: 2024/4/16 前端暂未使用
        multiValueObj.setIsLineFeed(BooleanUtils.isTrue(rawContent.getSubContent().get(0).getIsLineFeed()));

        List<CardContent.MultiValueObj.MultiValueObjData> list = new ArrayList<>();
        multiValueObj.setData(list);

        // 设置第一个字段
        CardContent.MultiValueObj.MultiValueObjData multiValueObjData = new CardContent.MultiValueObj.MultiValueObjData();
        multiValueObjData.setSchema(cardContent.getSchema());
        multiValueObjData.setFullPath(rawContent.getSubContent().get(0).getFullPath());
        multiValueObjData.setLabel(cardContent.getLabel());
        multiValueObjData.setValue(cardContent.getValue());
        multiValueObjData.setThousandthPlace(handleCardContentThousandthPlace(rawContent.getSetting()));
        list.add(multiValueObjData);
        // 设置拼接的字段
        rawContent.getSubContent().forEach(subContent -> {
            CardContent.MultiValueObj.MultiValueObjData objData = new CardContent.MultiValueObj.MultiValueObjData();
            objData.setSchema(subContent.getSchema());
            objData.setFullPath(subContent.getFullPath());
            objData.setLabel(subContent.getLabel());
            objData.setValue(getDisplayValue(subContent, StringUtil.valueOf(data.get(subContent.getSchema()))));
            objData.setThousandthPlace(handleCardContentThousandthPlace(subContent.getSetting()));
            list.add(objData);
        });
        if (list.stream().noneMatch(r -> StringUtils.hasLength(r.getValue()))) {
            // 值全部为空，则赋默认值
            list.get(0).setValue("-");
        }
    }

    private void handleCardContentNewOldValue(Map<String, Object> data, DesignerRawCard.Content rawContent, DesignerRawCard designerRawCard, CardContent cardContent, PcUiBotExecuteContext executeContext) {
        // 判断是否存在拼接逻辑，存在：不再处理新原值；不存在：则处理新原值逻辑
        if (cardContent.getMultiValue() != null) {
            return;
        }
        if (!data.containsKey("old_" + rawContent.getSchema())) {
            // 不包含原值
            return;
        }
        // PCM_项目预算签核定制
        boolean isPcmCustomize = this.customizePcmBudgetProjectApprovals(data, rawContent, designerRawCard, cardContent, executeContext);
        if (isPcmCustomize) {
            return;
        }
        // 新原值
        String newValue = StringUtil.valueOf(data.get(rawContent.getSchema()));
        String oldValue = StringUtil.valueOf(data.get("old_" + rawContent.getSchema()));
        // 构建新原值对象
        this.buildCardContentNewOldValue(rawContent, rawContent, newValue, oldValue, cardContent);
    }

    private boolean customizePcmBudgetProjectApprovals(Map<String, Object> data, DesignerRawCard.Content rawContent, DesignerRawCard designerRawCard, CardContent cardContent, PcUiBotExecuteContext executeContext) {
        boolean isPcmCustomize = false;
        if (!PcmFilterUtil.isPcmCustomized(executeContext.getTmActivityId(), executeContext.getTmProjectId())) {
            return isPcmCustomize;
        }
        isPcmCustomize = true;
        if ("V1.0".equals(StringUtil.valueOf(data.get("mobile_version_no")))) {
            // 版本version_no=V1.0,不显示新原值
            return isPcmCustomize;
        }
        if (!"true".equals(StringUtil.valueOf(data.get("mobile_exist_previous_budget")))) {
            // exist_previous_budget：true时需要展示新旧值，fasle不需要展示新旧值
            return isPcmCustomize;
        }
        if ("project_budget_info.project_budget_item_detail".equals(designerRawCard.getNodePath())) {
            // 分项汇总tab下：新值和旧值返回不一样就展示
            if ("quotation_valuation_amount".equals(rawContent.getSchema())) {
                // 报价预估金额，新原值不显示
                return isPcmCustomize;
            }
            // 新原值
            String newValue = StringUtil.valueOf(data.get(rawContent.getSchema()));
            String oldValue = StringUtil.valueOf(data.get("old_" + rawContent.getSchema()));
            if (!newValue.equals(oldValue)) {
                // 构建新原值对象
                this.buildCardContentNewOldValue(rawContent, rawContent, newValue, oldValue, cardContent);
            }
        } else {
            // 材料、费用tab下：使用量、单价、金额有一个返回不一致，这一行的三个字段就同时展示
            // 材料下对应字段
            String qtyNewValue = StringUtil.valueOf(data.getOrDefault("qty", 0));
            String qtyOldValue = StringUtil.valueOf(data.getOrDefault("old_qty", 0));
            // 费用下对应字段
            String useQtyNewValue = StringUtil.valueOf(data.getOrDefault("use_qty", 0));
            String useQtyOldValue = StringUtil.valueOf(data.getOrDefault("old_use_qty", 0));
            // 材料、费用对应字段
            String priceNewValue = StringUtil.valueOf(data.getOrDefault("price", 0));
            String priceOldValue = StringUtil.valueOf(data.getOrDefault("old_price", 0));
            String costAmountNewValue = StringUtil.valueOf(data.getOrDefault("cost_amount", 0));
            String costAmountOldValue = StringUtil.valueOf(data.getOrDefault("old_cost_amount", 0));
            // 费用子项对应字段 预计工时不一致就显示
            String planWorkHoursNewValue = StringUtil.valueOf(data.getOrDefault("plan_work_hours", 0));
            String planWorkHoursOldValue = StringUtil.valueOf(data.getOrDefault("old_plan_work_hours", 0));

            // 新原值
            String newValue = StringUtil.valueOf(data.get(rawContent.getSchema()));
            String oldValue = StringUtil.valueOf(data.get("old_" + rawContent.getSchema()));
            if (!qtyNewValue.equals(qtyOldValue) || !useQtyNewValue.equals(useQtyOldValue) || !priceNewValue.equals(priceOldValue) || !costAmountNewValue.equals(costAmountOldValue) || !planWorkHoursNewValue.equals(planWorkHoursOldValue)) {
                DesignerRawCard.Content oldRawContent = JsonUtil.objectToJavaObject(rawContent, DesignerRawCard.Content.class);
                if ("use_qty".equals(rawContent.getSchema()) || "qty".equals(rawContent.getSchema())) {
                    Map<String, Object> setting = (Map<String, Object>) rawContent.getSetting();
                    //setting.put("unit", StringUtil.valueOf(data.get("unit_name")));
                    if (NumberUtils.isCreatable(newValue)) {
                        String plainString = new BigDecimal(newValue).stripTrailingZeros().toPlainString();
                        setting.put("decimalPoint", plainString.contains(".") ? (plainString.length() - plainString.indexOf(".") - 1) : 0);
                    }
                    Map<String, Object> oldSetting = (Map<String, Object>) oldRawContent.getSetting();
                    //oldSetting.put("unit", StringUtil.valueOf(data.get("unit_name")));
                    if (NumberUtils.isCreatable(oldValue)) {
                        String plainString = new BigDecimal(oldValue).stripTrailingZeros().toPlainString();
                        oldSetting.put("decimalPoint", plainString.contains(".") ? (plainString.length() - plainString.indexOf(".") - 1) : 0);
                    }
                }
                if ("price".equals(rawContent.getSchema()) && StringUtils.hasLength(StringUtil.valueOf(data.get("mobile_unit_issue_cost_decimal_places")))) {
                    // 单价(price) 小数点保留位数
                    Map<String, Object> setting = (Map<String, Object>) rawContent.getSetting();
                    setting.put("decimalPoint", StringUtil.valueOf(data.get("mobile_unit_issue_cost_decimal_places")));
                    Map<String, Object> oldSetting = (Map<String, Object>) oldRawContent.getSetting();
                    oldSetting.put("decimalPoint", StringUtil.valueOf(data.get("mobile_unit_issue_cost_decimal_places")));
                }
                if ("cost_amount".equals(rawContent.getSchema()) && StringUtils.hasLength(StringUtil.valueOf(data.get("mobile_cost_decimal_places")))) {
                    // 金额(cost_amount) 小数点保留位数
                    Map<String, Object> setting = (Map<String, Object>) rawContent.getSetting();
                    setting.put("decimalPoint", StringUtil.valueOf(data.get("mobile_cost_decimal_places")));
                    Map<String, Object> oldSetting = (Map<String, Object>) oldRawContent.getSetting();
                    oldSetting.put("decimalPoint", StringUtil.valueOf(data.get("mobile_cost_decimal_places")));
                }
                // 构建新原值对象
                this.buildCardContentNewOldValue(rawContent, oldRawContent, newValue, oldValue, cardContent);
            }
        }
        return isPcmCustomize;
    }

    private void buildCardContentNewOldValue(DesignerRawCard.Content newRawContent, DesignerRawCard.Content oldRawContent, String newValue, String oldValue, CardContent cardContent) {
        // 构建新原值对象
        CardContent.NewOldValueObj newOldValueObj = new CardContent.NewOldValueObj();
        List<CardContent.NewOldValueObj.NewOldValueObjData> newOldValueObjData = newOldValueObj.getData();
        CardContent.NewOldValueObj.NewOldValueObjData newObjData = newOldValueObjData.get(0);
        CardContent.NewOldValueObj.NewOldValueObjData oldObjData = newOldValueObjData.get(1);
        newObjData.setValue(getDisplayValue(newRawContent, newValue));
        if (newRawContent != null) {
            newObjData.setThousandthPlace(handleCardContentThousandthPlace(newRawContent.getSetting()));
        } else {
            newObjData.setThousandthPlace(false);
        }
        oldObjData.setValue(getDisplayValue(oldRawContent, oldValue));
        if (oldRawContent != null) {
            oldObjData.setThousandthPlace(handleCardContentThousandthPlace(oldRawContent.getSetting()));
        } else {
            oldObjData.setThousandthPlace(false);
        }
        cardContent.setNewOldValue(newOldValueObj);
    }

    private void buildCardContentLabelTypeData(CardContent cardContent, List<CardContent> contentList, Map<String, Object> data, DesignerRawCard.Content rawContent, PcUiBotExecuteContext executeContext) {
        String tmActivityId = executeContext.getTmActivityId();
        if ("UT_InspectionResultsRegistration".equalsIgnoreCase(tmActivityId)) {
            // 试验优测定制 - 已完成页签子条目详情页数据定制处理
            if ("judgment_standard_list".equals(rawContent.getSchema())) {
                // 判定标准
                List<Map<String, Object>> list = (List<Map<String, Object>>) data.get(rawContent.getSchema());
                if (!CollectionUtils.isEmpty(list)) {
                    for (int i = 0; i < list.size(); i++) {
                        Map<String, Object> map = list.get(i);
                        String label = StringUtil.valueOf(map.get("judgment_name"));
                        String value = StringUtil.valueOf(map.get("judgment_value"));
                        if (i == list.size() - 1) {
                            // 动态添加栏位，最后一个元素更新cardContent数据
                            cardContent.setLabel(label);
                            cardContent.setValue(value);
                        } else {
                            CardContent otherContent = new CardContent();
                            otherContent.setLabel(label);
                            otherContent.setHiddenLabel(false);
                            otherContent.setValueStyleType(1);
                            otherContent.setSchema(rawContent.getSchema());
                            otherContent.setMobilePath(rawContent.getFullPath());
                            otherContent.setComponentId(rawContent.getComponentId());
                            otherContent.setValue(value);
                            contentList.add(otherContent);
                        }
                    }
                }
            } else if ("inspector_link_info".equals(rawContent.getSchema())) {
                // 检验员
                List<Map<String, Object>> list = (List<Map<String, Object>>) data.get(rawContent.getSchema());
                if (!CollectionUtils.isEmpty(list)) {
                    cardContent.setValue(list.stream().map(map -> StringUtil.valueOf(map.get("inspector_name"))).collect(Collectors.joining("，")));
                }
            } else if ("execute_time_start".equals(rawContent.getSchema())) {
                // 检验时间
                String beginTime = StringUtil.valueOf(data.get(rawContent.getSchema()));
                String endTime = StringUtil.valueOf(data.get("execute_time_end"));
                cardContent.setValue(("0002-11-30 00:00:00".equals(beginTime) ? "1902-11-30 00:00:00" : beginTime)
                        + " ~ "
                        + ("0002-11-30 00:00:00".equals(endTime) ? "1902-11-30 00:00:00" : endTime));
            } else {
                // 其它
                cardContent.setValue(StringUtil.valueOf(data.get(rawContent.getSchema())));
            }
        } else if ("DataEntry_pccProjectQuestionList".equals(tmActivityId)) {
            if (UiBotDesignerService.PAGECODE_BROWSE_PAGE.equals(executeContext.getPageCode()) && "project_name".equals(rawContent.getSchema())) {
                // PCC_项目问题清单定制：浏览页面，项目名称自动拼接项目编号
                String projectName = StringUtil.valueOf(data.get(rawContent.getSchema()));
                String projectNo = StringUtil.valueOf(data.get("project_no"));
                if (StringUtils.hasLength(projectNo)) {
                    projectName = projectName + "[" + projectNo + "]";
                }
                cardContent.setValue(projectName);
            } else if (UiBotDesignerService.PAGECODE_EDIT_PAGE.equals(executeContext.getPageCode()) && "actual_finish_datetime".equals(rawContent.getSchema())) {
                // PCC_项目问题清单定制,接口日期返回9998-12-31处理，pc反馈因为组件问题无法修改为空，移动兜底处理下
                String actualFinishDatetime = StringUtil.valueOf(data.get(rawContent.getSchema()));
                if (actualFinishDatetime.startsWith("9998")) {
                    cardContent.setValue(null);
                } else {
                    cardContent.setValue(actualFinishDatetime);
                }
            } else {
                // 标准label赋值
                cardContent.setValue(StringUtil.valueOf(data.get(rawContent.getSchema())));
                // 处理多字段拼接
                this.handleCardContentMultiValue(data, rawContent, cardContent, executeContext);
            }
        } else if (PcmFilterUtil.isPcmCustomized(executeContext.getTmActivityId(), executeContext.getTmProjectId())) {
            // PCM_项目预算签核定制-- 关联任务页面 合计工时处理
            if ("project_budget_info.project_expense_budget_detail.project_no".equals(rawContent.getFullPath())) {
                List<Map<String, Object>> projectExpenseTaskDetail = (List<Map<String, Object>>) data.get("project_expense_task_detail");
                String value = "";
                if (!CollectionUtils.isEmpty(projectExpenseTaskDetail)) {
                    BigDecimal total = BigDecimal.ZERO;
                    for (Map<String, Object> map : projectExpenseTaskDetail) {
                        total = total.add(new BigDecimal(StringUtil.valueOf(map.getOrDefault("plan_work_hours", 0))));
                    }
                    value = total.stripTrailingZeros().toPlainString();
                }
                cardContent.setValue(value);
            } else {
                // 标准label赋值
                cardContent.setValue(StringUtil.valueOf(data.get(rawContent.getSchema())));
                // 处理多字段拼接
                this.handleCardContentMultiValue(data, rawContent, cardContent, executeContext);
            }
        } else {
            // 标准label赋值
            cardContent.setValue(getLableValue(rawContent.getSetting(), StringUtil.valueOf(data.get(rawContent.getSchema()))));
            // 处理多字段拼接
            this.handleCardContentMultiValue(data, rawContent, cardContent, executeContext);
        }
    }

    private Picture getPicture(Object setting, Object value, String label) {
        Picture picture = new Picture();
        picture.setEnable(false);
        picture.setRequired(false);
        picture.setTitle(label);
        picture.setType(AttachmentTypeEnum.READ_ONLY.getValue());
        picture.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
        picture.setUsePreviewUrl(true);
        if (value == null) {
            return picture;
        }
        DesignerRawCard.Content.PictureObj pictureObj = JsonUtil.objectToJavaObject(setting, new TypeReference<DesignerRawCard.Content.PictureObj>() {
        });
        if (pictureObj == null) {
            pictureObj = new DesignerRawCard.Content.PictureObj();
        }
        if (!StringUtils.hasLength(pictureObj.getBuckets())) {
            pictureObj.setBuckets("Athena");
        }

        AttachmentRawDataDigiwinAthena rawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
        rawDataDigiwinAthena.setBuckets(pictureObj.getBuckets());
        if (pictureObj.getRawData() != null) {
            rawDataDigiwinAthena.setDisableAam(pictureObj.getRawData().getDisableAam());
            rawDataDigiwinAthena.setUploadCategory(pictureObj.getRawData().getUploadCategory());
        }
        picture.setRawData(rawDataDigiwinAthena);

        UiBotAttachment uiBotAttachment = new UiBotAttachment();
        if (value instanceof Map) {
            uiBotAttachment = JsonUtil.objectToJavaObject(value, new TypeReference<UiBotAttachment>() {
            });
        } else if (value instanceof List) {
            uiBotAttachment = JsonUtil.objectToJavaObject(value, new TypeReference<List<UiBotAttachment>>() {
            }).get(0);
        }
        for (UiBotAttachmentData uibotAttachData : uiBotAttachment.getData()) {
            AttachmentFile file = AttachmentFile.create(AppRequestContext.getContextEntity().getLocale(), uibotAttachData);
            file.setPreviewUrl(AppContext.getApiUrlSetting().getDmcUrl() + "/api/dmc/v2/file/" + pictureObj.getBuckets() + "/preview/" + file.getFileId());
            picture.getFileList().add(file);
        }
        return picture;
    }

    public static Attachment<AttachmentRawDataDigiwinAthena> getAttachment(Object setting, Object value, String label) {
        Attachment<AttachmentRawDataDigiwinAthena> attachment = new Attachment<>();
        attachment.setEnable(false);
        attachment.setRequired(false);
        attachment.setTitle(label);
        attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
        attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
        if (value == null) {
            return attachment;
        }
        DesignerRawCard.Content.AttachmentObj attachmentObj = JsonUtil.objectToJavaObject(setting, new TypeReference<DesignerRawCard.Content.AttachmentObj>() {
        });
        if (attachmentObj == null) {
            attachmentObj = new DesignerRawCard.Content.AttachmentObj();
        }
        if (!StringUtils.hasLength(attachmentObj.getBuckets())) {
            attachmentObj.setBuckets("Athena");
        }

        AttachmentRawDataDigiwinAthena rawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
        rawDataDigiwinAthena.setBuckets(attachmentObj.getBuckets());
        if (attachmentObj.getRawData() != null) {
            rawDataDigiwinAthena.setDisableAam(attachmentObj.getRawData().getDisableAam());
            rawDataDigiwinAthena.setUploadCategory(attachmentObj.getRawData().getUploadCategory());
        }
        attachment.setRawData(rawDataDigiwinAthena);

        UiBotAttachment uiBotAttachment = new UiBotAttachment();
        if (value instanceof Map) {
            uiBotAttachment = JsonUtil.objectToJavaObject(value, new TypeReference<UiBotAttachment>() {
            });
        } else if (value instanceof List) {
            uiBotAttachment = JsonUtil.objectToJavaObject(value, new TypeReference<List<UiBotAttachment>>() {
            }).get(0);
        }
        for (UiBotAttachmentData uibotAttachData : uiBotAttachment.getData()) {
            AttachmentFile file = AttachmentFile.create(AppRequestContext.getContextEntity().getLocale(), uibotAttachData);
//            file.setShareUrl(AppContext.getApiUrlSetting().getDmcUrl() + "/api/dmc/v2/file/" + attachmentObj.getBuckets() + "/preview/" + file.getFileId());
            attachment.getFileList().add(file);
        }
        attachment.setIsFold(attachmentObj.getIsFold());
        attachment.setFoldNumber(attachmentObj.getFoldNumber());
        attachment.setDefaultExpand(attachmentObj.getDefaultExpand());
        return attachment;
    }

    //处理setting中的千分位,没有配置默认给false，
    private Boolean handleCardContentThousandthPlace(Object setting) {
        if (ObjectUtils.isEmpty(setting)) {
            return false;
        } else {
            DesignerRawCard.Content.NumericalObj numericalObj = JsonUtil.objectToJavaObject(setting, new TypeReference<DesignerRawCard.Content.NumericalObj>() {
            });
            if (numericalObj == null) {
                return false;
            } else {
                if (numericalObj.getThousandthPlace() != null) {
                    return numericalObj.getThousandthPlace();
                } else {
                    return false;
                }
            }
        }

    }

    public static String getLableValue(Object setting, String value) {
        if (ObjectUtils.isEmpty(setting)) {
            return value;
        }
        DesignerRawCard.Content.SingleTextObj singleTextObj = JsonUtil.objectToJavaObject(setting, new TypeReference<DesignerRawCard.Content.SingleTextObj>() {
        });
        if (singleTextObj == null) {
            return value;
        }
        if (!StringUtils.hasLength(value) || !StringUtils.hasLength(singleTextObj.getUnit())) {
            return value;
        }
        return value + " " + singleTextObj.getUnit();
    }

    private static String getNumericalValue(Object setting, String value) {
        if (ObjectUtils.isEmpty(setting)) {
            return value;
        }
        DesignerRawCard.Content.NumericalObj numericalObj = JsonUtil.objectToJavaObject(setting, new TypeReference<DesignerRawCard.Content.NumericalObj>() {
        });
        if (numericalObj == null) {
            return value;
        }
        if (!StringUtils.hasLength(value)) {
            return value;
        }
        if (ObjectUtils.isEmpty(numericalObj.getDecimalPoint())) {
            if (value.endsWith(".0")) {
                value = value.substring(0, value.length() - 2);
            } else {
                BigDecimal number = new BigDecimal(value);
                value = number.stripTrailingZeros().toPlainString();
            }
            return value + Optional.ofNullable(numericalObj.getUnit()).orElse("");
        }
        return String
                .format(MessageFormat
                                .format("%.{0}f",
                                        Optional.ofNullable(numericalObj.getDecimalPoint()).orElse(0)),
                        new BigDecimal(value))
                + " " + Optional.ofNullable(numericalObj.getUnit()).orElse("");
    }

    private static String getEnumValue(Object setting, String value) {
        if (ObjectUtils.isEmpty(setting)) {
            return value;
        }
        DesignerRawCard.Content.EnumObj enumObj = JsonUtil.objectToJavaObject(setting, new TypeReference<DesignerRawCard.Content.EnumObj>() {
        });
        if (enumObj == null) {
            return value;
        }
        if (!StringUtils.hasLength(value)) {
            return value;
        }
        List<DesignerRawCard.Content.EnumObj.Option> options = enumObj.getOptions();
        if (CollectionUtils.isEmpty(options)) {
            return value;
        }
        return options.stream()
                .filter(r -> value.equals(r.getId()))
                .findFirst()
                .map(DesignerRawCard.Content.EnumObj.Option::getText)
                .orElse("");
    }

    public static void getTagValue(Tag tag, Object setting, String value) {
        if (ObjectUtils.isEmpty(setting)) {
            return;
        }
        DesignerRawCard.TagSettingModel model = JsonUtil.objectToJavaObject(setting, new TypeReference<DesignerRawCard.TagSettingModel>() {
        });
        if (model == null) {
            return;
        }
        if (!StringUtils.hasLength(value)) {
            return;
        }
        List<DesignerRawCard.TagSettingModel.Option> options = model.getOptions();
        if (CollectionUtils.isEmpty(options)) {
            return;
        }
        String prefix = StringUtil.valueOf(model.getPrefix());
        for (DesignerRawCard.TagSettingModel.Option option : options) {
            String optionId = option.getId();
            if (Objects.equals(1, model.getMatchType())) {
                if (value.equalsIgnoreCase(optionId)) {
                    handleTagTextAndType(tag, value, option, model, prefix);
                }
            }
            if (Objects.equals(2, model.getMatchType())) {
                if (value.startsWith(optionId)) {
                    handleTagTextAndType(tag, value, option, model, prefix);
                }
            }
        }
    }

    private static void handleTagTextAndType(Tag tag, String value, DesignerRawCard.TagSettingModel.Option option, DesignerRawCard.TagSettingModel model, String prefix) {
        if (ObjectUtils.isEmpty(model.getSpliceSource())) {
            tag.setText(value);
        } else if (Objects.equals(1, model.getSpliceSource())) {
            tag.setText(prefix + value);
        } else if (Objects.equals(2, model.getSpliceSource())) {
            tag.setText(prefix + option.getText());
        }
        tag.setType(option.getStyleType());
        if (Tag.TagType.CUSTOM.getValue().equals(option.getStyleType())) {
            tag.setBgColor(option.getBgColor());
            tag.setBorderColor(option.getBorderColor());
            tag.setTextColor(option.getTextColor());
        }
    }

    public static Action buildSubTitleAction(DesignerRawCard designerRawCard, Map<String, Object> data, String dataId, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData, ComponentContext cmptContext) {
        UiBotAction subTitleButton = designerRawCard.getSubTitleButton();
        if (subTitleButton == null) {
            return null;
        }
        Button<UiBotAction> button = new Button<>();
        button.setSubmitAction(subTitleButton);
        // 按钮构建时需要重新定义mobilePageRawData类，来设置dataId,防止影响底部按钮的dataId值
        button.handleComponentParam(cmptContext, subTitleButton.getBtnId(), subTitleButton.getBtnId(), data, executeContext, mobilePageRawData.deepCopy().setDataId(dataId));
        return button.getAction();
    }

    public static TabItemCardDetailPage buildDetailPage(DesignerRawCard designerRawCard, Map<String, Object> data, String dataId, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData, ComponentContext cmptContext) {
        DesignerRawCard.DetailPage rawDetailPage = designerRawCard.getDetailPage();
        boolean isUtInspectionResultsRegistration = false;
        if ("task_info.inspection_parameter_info.parameter_name".equals(designerRawCard.getTitlePath())
                && !StringUtils.hasLength(rawDetailPage.getPageId())) {
            // 试验优测定制 - 待检测页签子条目详情页定制开发配置
            rawDetailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_INSPECTION_RESULTS_REGISTRATION_SUB_ITEM_CUSTOMIZE_DETAIL.name());
            isUtInspectionResultsRegistration = true;
        }
        if (rawDetailPage == null || !StringUtils.hasLength(rawDetailPage.getPageId())) {
            return null;
        }
        TabItemCardDetailPage detailPage = new TabItemCardDetailPage();
        detailPage.setDataId(dataId);
        // pageTitle 通过pageid走render后返回的名称为准
        detailPage.setPageTitle("");
        detailPage.setPageId(rawDetailPage.getPageId());
        Map<String, Object> rawData = new HashMap<>();
        if (CommonRawDataParentType.ALONE_LIST.getValue().equals(cmptContext.getCommonRawDataParentType())) {
            // 独立cardList下，移除RawData中提取cardList、card中的commonChildRawData部分
        }/* else if (CommonRawDataParentType.ALONE_CARD.getValue().equals(cmptContext.getCommonRawDataParentType())) {
            // wjw TODO: 2024/7/19 独立card下，移除card中的commonChildRawData部分 ---- 后期优化
        }*/ else {
            rawData.put("allRawMap", mobilePageRawData.getAllRawMap());
            rawData.put("rawMap", mobilePageRawData.getRawMap());
            rawData.put("rawDataType", mobilePageRawData.getRawDataType());
            rawData.put("baseEntryExtendedFields", mobilePageRawData.getExtendedFields());
            rawData.put("sourceCategory", mobilePageRawData.getSourceCategory());
            rawData.put("dataKeys", mobilePageRawData.getDataKeys());
            rawData.put("componentId", mobilePageRawData.getComponentId());
            // rawdata中存入代理token，此值在拦截器中处理
            rawData.put("digi-proxy-token", AppRequestContext.getContextEntity().getProxyToken());
            rawData.put("data", data);
            rawData.put("executeContext", executeContext);
        }
        if (IndexNavBar.notOptimizedRawData(cmptContext.getAppInfo())) {
            // wjw TODO: 2024/7/23 如果版本号小于1.50.0，走未优化rawData逻辑。几个迭代后移除此if逻辑
            rawData.put("allRawMap", mobilePageRawData.getAllRawMap());
            rawData.put("rawMap", mobilePageRawData.getRawMap());
            rawData.put("rawDataType", mobilePageRawData.getRawDataType());
            rawData.put("baseEntryExtendedFields", mobilePageRawData.getExtendedFields());
            rawData.put("sourceCategory", mobilePageRawData.getSourceCategory());
            rawData.put("dataKeys", mobilePageRawData.getDataKeys());
            rawData.put("componentId", mobilePageRawData.getComponentId());
            // rawdata中存入代理token，此值在拦截器中处理
            rawData.put("digi-proxy-token", AppRequestContext.getContextEntity().getProxyToken());
            rawData.put("data", data);
            rawData.put("executeContext", executeContext);
        }
        if (!CollectionUtils.isEmpty(rawDetailPage.getRawData())) {
            rawData.put("rawData", rawDetailPage.getRawData());
        }
        if (isUtInspectionResultsRegistration) {
            rawData.put("prePageId", AppRequestContext.getContextEntity().getPageId());
        }

        if (!CollectionUtils.isEmpty(rawDetailPage.getDesignExtendParameter())) {
            UiBotDesignParameter map = new UiBotDesignParameter();
            for (Map<String, String> stringObjectMap : rawDetailPage.getDesignExtendParameter()) {
                map.put(stringObjectMap.get("key"), stringObjectMap.get("value"));
            }
            detailPage.setDesignParameter(map);
        }
        if (ObjectUtils.isNotEmpty(data) && ObjectUtils.isNotEmpty(detailPage.getDesignParameter())) {
            if (!data.containsKey(PcUiBotConstants.MOBILE_CARD_ADD_DATA_TAG_KEY)) {
                detailPage.getDesignParameter().setDWIsRawData("true");
            }
        }
        detailPage.setRawData(rawData);
        if (ActionTypeEnum.OPEN_NEW_PAGE.getValue().equals(rawDetailPage.getType())) {
            // 开启页面
            detailPage.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        } else if (ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue().equals(rawDetailPage.getType())
                || ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM_SWIPER.getValue().equals(rawDetailPage.getType())) {
            // 开启弹窗
            if (CommonRawDataParentType.ALONE_CARD.getValue().equals(cmptContext.getCommonRawDataParentType())) {
                // 独立卡片
                detailPage.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
            } else {
                if ((rawDetailPage.getDetailPageSwiper() ||
                        Objects.equals(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM_SWIPER.getValue(), rawDetailPage.getType()))) {
                    Map<String, Map<String, Object>> pageLayoutInfo = cmptContext.getPageLayoutInfo();
                    if (ObjectUtils.isNotEmpty(pageLayoutInfo)) {
                        Map<String, Object> map = pageLayoutInfo.get(detailPage.getPageId());
                        if (isOpenNewDetailPage(map, executeContext)) {
                            Map<String, Object> detailPageRawdata = detailPage.getRawData();
                            //此处区分初次构建和开兄弟详情接口时候的构建
                            if (executeContext.getOpenDetailPage()) {
                                detailPage.setType(ActionTypeEnum.CUSTOMIZE_POPUP_DISPLAYS_PAGE.getValue());
                            } else {
                                detailPage.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM_SWIPER.getValue());
                                detailPageRawdata.put("rawDetailPage", rawDetailPage);
                                detailPageRawdata.put("pageLayoutInfo", pageLayoutInfo);
                                detailPageRawdata.put("data", data);
                            }
                            detailPage.setRawData(detailPageRawdata);
                        } else {
                            detailPage.setType(ActionTypeEnum.CUSTOMIZE_POPUP_DISPLAYS_PAGE.getValue());
                        }
                    } else {
                        detailPage.setType(ActionTypeEnum.CUSTOMIZE_POPUP_DISPLAYS_PAGE.getValue());
                    }
                } else {
                    detailPage.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                }
            }
        } else {
            detailPage.setType(ActionTypeEnum.CUSTOMIZE_POPUP_DISPLAYS_PAGE.getValue());
        }
        return detailPage;
    }

    public static List<BaseMobileComponentWrapper<BaseMobileComponent>> buildCardButton(DesignerRawCard designerRawCard) {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.setAlignmentType(ButtonGroupAlignEnum.RIGHT.getValue());
        List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> contentGroup = new ArrayList<>();
        buttonGroup.setContentGroup(contentGroup);
        BaseMobileComponentWrapper<BaseMobileComponent> componentWrapper =
                new BaseMobileComponentWrapper<>(buttonGroup, "DW_" + ButtonGroup.COMPONENT_TYPE);

        if (designerRawCard == null) {
            return Lists.newArrayList(componentWrapper);
        }
        List<UiBotAction> buttonList = designerRawCard.getButtonList();
        if (CollectionUtils.isEmpty(buttonList)) {
            return Lists.newArrayList(componentWrapper);
        }
        buttonList.forEach(item -> {
            if ("task_info.inspection_parameter_info.parameter_name".equals(designerRawCard.getTitlePath())) {
                // 试验优测定制 - 子条目详情页定制开发配置
                UiBotJumpAction jumpAction = item.getJumpAction();
                if (!StringUtils.hasLength(jumpAction.getJumpPageId())) {
                    // 试验优测-待检测按钮跳转定制页面
                    jumpAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_INSPECTION_RESULTS_REGISTRATION_SUB_ITEM_CUSTOMIZE_DETAIL.name());
                }
                jumpAction.setType(ActionTypeEnum.CUSTOMIZE_POPUP_DISPLAYS_PAGE.getValue());
                jumpAction.setDetailPageSwiper(true);
                item.setJumpAction(jumpAction);
                // 试验优测定制 - card组件中按钮名称从数据源值对应枚举值显示
                item.setTitle("UT_InspectionResultsRegistration_customize_card_button_name");
            }
            BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
            button.setSubmitAction(item);
            contentGroup.add(new BaseMobileComponentWrapper<>(button,
                    "DW_" + Button.COMPONENT_TYPE,
                    item.getBtnId()));
        });
        return Lists.newArrayList(componentWrapper);
    }

    /**
     * 处理乐普升 任务卡页面字段：
     * 报价类型：报价类型+销售订单 拼接处理
     * Ps：销售订单 sales_channel：1-外贸 2-内销
     *
     * @param data
     * @param tmActivityId
     * @param cardContent
     */
    private static void handleLePuShengQuotationType(Map<String, Object> data, String tmActivityId, CardContent cardContent, String locale
            , String schema) {
        if ("ca_lqs_athenaopt_task_0014".equalsIgnoreCase(tmActivityId) && "quotation_type".equalsIgnoreCase(schema)) {
            //销售渠道
            String salesChannel = StringUtil.valueOf(data.get("sales_channel"));
            if (StringUtil.isNotEmpty(salesChannel)) {
                if ("1".equals(salesChannel)) {
                    salesChannel = localeService.getLanguageValue(locale, "外贸");
                }
                if ("2".equals(salesChannel)) {
                    salesChannel = localeService.getLanguageValue(locale, "内销");
                }
            }
            cardContent.setValue(cardContent.getValue() + "   " + salesChannel);
        }
    }

    /**
     * 处理乐普升 任务卡页面字段：
     * 订单量：订单数量+订单单位名称 拼接处理
     * Ps：订单单位名称 order_unit_name
     *
     * @param data
     * @param tmActivityId
     * @param cardContent
     */
    private static void handleLePuShengOrderQuantity(Map<String, Object> data, String tmActivityId, CardContent cardContent, String schema) {
        if ("ca_lqs_athenaopt_task_0014".equalsIgnoreCase(tmActivityId)) {
            BigDecimal value = null;
            //销售渠道
            if ("order_quantity".equalsIgnoreCase(schema)) {
                cardContent.setValue(cardContent.getValue() + "   " + StringUtil.valueOf(data.get("order_unit_name")));
            }
            //折扣率
            if ("discount_rate".equalsIgnoreCase(schema)) {
                value = new BigDecimal(StringUtil.valueOf(data.get("discount_rate")));
                setCardContentValue(cardContent, value);
            }
            //净利率
            if ("discount_net_profit_rate".equalsIgnoreCase(schema)) {
                value = new BigDecimal(StringUtil.valueOf(data.get("discount_net_profit_rate")));
                // 将值乘以100，并设置小数点后保留的位数
                setCardContentValue(cardContent, value);
            }
        }
    }

    private static void setCardContentValue(CardContent cardContent, BigDecimal value) {
        // 将值乘以100，并设置小数点后保留的位数
        BigDecimal bigDecimal = value.multiply(new BigDecimal("100"))
                .setScale(6, RoundingMode.DOWN);
        String plainString = bigDecimal.stripTrailingZeros().toPlainString();
        cardContent.setValue(String.format("%s%%", plainString));
    }

    /**
     * 用于构建卡片本身跳转的Action
     *
     * @param designerRawCard
     * @param openCardDetailPage
     * @param openDetailType
     * @return
     */
    public static Action buildCardAction(Card.DesignerRawCard designerRawCard, Boolean openCardDetailPage, Integer openDetailType, TabItemCardDetailPage detailPage, ComponentContext cmptContext) {
        //卡片上没有编辑组件的时候才会构建
        if (BooleanUtils.isFalse(openCardDetailPage)) {
            return null;
        }
        Action cardAction = new Action();
        Map<String, Object> rawData = new HashMap<>();
        if (CommonRawDataParentType.ALONE_LIST.getValue().equals(cmptContext.getCommonRawDataParentType())) {
            // 独立cardList下，移除RawData中提取cardList、card中的commonChildRawData部分
            //卡片列表中的卡片点击事件(openDetailType=2)
            //卡片列表中卡片的普通点击事件用设计态的临时变量cardAction
            DesignerRawCard.DetailPage tempCardAction = designerRawCard.getCardAction();
            if (Objects.isNull(tempCardAction) || BooleanUtils.isNotFalse(tempCardAction.getDetailPageSwiper())
                    || ObjectUtils.isEmpty(tempCardAction.getPageId())) {
                return null;
            }
            cardAction.setJumpPageId(tempCardAction.getPageId());
            cardAction.setType(tempCardAction.getType());
        } else {
            //单独卡片没有兄弟详情，默认都是cardAction点击事件
            //因卡片没有临时变量cardAction,所以取已经构建好的detailPage的内容
            if (Objects.isNull(detailPage)) {
                return null;
            }
            cardAction.setJumpPageId(detailPage.getPageId());
            cardAction.setType(detailPage.getType());
        }
        if (detailPage != null) {
            //卡片列表的rawData取父级的
            cardAction.setRawData(detailPage.getRawData());
        }
        return cardAction;
    }

    //判断是否开卡片详情
    public static Boolean buildOpenCardDetailPage(Card.DesignerRawCard designerRawCard, TabItemCardDetailPage detailPage) {
        if (Objects.isNull(detailPage)) {
            return false;
        }
        List<Card.DesignerRawCard.Content> contentList = designerRawCard.getContent();
        if (CollectionUtils.isEmpty(contentList)) {
            return false;
        }
        //判断卡片上是否有编辑组件
        return contentList.stream()
                .filter(content -> !"TAG".equals(content.getType()) && !"DW_SHOW_PICTURE".equals(content.getType()))
                .noneMatch(content -> BooleanUtils.isTrue(content.getEditable()));
    }

}