package com.digiwin.mobile.mobileuibot.core.component.card.card;

import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawDataDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.progressbar.ProgressBar;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 标准卡片组件概要字段
 *
 * @author zhangjj
 * @date 2022/12/12 15:25
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CardContent extends BaseMobileComponent {
    private static final long serialVersionUID = -6329394834935508586L;
    public static final String COMPONENT_TYPE = "CARD_CONTENT";

    private String label;
    private String value;
    /**
     * value显示类型 0为...显示；1位换行
     */
    private Integer valueStyleType = 0;
    private String schema;
    private String placeholder;
    /**
     * 类型。非必填
     * 可选类型：PHONE：电话类型, PRICE：价格, TEXT：文本
     */
    private String type;
    private Boolean required;
    private String unitName;

    private Boolean isChangeValue;

    private Boolean hiddenLabel;

    /**
     * 数量提示
     */
    private String unitPlaceholder;
    /**
     * 附件
     */
    private Attachment<AttachmentRawDataDigiwinAthena> file;

    /**
     * 图片
     */
    private Picture picture;

    /**
     * 新原值显示
     */
    private NewOldValueObj newOldValue;

    /**
     * 多内容拼接
     */
    private MultiValueObj multiValue;
    /**
     * 卡片label最长显示字数
     */
    private Integer labelMaxLength = 6;

    //是否展示千分位,展示为true，不展示为fasle
    private Boolean thousandthPlace;

    /**
     * 进度条
     */
    private ProgressBar progressBar;


    public CardContent(String label, String value) {
        this.label = label;
        this.value = value;
    }

    public CardContent(String label, Attachment file) {
        this.label = label;
        this.file = file;
    }

    public CardContent(String label, Picture picture) {
        this.label = label;
        this.picture = picture;
    }

    public CardContent(String label, String value, Integer valueStyleType) {
        this.label = label;
        this.value = value;
        this.valueStyleType = valueStyleType;
    }

    public CardContent(String label, String value, String schema, Integer valueStyleType) {
        this.label = label;
        this.value = value;
        this.schema = schema;
        this.valueStyleType = valueStyleType;
    }

    public CardContent(String label, String value, Boolean hiddenLabel, Integer valueStyleType) {
        this.label = label;
        this.value = value;
        this.hiddenLabel = hiddenLabel;
        this.valueStyleType = valueStyleType;
    }

    public CardContent(String label, String value, Integer valueStyleType, String schema) {
        this.label = label;
        this.value = value;
        this.valueStyleType = valueStyleType;
        this.schema = schema;
    }

    public CardContent(String label, String value, String schema, String placeholder, String type, Boolean required) {
        this.label = label;
        this.value = value;
        this.schema = schema;
        this.placeholder = placeholder;
        this.type = type;
        this.required = required;
    }

    public CardContent(String label, String value, Integer valueStyleType, String schema, String placeholder, String type, Boolean required, String unitName, String unitPlaceholder) {
        this.label = label;
        this.value = value;
        this.valueStyleType = valueStyleType;
        this.schema = schema;
        this.placeholder = placeholder;
        this.type = type;
        this.required = required;
        this.unitName = unitName;
        this.unitPlaceholder = unitPlaceholder;
    }

    public static CardContent create(String label, Integer valueStyleType, String value) {
        CardContent cardContent = new CardContent();
        cardContent.setLabel(label);
        cardContent.setValueStyleType(valueStyleType);
        cardContent.setValue(value);
        return cardContent;
    }

    public static CardContent create(String label, Object value, Integer valueStyleType) {
        CardContent cardContent = new CardContent();
        cardContent.setLabel(label);
        cardContent.setValueStyleType(valueStyleType);
        cardContent.setValue(Objects.isNull(value) ? "-" : String.valueOf(value));
        return cardContent;
    }

    public static CardContent createMultiValue(List<CardContent> contentList, String separator) {
        CardContent cardContent = new CardContent();
        List<MultiValueObj.MultiValueObjData> multiValueObjDataList = contentList.stream().map(item -> {
            MultiValueObj.MultiValueObjData multiValueObjData = new MultiValueObj.MultiValueObjData();
            multiValueObjData.setSchema(item.getSchema());
            multiValueObjData.setLabel(item.getLabel());
            multiValueObjData.setValue(item.getValue());
            return multiValueObjData;
        }).collect(Collectors.toList());
        MultiValueObj multiValueObj = new MultiValueObj();
        multiValueObj.setData(multiValueObjDataList);
        multiValueObj.setSeparator(separator);
        cardContent.setMultiValue(multiValueObj);
        return cardContent;
    }

    @Override
    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    @Data
    static class NewOldValueObj {
        // 是否换行，true：是，false：否
        private Boolean isLineFeed = false;
        // [{"type":"新","borderColor":"42B983","bgColor":"42B983","textColor":"FFFFFF","value":""},{"type":"原","borderColor":"8E9CA8","bgColor":"FFFFFF","textColor":"8E9CA8","value":""}]
        private List<NewOldValueObjData> data;

        public NewOldValueObj() {
            data = new ArrayList<>();
            NewOldValueObjData newObjData = new NewOldValueObjData();
            newObjData.setType(LocaleUtil.getMobileTextByKey(AppRequestContext.getContextEntity().getLocale(), "新"));
            newObjData.setBorderColor("42B983");
            newObjData.setBgColor("42B983");
            newObjData.setTextColor("FFFFFF");
            newObjData.setThousandthPlace(false);
            NewOldValueObjData oldObjData = new NewOldValueObjData();
            oldObjData.setType(LocaleUtil.getMobileTextByKey(AppRequestContext.getContextEntity().getLocale(), "原"));
            oldObjData.setBorderColor("8E9CA8");
            oldObjData.setBgColor("FFFFFF");
            oldObjData.setTextColor("8E9CA8");
            oldObjData.setThousandthPlace(false);
            data.add(newObjData);
            data.add(oldObjData);
        }

        @Data
        public static
        class NewOldValueObjData {
            // "新"  "原"
            private String type;
            // 边框颜色
            private String borderColor;
            // 背景颜色
            private String bgColor;
            // 文字颜色
            private String textColor;
            // 文字内容
            private String value;
            //千分位,展示为true，不展示为fasle，默认为false
            private Boolean thousandthPlace;
        }

    }

    @Data
    public static class MultiValueObj {
        // 是否换行，默认false
        private Boolean isLineFeed = false;
        // 分隔符
        private String separator;
        private List<MultiValueObjData> data;

        @Data
        public static class MultiValueObjData {
            private String schema;
            private String fullPath;
            private String label;
            // 文字内容
            private String value;
            //是否展示千分位,展示为true，不展示为fasle
            private Boolean thousandthPlace;
        }
    }

}
