package com.digiwin.mobile.mobileuibot.core.component.card.cardgroup;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 卡片多选组件
 *
 * @author xujinc
 * @date 2023/06/08 15:22
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CardGroup extends BaseMobileComponent implements Serializable {

    private static final long serialVersionUID = -2713127920601409219L;
    public static final String COMPONENT_TYPE = "GROUP_CARD";

    private String title;

    private String subTitle;

    private String styleType;

    /**
     * MultiFunctionListChoiceEnum
     */
    private String choice;

    private Map<String, Object> rawData;

    private List<Card> content = new ArrayList<>();

    @Override
    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    /**
     * 设计态设计的card 结构
     */
    private Card cardListData;
    // 标题配置--属性只有type、setting
    private Card.DesignerRawCard.Content titleSetting;
    // 子标题配置--属性只有type、setting
    private Card.DesignerRawCard.Content subTitleSetting;

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data,
                                     PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        this.title = Card.getDisplayValue(this.titleSetting, StringUtil.valueOf(data.get(this.title)));
        this.subTitle = Card.getDisplayValue(this.subTitleSetting, StringUtil.valueOf(data.get(this.subTitle)));
        String nodePath = this.cardListData.getData().getNodePath();
        List<Map<String, Object>> dataList = UiBotDesignerRenderService.getDataByPath(data, nodePath, false);
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        this.content = new ArrayList<>();
        dataList.forEach(r -> {
            // 拷贝，更改内存地址
            Card card = JsonUtil.objectToJavaObject(this.cardListData, new TypeReference<Card>() {
            });
            card.handleComponentParam(cmptContext, null, null, r, executeContext, mobilePageRawData);
            this.content.add(card);
        });
        // clear
        this.cardListData = null;
        this.titleSetting = null;
        this.subTitleSetting = null;
    }
}
