package com.digiwin.mobile.mobileuibot.core.component.card.cardone;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapperJsonDeserializer;
import com.digiwin.mobile.mobileuibot.core.component.card.Postmark;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CardOne
 * @Author: Zaregoto
 * @Date: 2021/5/20 11:48
 */
@Data
public class CardOne extends BaseMobileComponent implements Serializable {
    private static final long serialVersionUID = 5892722165881710197L;
    public static final String COMPONENT_TYPE = "CARD_ONE";

    @JsonDeserialize(contentUsing = BaseMobileComponentWrapperJsonDeserializer.class)
    private List<BaseMobileComponentWrapper<BaseMobileComponent>> content = new ArrayList<>(5);
    @JsonDeserialize(contentUsing = BaseMobileComponentWrapperJsonDeserializer.class)
    private List<BaseMobileComponentWrapper<BaseMobileComponent>> hideContent = new ArrayList<>(20);
    private CardOneTitle title;
    private Postmark postmark;

    public static CardOne createEmpty() {
        return new CardOne();
    }

    void addContent(BaseMobileComponentWrapper<BaseMobileComponent> compContent) {
        if (null != compContent) {
            this.content.add(compContent);
        }
    }

    void addHideContent(BaseMobileComponentWrapper<BaseMobileComponent> compContent) {
        if (null != compContent) {
            this.hideContent.add(compContent);
        }
    }

    @Override
    public String returnComponentType() {
        return CardOne.COMPONENT_TYPE;
    }
}
