package com.digiwin.mobile.mobileuibot.core.component.card.cardone;


import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinitionCodeEnum;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.*;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.AttachmentViewTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.field.analyzer.LabelFieldAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayoutField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CardOneBizApprovalBuilder
 * @Author: Zaregoto
 * @Date: 2021/5/20 17:58
 */
@Component("cardOneBizApprovalBuilder")
public class CardOneBizApprovalBuilder implements CardOneBuilder {

    private static final Logger logger = LoggerFactory.getLogger(CardOneBizApprovalBuilder.class);

    @Autowired
    private LabelFieldAnalyzer labelFieldAnalyzer;

    /**
     * 移动端layout与PC端layout的对应关系
     * key-app端
     * value-pc端
     */
    private final Map<String, String> componentMap;

    @Autowired
    private ColumnTagService columnTagService;

    public CardOneBizApprovalBuilder() {
        this.componentMap = new HashMap<>();
        componentMap.put(this.getMobileComponentType(), "APPROVAL_DESCRIPTION");
    }

    @Override
    public CardOne build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                         Class<CardOne> clazz, Object... args) {
        String locale = apiRequest.getLocale();

        CardOne cardOne = new CardOne();
        CardOneTitle<Map<String, Object>> cardOneTitle = new CardOneTitle<>();
        if (pcUiBotModel.getPageData() == null || pcUiBotModel.getPageData().size() == 0) {
            return cardOne;
        }
        cardOne.setTitle(cardOneTitle);

        //erp签核
        Optional<UiBotLayout> splitLayoutOptional = pcUiBotModel.getLayout().stream().filter(layout -> "SPLIT_LAYOUT".equalsIgnoreCase(layout.getType())).findFirst();
        //采购签核、erp签核采购单
        Optional<UiBotLayout> formListOptional = pcUiBotModel.getLayout().stream().filter(layout -> "FORM_LIST".equalsIgnoreCase(layout.getType())).findFirst();
        if (!splitLayoutOptional.isPresent() && !formListOptional.isPresent()) {
            //老的采购签核单头处理逻辑
            handleOldData(pcUiBotModel, cardOne);
            return cardOne;
        }
        List<String> parentLayoutTypeList = new ArrayList<>();
        parentLayoutTypeList.add("SPLIT_LAYOUT");
        parentLayoutTypeList.add("FORM_LIST");
        List<String> targetLayoutTypeList = new ArrayList<>();
        targetLayoutTypeList.add("LABEL");
        targetLayoutTypeList.add("AMOUNT_INPUT");
        targetLayoutTypeList.add("INPUT");
        targetLayoutTypeList.add("OPERATION_EDITOR");
        targetLayoutTypeList.add("TEXTAREA");
        // 附件
        targetLayoutTypeList.add("FORM_UPLOAD");
        targetLayoutTypeList.add("DATEPICKER");
        UiBotModel uiBotModel = pcUiBotModel.searchPcTargetModel(targetLayoutTypeList, parentLayoutTypeList, true);
        //把TABLE内的统计数据放到单头 by zhangjj 20220819
        addTableSum(uiBotModel, pcUiBotModel);
        List<UiBotLayout> fieldLayoutList = uiBotModel.getLayout();
        if (fieldLayoutList.isEmpty()) {
            return cardOne;
        }
        List<ColumnTag> columnTagList = this.columnTagService.listColumnTagsByPath(uiBotModel.getParentSchema());
        List<ColumnTag> importantColumnTags = columnTagList.stream().filter(
                ct -> ColumnTagDefinitionCodeEnum.DISPLAY_IMPORTANT.getCode()
                        .equalsIgnoreCase(ct.getTagDefinition().getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());

        //重要字段（web端可能不设定重要字段，所以可能为空）
        List<BaseMobileComponentWrapper<BaseMobileComponent>> importantFieldList = new ArrayList<>();
        //不重要字段
        List<BaseMobileComponentWrapper<BaseMobileComponent>> unImportantFieldList = new ArrayList<>();
        fieldLayoutList.stream().forEach(fieldLayout -> {
            if ("FORM_UPLOAD".equals(fieldLayout.getType())) {
                // 附件
                Object valueObj = uiBotModel.getPageData().get(fieldLayout.getSchema());
                if (null != valueObj) {
                    Map<String, Object> map = JsonUtil.objectToJavaObject(valueObj, Map.class);
                    List<Map<String, Object>> dataList = (List<Map<String, Object>>) map.get("data");
                    if (!CollectionUtils.isEmpty(dataList)) {
                        Attachment attachment = new Attachment();
                        BaseMobileComponentWrapper<BaseMobileComponent> componentWrapper =
                                new BaseMobileComponentWrapper<>(attachment, Attachment.COMPONENT_TYPE, fieldLayout.getSchema());

                        attachment.setTitle(fieldLayout.getHeaderName());
                        attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
                        attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
                        List<AttachmentFile> fileList = dataList.stream().map(data -> {
                            // 这边变动，需要考虑 UiBotModelBuildMyTaskDetailStrategy 344行 同步处理
                            AttachmentFile file = new AttachmentFile();
                            file.setFileId((String) data.get("id"));
                            if (data.get("size") instanceof Double) {
                                Double size = (Double) data.get("size");
                                file.setFileSize(size.longValue());
                            } else if (data.get("size") instanceof Long) {
                                file.setFileSize((Long) data.get("size"));
                            } else if (data.get("size") instanceof String) {
                                file.setFileSize(Long.parseLong((String) data.get("size")));
                            }
                            file.setUploader((String) data.get("upload_user_name"));
                            file.setFileName((String) data.get("name"));
                            String createDate = data.get("create_date") == null ? "" : String.valueOf(data.get("create_date"));
                            if (StringUtils.hasLength(createDate)) {
                                createDate = createDate.replaceAll("/", "-");
                            }
                            file.setUploadTime(createDate);
                            file.setFileExtension(AttachmentUtil.getAttachmentFileSuffix((String) data.get("name")));

                            file.setViewable(true);
                            JSONObject attribute = fieldLayout.getAttribute();
                            String type = attribute.getString("type");
                            if (AttachmentViewTypeEnum.OUTER.name().equals(type)) {
                                file.setShareUrl((String) data.get("url"));
                            } else if (AttachmentViewTypeEnum.ERP.name().equals(type)) {
                                file.setViewable(false);
                            }
                            return file;
                        }).collect(Collectors.toList());
                        attachment.setFileList(fileList);

                        if (fieldLayout.getImportant()) {
                            importantFieldList.add(componentWrapper);
                        } else {
                            unImportantFieldList.add(componentWrapper);
                        }
                    }
                }
            } else {
                String value = "";
                if (!CollectionUtils.isEmpty(fieldLayout.getFields())) {
                    //兼容一个字段的value值由两个字段拼接的情况 by zhangjj 20220819
                    List<UiBotLayoutField> fields = fieldLayout.getFields();
//                AtomicReference<String> valueAtomic = new AtomicReference<>("");
                    AtomicReference<String> valueAtomic = new AtomicReference<>("");
                    fields.forEach(field -> {
                        if (field.getShow()) {
                            Object valueObj = uiBotModel.getPageData().get(field.getSchema());
                            if (valueObj != null) {
                                String fieldValue = String.valueOf(valueObj);
                                valueAtomic.updateAndGet(v -> v + fieldValue + "-");
                            }
                        }
                    });
                    value = valueAtomic.get();
                    if (StringUtils.hasLength(value)) {
                        value = value.substring(0, value.length() - 1);
                    }
                } else {
                    Object valueObj = uiBotModel.getPageData().get(fieldLayout.getSchema());
                    if (valueObj != null) {
                        value = String.valueOf(valueObj);
                    }
                }

                //LABEL、AMOUNT_INPUT转为普通文本字段
                if (StringUtils.hasLength(value)) {
                    CardOneField field = CardOneField.create(fieldLayout.getHeaderName(), fieldLayout.getType(),
                            value, FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue());
                    BaseMobileComponentWrapper<BaseMobileComponent> componentWrapper =
                            new BaseMobileComponentWrapper<>(field, Field.COMPONENT_TYPE, fieldLayout.getSchema());
                    field.setSchema(fieldLayout.getSchema());
                    if (uiBotModel.getPageData().get("__SUPPLIER_FULL_NAME") != null && "SUPPLIER_FULL_NAME".equals(fieldLayout.getSchema())) {
                        String supplierNameType = uiBotModel.getPageData().get("__SUPPLIER_FULL_NAME").toString();
                        if ("1".equalsIgnoreCase(supplierNameType)) {
                            Tag tag = Tag.createNewHintStateTag(LocaleUtil.getMobileTextByKey(locale, "新"));
                            field.addTag(tag);
                        }
                    }
                    if (fieldLayout.getImportant()) {
                        importantFieldList.add(componentWrapper);
                    } else {
                        unImportantFieldList.add(componentWrapper);
                    }
                }
            }
        });
        List<BaseMobileComponentWrapper<BaseMobileComponent>> fieldList = new ArrayList<>();
        fieldList.addAll(importantFieldList);
        fieldList.addAll(unImportantFieldList);
        importantColumnTags.forEach(columnTag -> {
            fieldList.forEach(field -> {
                if (columnTag.getSchema().equals(field.getSchema())) {
                    cardOne.addContent(field);
                    importantFieldList.remove(field);
                    unImportantFieldList.remove(field);
                }
            });
        });
        //展示四个字段，其他字段折叠，优先展示重要字段
        for (BaseMobileComponentWrapper<BaseMobileComponent> field : importantFieldList) {
            if (cardOne.getContent().size() < 4) {
                cardOne.addContent(field);
            } else {
                cardOne.addHideContent(field);
            }
        }
        for (BaseMobileComponentWrapper<BaseMobileComponent> field : unImportantFieldList) {
            if (cardOne.getContent().size() < 4) {
                cardOne.addContent(field);
            } else {
                cardOne.addHideContent(field);
            }
        }
        return cardOne;
    }

    /**
     * 把TABLE内的统计数据放到单头
     *
     * @param uiBotModel
     * @param pcUiBotModel
     */
    private void addTableSum(UiBotModel uiBotModel, UiBotModel pcUiBotModel) {
        List<String> parentLayoutTypeList = new ArrayList<>();
        List<String> targetLayoutTypeList = new ArrayList<>();
        targetLayoutTypeList.add("ATHENA_TABLE");
        UiBotModel tableUiBotModel = pcUiBotModel.searchPcTargetModel(targetLayoutTypeList, parentLayoutTypeList, true);
        if (CollectionUtils.isEmpty(tableUiBotModel.getLayout())) {
            return;
        }
        UiBotLayout tableLayout = tableUiBotModel.getLayout().get(0);
        Map<String, Object> setting = tableLayout.getSetting();
        if (CollectionUtils.isEmpty(setting) || setting.get("groupSummary") == null) {
            return;
        }
        Map groupSummary = (Map) setting.get("groupSummary");
        if (groupSummary.get("options") == null) {
            return;
        }
        List<Map<String, Object>> options = (List) groupSummary.get("options");
        if (CollectionUtils.isEmpty(options)) {
            return;
        }
        boolean hasParentSchema = StringUtils.hasLength(tableUiBotModel.getParentSchema());
        // 因为是TABLE类型的layout，所以数据一定是数组
        List<Map<String, Object>> mapList = (List<Map<String, Object>>) tableUiBotModel.getPageData()
                .getBizDataByPathAndSchema(tableLayout.getPath(), tableLayout.getSchema(), hasParentSchema);
        if (CollectionUtils.isEmpty(mapList)) {
            return;
        }
        for (Map<String, Object> option : options) {
            String schema = (String) option.get("schema");
            String mode = (String) option.get("mode");
            String title = (String) option.get("title");
            if (!"sum".equalsIgnoreCase(mode)) {
                //目前只支持求和
                continue;
            }
            UiBotLayout layout = new UiBotLayout();
            layout.setSchema(schema);
            layout.setHeaderName(title);
            uiBotModel.getLayout().add(layout);
            AtomicReference<Double> value = new AtomicReference<>(0.0);
            mapList.forEach(map -> {
                if (map.get(schema) instanceof Double) {
                    value.updateAndGet(v -> {
                        BigDecimal bigDecimalVal = new BigDecimal(String.valueOf(v)).add(new BigDecimal(String.valueOf(map.get(schema))));
                        return bigDecimalVal.doubleValue();
                    });
                }
            });
            uiBotModel.getPageData().put(schema, value.get());
        }
    }

    /**
     * 老版本采购签核处理方式
     *
     * @param pcUiBotModel
     * @param cardOne
     */
    private void handleOldData(UiBotModel pcUiBotModel, CardOne cardOne) {
        Optional<UiBotLayout> optLayout = pcUiBotModel.getLayout().stream().filter(
                layout -> layout.getType() != null &&
                        layout.getType().equalsIgnoreCase(this.componentMap.get(this.getMobileComponentType()))
        ).findFirst();
        if (!optLayout.isPresent()) {
            return;
        }

        UiBotLayout layout = optLayout.get();
        String schema = layout.getSchema();
        Map<String, Object> data = (Map<String, Object>) pcUiBotModel.getPageData().get(schema);
        if (null == data) {
            logger.debug("pagedata.{} is null, use constructed empty data", schema);
            data = Collections.emptyMap();
        }

        final Map<String, Object> tempData = data;
        layout.decomposeFieldsWithApprovalDescription(null).forEach(fieldLayout -> {
            String fieldType = fieldLayout.getType();
            String fieldValue = "";
            String fieldLabel = StringUtils.hasLength(fieldLayout.getTitle()) ? fieldLayout.getTitle() : fieldLayout.getHeaderName();
            // FIXME 应该用策略模式针对不同的fieldType处理
            fieldValue = this.labelFieldAnalyzer.analyze(
                    fieldLayout, (JSONObject) JSONObject.toJSON(tempData), pcUiBotModel.getPageData(), true);

            BaseMobileComponentWrapper<BaseMobileComponent> componentWrapper =
                    new BaseMobileComponentWrapper<>(Field.create(fieldLabel, fieldType, fieldValue), Field.COMPONENT_TYPE);
            if (fieldLayout.getImportant()) {
                cardOne.addContent(componentWrapper);
            } else {
                cardOne.addHideContent(componentWrapper);
            }
        });
    }
}
