package com.digiwin.mobile.mobileuibot.core.component.card.cardone;

import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * CardOne组件内field
 *
 * @author zhangjj
 * @date 2022/6/30 15:15
 */
@Data
public class CardOneField extends Field implements Serializable {
    private static final long serialVersionUID = 2411993641020983074L;

    /**
     * 放在value右边的标签
     */
    List<Tag> tags;

    public static CardOneField create(String label, String type, String value, Integer alignmentType) {
        CardOneField field = new CardOneField();
        field.setLabel(label);
        field.setType(type);
        field.setValue(value);
        field.setAlignmentType(alignmentType);
        return field;
    }

    public void addTag(Tag tag) {
        this.tags = new ArrayList<>();
        this.getTags().add(tag);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CardOneField that = (CardOneField) o;
        return Objects.equals(schema, that.schema);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.schema);
    }
}
