package com.digiwin.mobile.mobileuibot.core.component.card.statistic;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDataItem;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.statsindex.IndexRenderSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.statsindex.IndexSetting;
import lombok.AccessLevel;
import lombok.Data;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

/**
 * 统计指标卡组件
 *
 * @author wuyang
 */
@Data
public class StatisticCard extends BaseMobileComponent {

    private static final long serialVersionUID = -5989369735247963065L;
    public static final String COMPONENT_TYPE = "STATISTIC_CARD";

    /**
     * 标题
     */
    private String title;

    //数据提示信息
    private String dataTipMessage;

    /**
     * 描述
     */
    private String desc;
    /**
     * 指标数据
     */
    private List<StatisticCardData> data = new ArrayList<>(4);
    /**
     * 指标的数量
     */
    @Setter(AccessLevel.NONE)
    private Integer count = 0;

    /**
     * 增加指标卡中的数据项，并同步更新指标的数量
     *
     * @param statisticCardData
     */
    public void addStatisticCardData(StatisticCardData statisticCardData) {
        this.data.add(statisticCardData);
        this.count = this.data.size();
    }

    /**
     * 删除指标卡中的数据项，并同步更新指标的数量
     *
     * @param statisticCardData
     */
    public void removeStatisticCardData(StatisticCardData statisticCardData) {
        this.data.remove(statisticCardData);
        this.count = this.data.size();
    }

    public static StatisticCard create(String locale, AgileDataIntermediateDataItem statisticDataItem) {
        StatisticCard statisticCard = new StatisticCard();
        IndexRenderSetting indexRender = statisticDataItem.getMobileDSLIndexRender();
        if (indexRender != null) {
            if (StringUtils.isNotEmpty(indexRender.getIndexTitle())) {
                statisticCard.setTitle(indexRender.getIndexTitle().trim());
            }
            if (StringUtils.isNotEmpty(statisticDataItem.getDataTipMessage())) {
                statisticCard.setDataTipMessage(statisticDataItem.getDataTipMessage().trim());
            }
        }

        List<IndexSetting> indexSettings = Optional.ofNullable(statisticDataItem.getMobileDSLIndexRender())
                .map(IndexRenderSetting::getIndexSetting)
                .orElse(Collections.emptyList());
        if (CollectionUtils.isEmpty(indexSettings)) {
            return statisticCard;
        }

        indexSettings.forEach(indexSetting -> {
            statisticCard.addStatisticCardData(new StatisticCardData()
                            .setName(indexSetting.getActualTitle(statisticDataItem))
                            .setValue(indexSetting.getActualValue(statisticDataItem))
                            .setBusinessType(indexSetting.getBusinessType())
                            .setDescription(indexSetting.getDescription())
                            .setDecimal(indexSetting.getDecimal())
                            .setPercent(indexSetting.getPercent())
                            .setUnit(indexSetting.getUnit())
                            .setDecimalRule(indexSetting.getDecimalRule())
                            .setDimensionData(indexSetting.getDimensionData())
                            .setMeasurementData(indexSetting.getMeasurementData())
                    // TODO 预留数据项的点击事件
//                    .setAction(new Action<>())
            );
        });

        return statisticCard;
    }

    @Override
    public String returnComponentType() {
        return StatisticCard.COMPONENT_TYPE;
    }
}