package com.digiwin.mobile.mobileuibot.core.component.card.statistic;

import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataAnalysisData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableDecimalRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableUnit;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * 统计指标卡的数据
 *
 * @author wuyang
 */
@Data
@Accessors(chain = true)
public class StatisticCardData implements Serializable {
    private static final long serialVersionUID = -8030609882692641321L;

    /**
     * 指标名称
     */
    private String name;

    /**
     * 指标值
     */
    private String value;

    /**
     * 统计指标是否需要使用百分号，或千分位显示
     * 当使用百分号时，值为percent；
     * 当使用千分位时，值为thousand
     */
    private String percent;

    /**
     * 统计指标的显示精度
     */
    private Integer decimal;

    /**
     * 指标单位
     */
    private String businessType;

    /**
     * 数据计算逻辑说明
     */
    private String description;

    /**
     * 点击跳转事件
     */
    private Action action;

    /**
     * 统计图的图标样式
     */
    private StatisticStyle style = new StatisticStyle();

    /**
     * 舍入方式
     */
    private UiBotTableDecimalRule decimalRule;

    /**
     * 计算单位
     */
    private UiBotTableUnit unit;

    /**
     * 用户筛选维度条件
     */
    private List<AgileDataAnalysisData> dimensionData;

    /**
     * 用户筛选度量条件
     */
    private List<AgileDataAnalysisData> measurementData;
}