package com.digiwin.mobile.mobileuibot.core.component.chart;

import com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate.ChartCoordinate;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.Animation;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartseries.ChartSeries;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartseries.RectangleCoordinateChartData;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author wuyang
 * @desc 柱状图
 */
@Data
@Accessors(chain = true)
public class BarChart extends Chart<RectangleCoordinateChartData> {

    private static final long serialVersionUID = -2389235072890540236L;

    @Override
    public void initType() {
        this.type = ChartTypeEnum.BAR.getType();
    }

    @Override
    public BarChart setType(String type) {
        super.setType(type);
        return this;
    }

    @Override
    public BarChart setBasic(ChartBasic basic) {
        super.setBasic(basic);
        return this;
    }

    //    @Override
    public BarChart setCoordinate(ChartCoordinate coordinate) {
        super.setCoordinate(coordinate);
//        this.coordinate = coordinate;
        return this;
    }

    @Override
    public BarChart setSeries(List<ChartSeries<RectangleCoordinateChartData>> chartSeries) {
        super.setSeries(chartSeries);
        return this;
    }

    @Override
    public BarChart setTheme(String theme) {
        super.setTheme(theme);
        return this;
    }

    @Override
    public BarChart setAnimation(Animation animation) {
        super.setAnimation(animation);
        return this;
    }
}
