package com.digiwin.mobile.mobileuibot.core.component.chart;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate.ChartCoordinate;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate.ChartCoordinateJsonDeserializer;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.Animation;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartseries.ChartData;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartseries.ChartSeries;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author wuyang
 * @desc 图表抽象基类
 */
@Data
@Accessors(chain = true)
public abstract class Chart<T extends ChartData> extends BaseMobileComponent {
    private static final long serialVersionUID = 8008777825333665489L;

    public static final String COMPONENT_TYPE = "CHART";

    @Override
    public String returnComponentType() {
        return Chart.COMPONENT_TYPE;
    }

    /**
     * 图表类型（折线图(line)、柱状图(bar)、散点图(scatter)、饼图(pie)、混合图(mix)）
     *
     * @see ChartTypeEnum
     */
    protected String type;
    /**
     * 图表基础
     */
    protected ChartBasic basic;
    /**
     * 图表的坐标系
     */
    @JsonDeserialize(contentUsing = ChartCoordinateJsonDeserializer.class)
//    @JSONField(deserializeUsing = ChartCoordinateJsonDeserializer2.class)
    protected ChartCoordinate coordinate;
    /**
     * 数据系列
     */
    protected List<ChartSeries<T>> series;
    /**
     * 主题风格
     */
    protected String theme;

    /**
     * 图表动画配置
     */
    protected Animation animation;

    public Chart() {
        this.initType();
    }

    public void initType() {
    }

//    /**
//     * 当前图表是否基于直角坐标系
//     *
//     * @return
//     */
//    public boolean basedOnRectangleCoordinate() {
//        return null != this.coordinate &&
//                Objects.equals(this.coordinate.getCategory(), ChartCoordinateCategoryEnum.RECTANGLE.getValue());
//    }
//
//    /**
//     * 当前图表是否基于极坐标系
//     *
//     * @return
//     */
//    public boolean basedOnPolarCoordinate() {
//        return null != this.coordinate &&
//                Objects.equals(this.coordinate.getCategory(), ChartCoordinateCategoryEnum.POLAR.getValue());
//    }
//
//    /**
//     * 当前图表是否无坐标系
//     *
//     * @return
//     */
//    public boolean basedOnNoneCoordinate() {
//        return null != this.coordinate &&
//                Objects.equals(this.coordinate.getCategory(), ChartCoordinateCategoryEnum.NONE.getValue());
//    }
}