package com.digiwin.mobile.mobileuibot.core.component.chart;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.chartlegend.ChartLegend;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.chartlegend.ChartLegendData;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.charttitle.ChartTitle;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.charttitle.ChartTitleData;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.charttitle.ChartTitleText;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.charttooltip.ChartTooltip;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartstyle.ChartColorPalette;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDataItem;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartPointField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartValueField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.ChartRenderSetting;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * @author wuyang
 * @desc 图表基础区（除了绘图区的其他所有基础功能：标题、工具栏、图例）
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class ChartBasic implements Serializable {
    private static final long serialVersionUID = 7182486410493798422L;

    /**
     * 图表标题
     */
    private ChartTitle title;
    /**
     * 图表工具栏
     */
    private ChartTooltip tooltip;
    /**
     * 图表图例
     */
    private ChartLegend legend;

    //数据提示信息
    private String dataTipMessage;

    /**
     * 根据一个中间态DSL的数据描述，创建一个移动端图表组件的基础元素<br/>
     * 未来随着组件类挪入athenamobile-uibot-component模块，该方法要转到AgileDataIntermediateDataItem对象内
     *
     * @param intermediateDataItem
     * @return
     */
    public static ChartBasic buildChartBasic(AgileDataIntermediateDataItem intermediateDataItem) {
        ChartRenderSetting chartRenderSetting = intermediateDataItem.getChartRenderSetting();
        ChartTypeEnum chartTypeEnum = ChartTypeEnum.getEnumByValue(chartRenderSetting.getChartType());

        ChartTitle chartTitle = new ChartTitle();
        ChartTooltip chartTooltip = new ChartTooltip();
        ChartLegend chartLegend;

        // 图表标题
        List<ChartTitleData> titleDatas = chartTitle.getData();
        if (org.apache.commons.lang3.StringUtils.isNotBlank(intermediateDataItem.getShowName())) {
            titleDatas.add(new ChartTitleData().setTitle(new ChartTitleText().setText(intermediateDataItem.getShowName().trim())));
        }

        /**
         * 图表图例处理
         * 1. 饼图（数据是一维的情况）图例是按实际数据个数来的
         * 2. 非饼图（数据是大于一维的情况）图例是按统计字段个数来的。
         */
        if (ChartTypeEnum.PIE == chartTypeEnum) {
            chartLegend = buildPieChartLegend(intermediateDataItem, chartRenderSetting);
        } else if (ChartTypeEnum.LINE == chartTypeEnum || ChartTypeEnum.BAR == chartTypeEnum || ChartTypeEnum.LINE_BAR == chartTypeEnum || ChartTypeEnum.MIXED == chartTypeEnum) {
            chartLegend = buildRectangleCoordinateChartLegend(intermediateDataItem, chartRenderSetting, chartTypeEnum);
        } else {
            // TODO 其他类型图表还不支持，故不生成图例数据
            chartLegend = new ChartLegend();
        }

        // TODO 图表工具栏 留空，后续再看是否需要

        return new ChartBasic()
                .setTitle(chartTitle)
                .setTooltip(chartTooltip)
                .setLegend(chartLegend)
                .setDataTipMessage(intermediateDataItem.getDataTipMessage());
    }

    private static ChartLegend buildRectangleCoordinateChartLegend(AgileDataIntermediateDataItem intermediateDataItem,
                                                                   ChartRenderSetting chartRenderSetting, ChartTypeEnum chartTypeEnum) {
        List<AgileDataChartPointField> pointFields = chartRenderSetting.getPoints();
        List<AgileDataChartValueField> valueFields = chartRenderSetting.getValues();

        List<JSONObject> pageData = intermediateDataItem.getPageData();

        ChartLegend chartLegend = new ChartLegend();

        // FIXME 这里还没考虑堆叠的情况
        int colorIdx = 0;
        // 统计轴
        for (int i = 0; i < valueFields.size(); i++) {
            AgileDataChartValueField valueField = chartRenderSetting.getValues().get(i);
            String chartTypeSpecifiedInValueField = valueField.getChartType();

            ChartLegendData legendData = new ChartLegendData();
            legendData.setName(valueField.getTitle());
            legendData.setColor(ChartColorPalette.getColorFromCategoryPalette(colorIdx, valueFields.size()));
            legendData.setBusinessType(valueField.getBusinessType());
            legendData.setDescription(valueField.getDescription());
            legendData.setDecimalRule(valueField.getFormat().getDecimalRule());
            legendData.setPercent(valueField.getFormat().getPercent());
            legendData.setDecimal(valueField.getFormat().getDecimal());
            legendData.setUnit(valueField.getFormat().getUnit());
            colorIdx++;
            // 设置图例对应的图表类型，前端呈现时有不同图例形状（如柱状是矩形，折线是点+线）
            if (StringUtils.hasLength(chartTypeSpecifiedInValueField)) {
                ChartTypeEnum specifiedChartType = ChartTypeEnum.getEnumByValue(chartTypeSpecifiedInValueField);
                if (null != specifiedChartType) {
                    legendData.setChartType(specifiedChartType.getType());
                }
            } else {
                legendData.setChartType(chartTypeEnum.getType());
            }
            chartLegend.getData().add(legendData);
        }
        return chartLegend;
    }

    /**
     * 创建饼图的图例
     *
     * @param intermediateDataItem
     * @param chartRenderSetting
     */
    private static ChartLegend buildPieChartLegend(AgileDataIntermediateDataItem intermediateDataItem, ChartRenderSetting chartRenderSetting) {
        ChartLegend chartLegend = new ChartLegend();
        List<JSONObject> pageData = intermediateDataItem.getPageData();
        AgileDataChartValueField agileDataChartValueField = null;
        if (!CollectionUtils.isEmpty(chartRenderSetting.getValues())) {
            agileDataChartValueField = chartRenderSetting.getValues().get(0);
        }
        for (int i = 0; i < chartRenderSetting.getPoints().size(); i++) {
            AgileDataChartPointField pointField = chartRenderSetting.getPoints().get(i);
            for (int j = 0; j < pageData.size(); j++) {
                JSONObject pageDatum = pageData.get(j);
                ChartLegendData legendData = new ChartLegendData();
                legendData.setName(pageDatum.getString(pointField.getName()));
                legendData.setColor(ChartColorPalette.getColorFromCategoryPalette(j, pageData.size()));
                if (null != agileDataChartValueField) {
                    legendData.setBusinessType(agileDataChartValueField.getBusinessType());
                    legendData.setDescription(agileDataChartValueField.getDescription());
                    legendData.setDecimalRule(agileDataChartValueField.getFormat().getDecimalRule());
                    legendData.setUnit(agileDataChartValueField.getFormat().getUnit());
                    legendData.setPercent(agileDataChartValueField.getFormat().getPercent());
                    legendData.setDecimal(agileDataChartValueField.getFormat().getDecimal());
                }
                chartLegend.getData().add(legendData);
            }
        }

        return chartLegend;
    }

}
