package com.digiwin.mobile.mobileuibot.core.component.chart;

import lombok.Getter;

import java.util.Objects;

/**
 * @author wuyang
 * @desc 表格类型
 */

@Getter
public enum ChartTypeEnum {
    /**
     * 折线图
     * 仅支持单Y轴不限数量的折线图，双Y轴需换用mixed类型
     */
    LINE("line"),
    /**
     * 柱状图
     * 仅支持单Y轴不限数量的柱状图，双Y轴需换用mixed类型
     */
    BAR("bar"),
    /**
     * 横条图
     */
    LINE_BAR("line-bar"),
    /**
     * 散点图
     */
    SCATTER("scatter"),
    /**
     * 气泡图
     */
    BUBBLE("bubble"),
    /**
     * 饼图
     */
    PIE("pie"),
    /**
     * 混合图
     * 表示两种不同度量字段的混合呈现，呈现方式支持相同或不同
     * 举例
     * 1. 单Y轴，两根柱状；
     * 2. 单Y轴，两根折线；
     * 3. 双Y轴，两根柱状；
     * 4. 双Y轴，两根折线
     * 5. 双Y轴，一折一柱；
     * 6. 双Y轴，一折两柱；
     * 7. 双Y轴，两折一柱
     */
    MIXED("mixed"),
    ;

    private String type;

    ChartTypeEnum(String type) {
        this.type = type;
    }

    public static ChartTypeEnum getEnumByValue(String type) {
        for (ChartTypeEnum testedEnum : ChartTypeEnum.values()) {
            if (Objects.equals(testedEnum.getType(), type)) {
                return testedEnum;
            }
        }
        return null;
    }

}