package com.digiwin.mobile.mobileuibot.core.component.chart;

import com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate.ChartCoordinate;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.Animation;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartseries.ChartSeries;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartseries.RectangleCoordinateChartData;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @desc 横条图
 */
@Data
@Accessors(chain = true)
public class LineBarChart extends Chart<RectangleCoordinateChartData> {

    private static final long serialVersionUID = -2389235072890540236L;

    @Override
    public void initType() {
        this.type = ChartTypeEnum.LINE_BAR.getType();
    }

    @Override
    public LineBarChart setType(String type) {
        super.setType(type);
        return this;
    }

    @Override
    public LineBarChart setBasic(ChartBasic basic) {
        super.setBasic(basic);
        return this;
    }

    //    @Override
    public LineBarChart setCoordinate(ChartCoordinate coordinate) {
        super.setCoordinate(coordinate);
//        this.coordinate = coordinate;
        return this;
    }

    @Override
    public LineBarChart setSeries(List<ChartSeries<RectangleCoordinateChartData>> chartSeries) {
        super.setSeries(chartSeries);
        return this;
    }

    @Override
    public LineBarChart setTheme(String theme) {
        super.setTheme(theme);
        return this;
    }

    @Override
    public LineBarChart setAnimation(Animation animation) {
        super.setAnimation(animation);
        return this;
    }
}