package com.digiwin.mobile.mobileuibot.core.component.chart;

import com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate.ChartCoordinate;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.Animation;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartseries.ChartSeries;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartseries.RectangleCoordinateChartData;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author wuyang
 * @desc 折线图
 */
@Data
@Accessors(chain = true)
public class LineChart extends Chart<RectangleCoordinateChartData> {
    private static final long serialVersionUID = 7921100958191509566L;

    @Override
    public void initType() {
        this.type = ChartTypeEnum.LINE.getType();
    }

    @Override
    public LineChart setType(String type) {
        super.setType(type);
        return this;
    }

    @Override
    public LineChart setBasic(ChartBasic basic) {
        super.setBasic(basic);
        return this;
    }

    //    @Override
    public LineChart setCoordinate(ChartCoordinate coordinate) {
        super.setCoordinate(coordinate);
//        this.coordinate = coordinate;
        return this;
    }

    @Override
    public LineChart setSeries(List<ChartSeries<RectangleCoordinateChartData>> chartSeries) {
        super.setSeries(chartSeries);
        return this;
    }

    @Override
    public LineChart setTheme(String theme) {
        super.setTheme(theme);
        return this;
    }

    @Override
    public LineChart setAnimation(Animation animation) {
        super.setAnimation(animation);
        return this;
    }
}
