package com.digiwin.mobile.mobileuibot.core.component.chart;

import com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate.ChartCoordinate;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.Animation;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartseries.ChartSeries;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartseries.RectangleCoordinateChartData;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>功能描述：折柱混合图</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MixedChart
 * @Author: Zaregoto
 * @Date: 2023/12/6 10:39
 */
@Data
@Accessors(chain = true)
public class MixedChart extends Chart<RectangleCoordinateChartData> {

    private static final long serialVersionUID = -2389235072890540236L;

    @Override
    public void initType() {
        this.type = ChartTypeEnum.MIXED.getType();
    }

    @Override
    public MixedChart setType(String type) {
        super.setType(type);
        return this;
    }

    @Override
    public MixedChart setBasic(ChartBasic basic) {
        super.setBasic(basic);
        return this;
    }

    //    @Override
    public MixedChart setCoordinate(ChartCoordinate coordinate) {
        super.setCoordinate(coordinate);
//        this.coordinate = coordinate;
        return this;
    }

    @Override
    public MixedChart setSeries(List<ChartSeries<RectangleCoordinateChartData>> chartSeries) {
        super.setSeries(chartSeries);
        return this;
    }

    @Override
    public MixedChart setTheme(String theme) {
        super.setTheme(theme);
        return this;
    }

    @Override
    public MixedChart setAnimation(Animation animation) {
        super.setAnimation(animation);
        return this;
    }
}
