package com.digiwin.mobile.mobileuibot.core.component.chart;

import com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate.ChartCoordinate;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartseries.PieChartData;
import lombok.Data;

/**
 * @author wuyang
 * @desc 饼图
 */
@Data
public class PieChart extends Chart<PieChartData> {

    private static final long serialVersionUID = -7659899844504714447L;

    /**
     * 环形图内径
     */
    public static final Double CIRCLE_PIE_CHART_INNER_RADIUS = 1.0;

    /**
     * 饼图内部圈的半径，默认为0
     */
    private Double innerRadius = 0.0;
    /**
     * 饼图外部圈的半径
     */
//    private Double outerRadius;
    /**
     * 饼图初始角度(支持0~360，超过需要重新计算)
     */
    private Double startAngle = 90.0;

    @Override
    public void initType() {
        this.type = ChartTypeEnum.PIE.getType();
    }

    //    @Override
    public PieChart setCoordinate(ChartCoordinate coordinate) {
        super.setCoordinate(coordinate);
//        this.coordinate = coordinate;
        return this;
    }

    /**
     * 设置饼图的内半径。
     * 若设置成0，则APP前端会认为是饼图；<br/>
     * 若设置成大于0的值，则APP前端会认为是环形图，并依UI规范及设备的屏幕尺寸，计算实际内半径和外半径。故后端给的值无作用，内部自动设置成1；<br/>
     * 若设置成小于0的值，则会自动处理成0<br/>
     */
    public void setInnerRadius(Double innerRadius) {
        if (innerRadius <= 0.0) {
            this.innerRadius = 0.0;
        } else {
            this.innerRadius = 1.0;
        }
    }
}
