package com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate;

import java.util.Objects;

/**
 * <p>功能描述：图表坐标系类别枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ChartCoordinateCategoryEnum
 * @Author: zaregoto
 * @Date: 2023/11/22 15:34
 */
public enum ChartCoordinateCategoryEnum {
    RECTANGLE("rectangle"),
    POLAR("polar"),
    NONE("none"),

    ;

    private final String value;

    ChartCoordinateCategoryEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static ChartCoordinateCategoryEnum getEnumByValue(String value) {
        for (ChartCoordinateCategoryEnum testedEnum : ChartCoordinateCategoryEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
