package com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;

/**
 * <p>功能描述：图表坐标抽象类的反序列化处理器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ChartCoordinateJsonDeserializer
 * @Author: zaregoto
 * @Date: 2023/11/30 15:01
 */
@Slf4j
public class ChartCoordinateJsonDeserializer extends JsonDeserializer<ChartCoordinate> {

    @Override
    public ChartCoordinate deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        log.debug("ChartCoordinateJsonDeserializer activated!!!");
        JsonNode node = jsonParser.getCodec().readTree(jsonParser);
        JsonNode categoryNode = node.get("category");

        ChartCoordinate resultCoordinate = null;
        if (categoryNode instanceof TextNode) {
            String coordinateCategory = categoryNode.asText();
            ChartCoordinateCategoryEnum coordinateCategoryEnum = ChartCoordinateCategoryEnum.getEnumByValue(coordinateCategory);
            switch (coordinateCategoryEnum) {
                case RECTANGLE:
                    resultCoordinate = JsonUtil.jsonStringToObject(node.toString(), RectangleCoordinate.class);
                    break;
                case POLAR:
                    resultCoordinate = JsonUtil.jsonStringToObject(node.toString(), PolarCoordinate.class);
                    break;
                case NONE:
                    resultCoordinate = JsonUtil.jsonStringToObject(node.toString(), NoneCoordinate.class);
                    break;
                default:
                    resultCoordinate = JsonUtil.jsonStringToObject(node.toString(), NoneCoordinate.class);
                    break;
            }
        }
        if (null == resultCoordinate) {
            resultCoordinate = new NoneCoordinate();
        }
        return resultCoordinate;
    }
}
