package com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate;

import com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate.axis.AngleAxis;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate.axis.Axis;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate.axis.RadiusAxis;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate.axis.RectangleAxis;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author wuyang
 * @desc 极坐标(主要作用于散点图和折线图)
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PolarCoordinate extends ChartCoordinate {

    private static final long serialVersionUID = 8758247785920482614L;

    /**
     * 半径轴
     */
    private RadiusAxis radius;
    /**
     * 角度轴
     */
    private AngleAxis angle;

    @Override
    protected void initCategory() {
        this.category = ChartCoordinateCategoryEnum.POLAR.getValue();
    }

    @Override
    public void addXAxis(RectangleAxis axis) {
        return;
    }

    @Override
    public void addMultipleXAxis(List<RectangleAxis> axes) {
        return;
    }

    @Override
    public void addYAxis(RectangleAxis axis) {
        return;
    }

    @Override
    public void addMultipleYAxis(List<RectangleAxis> axes) {
        return;
    }

    @Override
    public void setRadiusAxis(Axis axis) {
        if (axis instanceof RadiusAxis) {
            this.radius = (RadiusAxis) axis;
        }
    }

    @Override
    public void setAngleAxis(Axis axis) {
        if (axis instanceof AngleAxis) {
            this.angle = (AngleAxis) axis;
        }
    }
}
