package com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate.axis.Axis;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate.axis.RectangleAxis;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

/**
 * @author wuyang
 * @desc 直角坐标系
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RectangleCoordinate extends ChartCoordinate {

    private static final long serialVersionUID = 5743744453363129264L;

    /**
     * X轴坐标系列
     */
    @JSONField(name = "xAxes")
    @JsonProperty(value = "xAxes")
    private List<RectangleAxis> xAxes = new ArrayList<>(1);

    /**
     * Y轴坐标系列
     */
    @JSONField(name = "yAxes")
    @JsonProperty(value = "yAxes")
    private List<RectangleAxis> yAxes = new ArrayList<>(2);

    @Override
    protected void initCategory() {
        this.category = ChartCoordinateCategoryEnum.RECTANGLE.getValue();
    }

    @Override
    public void addXAxis(RectangleAxis axis) {
        this.xAxes.add(axis);
    }

    @Override
    public void addMultipleXAxis(List<RectangleAxis> axes) {
        this.xAxes.addAll(axes);
    }

    @Override
    public void addYAxis(RectangleAxis axis) {
        this.yAxes.add(axis);
    }

    @Override
    public void addMultipleYAxis(List<RectangleAxis> axes) {
        this.yAxes.addAll(axes);
    }

    @Override
    public void setRadiusAxis(Axis axis) {
        return;
    }

    @Override
    public void setAngleAxis(Axis axis) {
        return;
    }
}
