package com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate.axis;

import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.ChartElement;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

/**
 * @author wuyang
 * @desc 坐标轴
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class Axis extends ChartElement {

    private static final long serialVersionUID = 2209944068783946813L;

    /**
     * 坐标轴保留最大小数位数。
     * 目前设置6位，以防前端计算异常
     */
    private static final int MAX_SCALE = 6;

    /**
     * 舍入类型
     */
    private static final int DEFAULT_ROUND_TYPE = BigDecimal.ROUND_DOWN;

    /**
     * 表示坐标轴类型。有数值轴(value)、类目轴(category)、时间轴(time)
     */
    protected String type;
    /**
     * 坐标轴名称（标签）
     */
    protected String name;
    /**
     * 坐标轴的最小值（仅当type=value时有效），最多保留MAX_SCALE指定的位数以免前端异常
     */
    protected Double min;
    /**
     * 坐标轴的最大值（仅当type=value时有效），最多保留MAX_SCALE指定的位数以免前端异常
     */
    protected Double max;
    /**
     * 坐标轴刻度的间隔（仅当type=value时有效）
     */
    protected Double interval;
    /**
     * 坐标轴刻度数据
     */
    protected List<String> data;

    public Axis(String type) {
        this.type = type;
    }

    public void setMin(Double min) {
        if (Objects.equals(this.type, AxisTypeEnum.VALUE.getValue())) {
            this.min = new BigDecimal(Double.toString(min)).setScale(MAX_SCALE, DEFAULT_ROUND_TYPE).doubleValue();
        }
    }

    public void setMax(Double max) {
        if (Objects.equals(this.type, AxisTypeEnum.VALUE.getValue())) {
            this.max = new BigDecimal(Double.toString(max)).setScale(MAX_SCALE, DEFAULT_ROUND_TYPE).doubleValue();
        }
    }

    public void setInterval(Double interval) {
        if (Objects.equals(this.type, AxisTypeEnum.VALUE.getValue())) {
            this.interval = new BigDecimal(Double.toString(interval)).setScale(MAX_SCALE, DEFAULT_ROUND_TYPE).doubleValue();
        }
    }
}
