package com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate.axis;

import java.util.Objects;

/**
 * <p>功能描述：坐标轴类型枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AxisTypeEnum
 * @Author: zaregoto
 * @Date: 2023/11/27 11:03
 */
public enum AxisTypeEnum {
    /**
     * 类目型轴，轴上的数据是离散的
     */
    CATEGORY("category"),

    /**
     * 数值型轴，轴上的数据是连续的
     */
    VALUE("value");

    private final String value;

    AxisTypeEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static AxisTypeEnum getEnumByValue(String value) {
        for (AxisTypeEnum testedEnum : AxisTypeEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
