package com.digiwin.mobile.mobileuibot.core.component.chart.chartelement;

import com.digiwin.mobile.mobileuibot.core.component.chart.chartstyle.ChartElementStyle;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @author wuyang
 * @desc 图表元素
 */
@Data
@Accessors(chain = true)
public abstract class ChartElement implements Serializable {

    private static final long serialVersionUID = 5701619362614511557L;
    /**
     * 是否显示当前元素
     */
    protected Boolean elementShow = true;
    /**
     * 图表元素样式
     */
    protected ChartElementStyle elementStyle = new ChartElementStyle();

    public void setWidth(Double width) {
        this.elementStyle.setWidth(width);
    }

    public void setHeight(Double height) {
        this.elementStyle.setHeight(height);
    }

    public void setBorderWidth(Double borderWidth) {
        this.elementStyle.setBorderWidth(borderWidth);
    }

    public void setBorderColor(String borderColorHex) {
        this.elementStyle.setBorderColor(borderColorHex);
    }

    public void setBackgroundColor(String backgroundColorHex) {
        this.elementStyle.setBackgroundColor(backgroundColorHex);
    }

    public void setColor(String colorHex) {
        this.elementStyle.setColor(colorHex);
    }

    public void setFontSize(Integer fontSize) {
        this.elementStyle.getFont().setSize(fontSize);
    }

    public void setFontColor(String colorHex) {
        this.elementStyle.getFont().setColor(colorHex);
    }
}
