package com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.chartlegend;

import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.ChartElement;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableDecimalRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableUnit;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * @author wuyang
 * @desc 图例数据
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class ChartLegendData extends ChartElement {

    private static final long serialVersionUID = 2697042480021036928L;

    /**
     * 图例名称
     */
    private String name;
    /**
     * 名称的格式
     */
    private String formatter;

    /**
     * 图例对应的图表类型
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.chart.ChartTypeEnum
     */
    private String chartType;

    /**
     * 指标单位
     */
    private String businessType;

    /**
     * 数据计算逻辑说明
     */
    private String description;

    /**
     * 舍入方式
     */
    private UiBotTableDecimalRule decimalRule;

    /**
     * 计算单位
     */
    private UiBotTableUnit unit;

    /**
     * 统计指标是否需要使用百分号，或千分位显示
     * 当使用百分号时，值为percent；
     * 当使用千分位时，值为thousand
     */
    private String percent;

    /**
     * 统计指标的显示精度
     */
    private Integer decimal;

}