package com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.markline;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartstyle.ChartColorPalette;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDataItem;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartMarkLine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartMarkLineFunTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartValueField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.ChartRenderSetting;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.*;

/**
 * <p>功能描述：图表标线配置</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ChartMarkLine
 * @Author: zaregoto
 * @Date: 2024/1/23 19:15
 */
@Accessors(chain = true)
@Data
public class ChartMarkLine implements Serializable {
    private static final long serialVersionUID = 6153553149733744631L;

    private List<ChartMarkLineItem> data = new ArrayList<>();

    /**
     * 根据中间态图表标线配置，生成移动端折线图的标线配置
     *
     * @param intermediateDataItem 中间态DSL的一项数据
     * @return
     */
    public static ChartMarkLine buildLineChartMarkLine(AgileDataIntermediateDataItem intermediateDataItem) {
        ChartRenderSetting chartRenderSetting = intermediateDataItem.getChartRenderSetting();

        List<AgileDataChartValueField> values = chartRenderSetting.getValues();
        Map<String, String> valueFieldColorMap = new HashMap<>(values.size());
        for (int j = 0; j < values.size(); j++) {
            AgileDataChartValueField valueField = values.get(j);
            String lineColor = ChartColorPalette.getColorFromCategoryPalette(j, values.size());
            valueFieldColorMap.put(valueField.getName(), lineColor);
        }
        return buildChartMarkLine(intermediateDataItem, valueFieldColorMap);
    }

    /**
     * 根据中间态图表标线配置，生成移动端柱状图的标线配置
     *
     * @param intermediateDataItem 中间态DSL的一项数据
     * @param valueFieldColorMap   Y轴字段与呈现颜色的映射
     * @return
     */
    public static ChartMarkLine buildBarChartMarkLine(AgileDataIntermediateDataItem intermediateDataItem,
                                                      Map<String, String> valueFieldColorMap) {
        return buildChartMarkLine(intermediateDataItem, valueFieldColorMap);
    }

    /**
     * 根据中间态图表标线配置，生成移动端图表的标线配置（支持柱状和折线）
     *
     * @param intermediateDataItem 中间态DSL的一项数据
     * @param valueFieldColorMap   Y轴字段与呈现颜色的映射
     * @return
     */
    private static ChartMarkLine buildChartMarkLine(AgileDataIntermediateDataItem intermediateDataItem,
                                                    Map<String, String> valueFieldColorMap) {
        ChartRenderSetting chartRenderSetting = intermediateDataItem.getChartRenderSetting();
        AgileDataChartMarkLine agileDataChartMarkLine = chartRenderSetting.getMarkLine();

        ChartMarkLine chartMarkLine = new ChartMarkLine();
        if (Objects.isNull(agileDataChartMarkLine) || CollectionUtils.isEmpty(agileDataChartMarkLine.getData())) {
            return null;
        }
        List<AgileDataChartValueField> valueFields = chartRenderSetting.getValues();

        agileDataChartMarkLine.getData().forEach(aMarkLineItem -> {
            String applyToValueField = aMarkLineItem.getApplyToValueField();
            Optional<AgileDataChartValueField> optValueField = valueFields.stream()
                    .filter(v -> Objects.equals(v.getName(), applyToValueField))
                    .findFirst();
            if (optValueField.isPresent()) {
                AgileDataChartValueField valueField = optValueField.get();
                // 根据统计值字段，取出数据集，存入统计对象
                DescriptiveStatistics stats = new DescriptiveStatistics();
                for (JSONObject pageDatum : intermediateDataItem.getPageData()) {
                    stats.addValue(pageDatum.getDoubleValue(valueField.getName()));
                }
                AgileDataChartMarkLineFunTypeEnum lineFunTypeEnum = AgileDataChartMarkLineFunTypeEnum
                        .getEnumByValue(aMarkLineItem.getType());
                if (null != lineFunTypeEnum) {
                    ChartMarkLineItem markLineItem = new ChartMarkLineItem();
                    Double lineValue = 0.0;
                    switch (lineFunTypeEnum) {
                        case AVG:
                            lineValue = stats.getMean();
                            break;
                        case MIN:
                            lineValue = stats.getMin();
                            break;
                        case MAX:
                            lineValue = stats.getMax();
                            break;
                        default:
                            lineValue = 0.0;
                            break;
                    }
                    markLineItem.setyAxis(lineValue);
                    markLineItem.setColor(valueFieldColorMap.getOrDefault(applyToValueField, ChartColorPalette.GlobalColorPalette.MARK_LINE_COLOR));
                    markLineItem.setLineType(ChartMarkLineTypeEnum.DASHED.getValue());
                    markLineItem.setLabel(valueField.getFormat().getFormattedString(lineValue));

                    chartMarkLine.addChartMarkLineItem(markLineItem);
                }
            }
        });

        return chartMarkLine;
    }

    public void addChartMarkLineItem(ChartMarkLineItem item) {
        this.data.add(item);
    }

    public void removeChartMarkLineItem(ChartMarkLineItem item) {
        this.data.remove(item);
    }

    public void removeChartMarkLineItem(int index) {
        this.data.remove(index);
    }
}
