package com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.markline;

import com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.ChartElement;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>功能描述：图表标线配置项</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ChartMarkLineItem
 * @Author: zaregoto
 * @Date: 2024/1/23 19:15
 */
@Accessors(chain = true)
@Data
public class ChartMarkLineItem extends ChartElement {
    private static final long serialVersionUID = -6318183293981610878L;

    /**
     * 标线名称
     */
    private String name;

    /**
     * 标线类型
     *
     * @see ChartMarkLineTypeEnum
     */
    private Integer lineType;

    /**
     * 标线所在Y轴坐标（与xAxis互斥，若set了，则会同时清除xAxis）
     */
    private Double yAxis;

    /**
     * 标线所在X轴坐标（与yAxis互斥，若set了，则会同时清除yAxis）
     */
    private String xAxis;

    /**
     * 标线展示的文字标签
     */
    private String label;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getLineType() {
        return lineType;
    }

    public void setLineType(Integer lineType) {
        this.lineType = lineType;
    }

    public Double getyAxis() {
        return yAxis;
    }

    public void setyAxis(Double yAxis) {
        this.yAxis = yAxis;
        this.xAxis = null;
    }

    public String getxAxis() {
        return xAxis;
    }

    public void setxAxis(String xAxis) {
        this.xAxis = xAxis;
        this.yAxis = null;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }
}