package com.digiwin.mobile.mobileuibot.core.component.chart.chartelement.markline;

import java.util.Objects;

/**
 * <p>功能描述：图表标线类型枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ChartMarkLineTypeEnum
 * @Author: zaregoto
 * @Date: 2024/1/23 19:21
 */
public enum ChartMarkLineTypeEnum {
    /**
     * 实线：——
     */
    SOLID(1),

    /**
     * 点虚线：···
     */
    DOTTED(2),

    /**
     * 短划线：---
     */
    DASHED(3);

    private final Integer value;

    ChartMarkLineTypeEnum(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }

    public static ChartMarkLineTypeEnum getEnumByValue(Integer value) {
        for (ChartMarkLineTypeEnum testedEnum : ChartMarkLineTypeEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
