package com.digiwin.mobile.mobileuibot.core.component.chart.chartseries;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartGroupByField;

import java.util.Comparator;
import java.util.List;

/**
 * <p>功能描述：柱状图生成数据时，每个X轴分类下多个数据的排序器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BarChartGroupedDataComparator
 * @Author: zaregoto
 * @Date: 2023/12/7 20:32
 */
public class BarChartGroupedDataComparator implements Comparator<JSONObject> {

    private List<AgileDataChartGroupByField> sortFields;

    public BarChartGroupedDataComparator(List<AgileDataChartGroupByField> sortFields) {
        this.sortFields = sortFields;
    }

    @Override
    public int compare(JSONObject obj1, JSONObject obj2) {
        for (AgileDataChartGroupByField groupByField : sortFields) {
            Object value1 = obj1.get(groupByField.getName());
            Object value2 = obj2.get(groupByField.getName());

            if (value1 instanceof Comparable && value2 instanceof Comparable) {
                int comparison = ((Comparable) value1).compareTo(value2);
                if (comparison != 0) {
                    return comparison;
                }
            } else {
                // 非Comparable类型，你可能需要自定义比较逻辑或抛出异常
            }
        }
        // 所有字段相等，返回0
        return 0;
    }
}