package com.digiwin.mobile.mobileuibot.core.component.chart.chartseries;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartGroupByField;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：依维度字段分类的柱状图预处理数据，用于支持某个类目在某一统计轴下有多组数据的情况</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BarChartPreprocessDataByPoint
 * @Author: zaregoto
 * @Date: 2023/12/7 19:05
 */
@Data
@Accessors(chain = true)
public class BarChartPreprocessDataByPoint implements Serializable {

    /**
     * 字段ID
     * 如：customerName
     */
    private String fieldId;

    /**
     * 含义同AgileDataChartPointField下的同名属性
     */
    private List<AgileDataChartGroupByField> groupBys;

    /**
     * 字段分类值与对应值清单的映射
     * 如：key=小米, value=[{"customerName":小米, "orderQty":1234, "area":"上海"},{"customerName":小米, "saleQty":5678, "area":"湖州"}]
     */
    private Map<String, List<JSONObject>> fieldCategorizedValues;
}