package com.digiwin.mobile.mobileuibot.core.component.chart.chartseries;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataAnalysisData;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>功能描述：一维图表数据对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: OneDimensionalChartData
 * @Author: zaregoto
 * @Date: 2023/11/27 22:45
 */
@Data
@Accessors(chain = true)
public class OneDimensionalChartData extends ChartData {
    private static final long serialVersionUID = -2613508414538850192L;

    /**
     * 数据项名称（和图例名称应保持一致）
     */
    protected String name;
    /**
     * 数据值
     */
    protected Double value;
    /**
     * 数据标签
     */
    protected String label;
    /**
     * 是否显示数据标签
     */
    protected Boolean showLabel = true;

    /**
     * 数据使用的Y轴索引（柱状图时出现2个Y轴时使用）
     */
    @JSONField(name = "yAxisIndex")
    @JsonProperty(value = "yAxisIndex")
    private Integer yAxisIndex;

    /**
     * 用户筛选维度条件
     */
    private List<AgileDataAnalysisData> dimensionData;

    /**
     * 用户筛选度量条件
     */
    private List<AgileDataAnalysisData> measurementData;


}