package com.digiwin.mobile.mobileuibot.core.component.chart.chartseries;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataAnalysisData;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author wuyang
 * @desc 饼图数据
 */
@Data
@Accessors(chain = true)
public class PieChartData extends OneDimensionalChartData {

    private static final long serialVersionUID = -3014773086573602071L;


    @Override
    public PieChartData setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public PieChartData setValue(Double value) {
        super.setValue(value);
        return this;
    }

    @Override
    public PieChartData setLabel(String label) {
        super.setLabel(label);
        return this;
    }

    @Override
    public PieChartData setShowLabel(Boolean showLabel) {
        super.setShowLabel(showLabel);
        return this;
    }

    @Override
    public PieChartData setDimensionData(List<AgileDataAnalysisData> dimensionData) {
        super.setDimensionData(dimensionData);
        return this;
    }

    @Override
    public PieChartData setMeasurementData(List<AgileDataAnalysisData> measurementData) {
        super.setMeasurementData(measurementData);
        return this;
    }
}