package com.digiwin.mobile.mobileuibot.core.component.chart.chartseries;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>功能描述：二维图表数据对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TwoDimensionalChartData
 * @Author: zaregoto
 * @Date: 2023/11/27 22:53
 */
@Data
@Accessors(chain = true)
public abstract class TwoDimensionalChartData extends ChartData {
    private static final long serialVersionUID = 6054953472383357011L;

    /**
     * 维度轴数据
     */
    protected String x;
    /**
     * 统计轴数据
     */
    protected List<OneDimensionalChartData> y;

    /**
     * Y轴方向
     */
    protected String yDirection;

    @JsonProperty("yDifferLabel")
    @JSONField(name = "yDifferLabel")
    protected YDifferLabel yDifferLabel;
}