package com.digiwin.mobile.mobileuibot.core.component.chart.chartseries;

import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：柱状图Y值差异标签</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: YDifferLabel
 * @Author: zaregoto
 * @Date: 2024/1/24 20:20
 */
@Accessors(chain = true)
@Data
public class YDifferLabel implements Serializable {
    private static final long serialVersionUID = 8732216506637224084L;

    private List<YDifferLabelDataItem> data = new ArrayList<>();

    public void addYDifferLabelDataItem(YDifferLabelDataItem item) {
        if (CollectionUtils.isEmpty(this.data)) {
            this.data = new ArrayList<>();
        }
        this.data.add(item);
    }

    public void removeYDifferLabelDataItem(int index) {
        if (CollectionUtils.isEmpty(this.data)) {
            return;
        }
        this.data.remove(index);
    }
}