package com.digiwin.mobile.mobileuibot.core.component.chart.chartseries;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartFieldDisplayFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AccessLevel;
import lombok.Data;
import lombok.Setter;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;

import java.io.Serializable;

/**
 * <p>功能描述：柱状图Y值差异标签数据明细项</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: YDifferLabelDataItem
 * @Author: zaregoto
 * @Date: 2024/1/24 20:21
 */
@Slf4j
@Accessors(chain = true)
@Data
public class YDifferLabelDataItem implements Serializable {
    private static final long serialVersionUID = -7440790156485828816L;

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private AgileDataChartFieldDisplayFormat format;

//    /**
//     * 差异起始数值
//     */
//    private Double startValue;
//
//    /**
//     * 差异结束数值
//     */
//    private Double endValue;

    /**
     * 差异起始数值所在柱状图索引
     */
    private Integer startIndex;

    /**
     * 差异结束数值所在柱状图索引
     */
    private Integer endIndex;

//    /**
//     * 差值
//     */
//    private Double differ;

    /**
     * 差值比率
     */
    private Double differRate;

    /**
     * 差值标签呈现文字，结合format做显示
     */
    @Setter(AccessLevel.NONE)
    private String label;

    public YDifferLabelDataItem(AgileDataChartFieldDisplayFormat format) {
        this.format = format;
    }

    public String getLabel() {
        if (null != this.format && null != this.differRate) {
            String tempLabel = this.format.getFormattedString(differRate);
            return this.differRate > 0 ? "+" + tempLabel : tempLabel;
        }
        log.debug("differ label cannot be generated...");
        return "";
    }
}