package com.digiwin.mobile.mobileuibot.core.component.chart.chartstyle;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @author wuyang
 * @desc 图表元素样式
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class ChartElementStyle implements Serializable {
    private static final long serialVersionUID = 5626230392667937268L;

    /**
     * 元素宽度
     */
    protected Double width;
    /**
     * 元素高度
     */
    protected Double height;
    /**
     * 边框宽度
     */
    protected Double borderWidth;
    /**
     * 边框颜色。使用十六进制，如：#5470c6
     */
    protected String borderColor;
    /**
     * 元素背景色。使用十六进制，如：#5470c6
     */
    protected String backgroundColor;
    /**
     * 元素颜色。使用十六进制，如：#5470c6
     */
    protected String color;
    /**
     * 元素字体
     */
    protected ChartFont font = new ChartFont();

//    /**
//     * 构建字体
//     *
//     * @return
//     */
//    public abstract ChartFont buildFont();
}
