package com.digiwin.mobile.mobileuibot.core.component.chart.mobilechart;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

/**
 * 柱状图
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class BarChart extends BaseMobileComponent {

    private static final long serialVersionUID = -7483599768207035069L;
    
    public static final String COMPONENT_TYPE = "CHART_BAR";


    //名称
    private String title;


    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        BarChart barChart = new BarChart();
        barChart.setComponentId(rawContent.getComponentId());
        barChart.setTitle(rawContent.getLabel());
        barChart.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return barChart;
    }

    @Override
    public String returnComponentType() {
        return BarChart.COMPONENT_TYPE;
    }
}
