package com.digiwin.mobile.mobileuibot.core.component.chart.mobilechart;

import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotJumpAction;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class ChartData {

    private String label;  // 标签

    private String schema; // 字段路径，用于查找源数据

    private String value; //具体数据

    private Setting setting;


    @Data
    public static
    class Setting {

        //背景色
        private String bgColor;

        private String color = ColorFontEnum.DARK_GRAY.getHexValue();  // 颜色

        //开发平台的action字段
        private UiBotJumpAction action;

        //给前端的跳转button
        private Button button;
    }

}
