package com.digiwin.mobile.mobileuibot.core.component.chart.mobilechart;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

/**
 * 仪表盘
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DashboardChart extends BaseMobileComponent {

    private static final long serialVersionUID = 4760952488279512760L;

    public static final String COMPONENT_TYPE = "CHART_DASHBOARD";

    //名称
    private String title;

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        DashboardChart dashboardChart = new DashboardChart();
        dashboardChart.setComponentId(rawContent.getComponentId());
        dashboardChart.setTitle(rawContent.getLabel());
        dashboardChart.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return dashboardChart;
    }

    @Override
    public String returnComponentType() {
        return DashboardChart.COMPONENT_TYPE;
    }
}
