package com.digiwin.mobile.mobileuibot.core.component.chart.mobilechart;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.CommonRawDataParentType;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.DataSource;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotJumpAction;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;;

/**
 * 移动指标卡图表组件
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class IndicatorChart extends BaseMobileComponent {
    private static final long serialVersionUID = -6054261048980053277L;

    public static final String COMPONENT_TYPE = "CHART_INDICATOR";

    //名称
    private String title;
    //名称是否可显示
    private Boolean titleVisible = false;
    //指标数据支持千分位
    Boolean thousandthPlace = true;

    //文字和数字位置 FontPositionEnum
    private Integer fontPosition = FontPositionEnum.FONT_ABOVE.getType();

    //超出一行是否滑动，默认false
    private Boolean slide = false;

    //布局样式 LayoutStyleEnum
    private Integer layoutStyle = LayoutStyleEnum.NEWLINE.getType();

    //数据源--表单内生效
    private DataSource dataSource;
    //指标数据
    private List<ChartData> chartData;

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);

        //超出一行是否滑动设置为true，则设置水平布局(水平布局支持滑动)，否则设置换行布局
        this.layoutStyle = BooleanUtils.isTrue(slide) ? LayoutStyleEnum.LEVEL.getType() : LayoutStyleEnum.NEWLINE.getType();

        //单独组件拥有自己的数据源，卡片内的图表数据源来源于卡片,卡片的数据要要么直接配置一个对象，要么配置一个数组默认取数组的第一个元素
        //这个取决于ISV怎么配置数据源
        super.resetCmptMultipleDataSourceData(cmptContext, executeContext, this.dataSource, data);
        //根据schema获取真实的数据
        Object value = UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
        if (ObjectUtils.isEmpty(value)) {
            setDefaultValue(chartData);
            return;
        }
        Map<String, Object> rawMap;
        if (value instanceof Map) {
            rawMap = JsonUtil.objectToJavaObject(value, new TypeReference<Map<String, Object>>() {
            });
        } else if (value instanceof List) {
            if (!CollectionUtils.isEmpty((List) value)) {
                rawMap = JsonUtil.objectToJavaObject(value, new TypeReference<List<Map<String, Object>>>() {
                }).get(0);
            } else {
                setDefaultValue(chartData);
                return;
            }
        } else {
            //表单内的卡片数据源是其他类型的话直接返回
            setDefaultValue(chartData);
            return;

        }
        for (ChartData chart : chartData) {
            chart.setValue(String.valueOf(rawMap.get(chart.getSchema())));
            //setting 没有的话不构建
            UiBotJumpAction uiBotJumpAction = chart.getSetting().getAction();
            if (ObjectUtils.isNotEmpty(uiBotJumpAction)) {
                Button button = new Button();
                UiBotAction UiBotAction = new UiBotAction();
                UiBotAction.setBtnType("jump");
                UiBotAction.setType("");
                UiBotAction.setJumpAction(uiBotJumpAction);
                button.setSubmitAction(UiBotAction);
                //图表中的跳转默认需要rawdata
                cmptContext.setCommonRawDataParentType(CommonRawDataParentType.ALONE_BUTTON.getValue());
                button.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
                chart.getSetting().setButton(button);
            }

        }
    }

    public void setDefaultValue(List<ChartData> chartData) {
        chartData.forEach(
                chart -> {
                    chart.setValue("-1");
                });
    }

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        IndicatorChart chartIndicator = new IndicatorChart();
        chartIndicator.setComponentId(rawContent.getComponentId());
        //将配置中的setting转化成成对象
        Card.DesignerRawCard.Content.IndicatorChartObj chartIndicatorObj = JsonUtil.objectToJavaObject(rawContent.getSetting(), Card.DesignerRawCard.Content.IndicatorChartObj.class);
        if (chartIndicatorObj != null) {
            chartIndicator.setTitle(chartIndicatorObj.getTitle());
            chartIndicator.setTitleVisible(chartIndicatorObj.getTitleVisible());
            chartIndicator.setChartData(chartIndicatorObj.getChartData());
            chartIndicator.setThousandthPlace(chartIndicatorObj.getThousandthPlace());
        }
        chartIndicator.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return chartIndicator;
    }


    @Override
    public String returnComponentType() {
        return IndicatorChart.COMPONENT_TYPE;
    }
}
