package com.digiwin.mobile.mobileuibot.core.component.chart.mobilechart;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

/**
 * 折线图
 */

@Data
@NoArgsConstructor
@AllArgsConstructor
public class LineChart extends BaseMobileComponent {

    private static final long serialVersionUID = -780507074675618080L;

    public static final String COMPONENT_TYPE = "CHART_LINE";

    //名称
    private String title;

    public static BaseMobileComponent cardContentConvertComponent(Card.DesignerRawCard.Content rawContent, ComponentContext cmptContext, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        LineChart lineChart = new LineChart();
        lineChart.setComponentId(rawContent.getComponentId());
        lineChart.setTitle(rawContent.getLabel());
        lineChart.handleComponentParam(cmptContext, rawContent.getFullPath(), rawContent.getSchema(), data, executeContext, mobilePageRawData);
        return lineChart;
    }

    @Override
    public String returnComponentType() {
        return LineChart.COMPONENT_TYPE;
    }
}
